/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.CustomInterceptorMetadata;
import org.jboss.weld.interceptor.reader.InterceptorMetadataImpl;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.PlainInterceptorFactory;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class InterceptorMetadataReader {
    private final BeanManagerImpl manager;
    private final LoadingCache<Class<?>, InterceptorClassMetadata<?>> plainInterceptorMetadataCache;
    private final LoadingCache<Interceptor<?>, InterceptorClassMetadata<?>> cdiInterceptorMetadataCache;
    private final Function<Interceptor<?>, InterceptorClassMetadata<?>> interceptorToInterceptorMetadataFunction;

    public InterceptorMetadataReader(final BeanManagerImpl manager) {
        this.manager = manager;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        this.plainInterceptorMetadataCache = cacheBuilder.build(new CacheLoader<Class<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> load(Class<?> key) throws Exception {
                EnhancedAnnotatedType<?> type2 = manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(key, manager.getId());
                PlainInterceptorFactory<?> factory = PlainInterceptorFactory.of(key, manager);
                return new InterceptorMetadataImpl(key, factory, InterceptorMetadataUtils.buildMethodMap(type2, false, manager));
            }
        });
        this.cdiInterceptorMetadataCache = cacheBuilder.build(new CacheLoader<Interceptor<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> load(Interceptor<?> key) throws Exception {
                return CustomInterceptorMetadata.of(key);
            }
        });
        this.interceptorToInterceptorMetadataFunction = new Function<Interceptor<?>, InterceptorClassMetadata<?>>(){

            @Override
            public InterceptorClassMetadata<?> apply(Interceptor<?> input) {
                return InterceptorMetadataReader.this.getCdiInterceptorMetadata(input);
            }
        };
    }

    public <T> InterceptorClassMetadata<T> getPlainInterceptorMetadata(Class<T> clazz) {
        return (InterceptorClassMetadata)LoadingCacheUtils.getCastCacheValue(this.plainInterceptorMetadataCache, clazz);
    }

    public <T> TargetClassInterceptorMetadata getTargetClassInterceptorMetadata(EnhancedAnnotatedType<T> type2) {
        return TargetClassInterceptorMetadata.of(InterceptorMetadataUtils.buildMethodMap(type2, true, this.manager));
    }

    public <T> InterceptorClassMetadata<T> getCdiInterceptorMetadata(Interceptor<T> interceptor) {
        if (interceptor instanceof InterceptorImpl) {
            InterceptorImpl interceptorImpl = (InterceptorImpl)interceptor;
            return interceptorImpl.getInterceptorMetadata();
        }
        return (InterceptorClassMetadata)LoadingCacheUtils.getCastCacheValue(this.cdiInterceptorMetadataCache, interceptor);
    }

    public Function<Interceptor<?>, InterceptorClassMetadata<?>> getInterceptorToInterceptorMetadataFunction() {
        return this.interceptorToInterceptorMetadataFunction;
    }

    public void cleanAfterBoot() {
        this.plainInterceptorMetadataCache.invalidateAll();
        this.plainInterceptorMetadataCache.cleanUp();
        this.cdiInterceptorMetadataCache.invalidateAll();
        this.cdiInterceptorMetadataCache.cleanUp();
    }
}

