/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.bean.proxy.DecoratorProxyFactory;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.Decorators;

public class DecoratorInjectionTarget<T>
extends BeanInjectionTarget<T> {
    private final WeldInjectionPointAttributes<?, ?> delegateInjectionPoint;
    private final Field accessibleField;

    public DecoratorInjectionTarget(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl beanManager) {
        super(type2, bean, beanManager);
        this.delegateInjectionPoint = Decorators.findDelegateInjectionPoint(type2, this.getInjectionPoints());
        if (this.delegateInjectionPoint instanceof FieldInjectionPoint) {
            FieldInjectionPoint fip = (FieldInjectionPoint)this.delegateInjectionPoint;
            this.accessibleField = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Field>(fip.getAnnotated().getJavaMember()));
        } else {
            this.accessibleField = null;
        }
        this.checkAbstractMethods(type2);
    }

    @Override
    protected Instantiator<T> initInstantiator(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        if (type2.isAbstract()) {
            ConstructorInjectionPoint<T> originalConstructor = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, type2, beanManager);
            injectionPoints.addAll(originalConstructor.getParameterInjectionPoints());
            final WeldInjectionPointAttributes<?, ?> delegateInjectionPoint = Decorators.findDelegateInjectionPoint(type2, injectionPoints);
            return new SubclassedComponentInstantiator<T>(type2, bean, originalConstructor, beanManager){

                @Override
                protected Class<T> createEnhancedSubclass(EnhancedAnnotatedType<T> type2, Bean<?> bean, BeanManagerImpl manager) {
                    return new DecoratorProxyFactory(manager.getContextId(), type2.getJavaClass(), delegateInjectionPoint, bean).getProxyClass();
                }
            };
        }
        DefaultInstantiator<T> instantiator = new DefaultInstantiator<T>(type2, bean, beanManager);
        injectionPoints.addAll(instantiator.getConstructorInjectionPoint().getParameterInjectionPoints());
        return instantiator;
    }

    @Override
    protected void checkDelegateInjectionPoints() {
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        super.inject(instance, ctx);
        if (this.accessibleField != null && instance instanceof DecoratorProxy) {
            Object delegate;
            try {
                delegate = this.accessibleField.get(instance);
            }
            catch (IllegalAccessException e) {
                throw UtilLogger.LOG.accessErrorOnField(this.accessibleField.getName(), this.accessibleField.getDeclaringClass(), e);
            }
            ProxyMethodHandler handler = new ProxyMethodHandler(this.beanManager.getContextId(), new TargetBeanInstance(delegate), this.getBean());
            ((ProxyObject)instance).setHandler(handler);
        }
    }

    @Override
    public void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
    }

    private void checkAbstractMethods(EnhancedAnnotatedType<T> type2) {
        if (!type2.isAbstract()) {
            return;
        }
        Set<Type> decoratedTypes = null;
        Bean bean = this.getBean();
        if (bean != null && bean instanceof DecoratorImpl) {
            decoratedTypes = ((DecoratorImpl)bean).getDecoratedTypes();
        }
        Decorators.checkAbstractMethods(decoratedTypes, type2, this.beanManager);
    }
}

