/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.injection.ThreadLocalStack;
import org.jboss.weld.manager.BeanManagerImpl;

public class FastEvent<T> {
    private final ResolvedObservers<T> resolvedObserverMethods;

    public static <T> FastEvent<T> of(Class<T> type2, BeanManagerImpl manager, Annotation ... qualifiers) {
        return FastEvent.of(type2, manager, manager.getAccessibleLenientObserverNotifier(), qualifiers);
    }

    public static <T> FastEvent<T> of(Class<T> type2, BeanManagerImpl manager, ObserverNotifier notifier, Annotation ... qualifiers) {
        ResolvedObservers resolvedObserverMethods = notifier.resolveObserverMethods(notifier.buildEventResolvable(type2, qualifiers));
        if (resolvedObserverMethods.isMetadataRequired()) {
            EventMetadataImpl metadata = new EventMetadataImpl(type2, null, qualifiers);
            CurrentEventMetadata metadataService = manager.getServices().get(CurrentEventMetadata.class);
            return new FastEventWithMetadataPropagation(resolvedObserverMethods, metadata, metadataService);
        }
        return new FastEvent(resolvedObserverMethods);
    }

    private FastEvent(ResolvedObservers<T> resolvedObserverMethods) {
        this.resolvedObserverMethods = resolvedObserverMethods;
    }

    public void fire(T event) {
        for (ObserverMethod<T> observer : this.resolvedObserverMethods.getImmediateObservers()) {
            observer.notify(event);
        }
    }

    private static class FastEventWithMetadataPropagation<T>
    extends FastEvent<T> {
        private final EventMetadata metadata;
        private final CurrentEventMetadata metadataService;

        private FastEventWithMetadataPropagation(ResolvedObservers<T> resolvedObserverMethods, EventMetadata metadata, CurrentEventMetadata metadataService) {
            super(resolvedObserverMethods);
            this.metadata = metadata;
            this.metadataService = metadataService;
        }

        @Override
        public void fire(T event) {
            ThreadLocalStack.ThreadLocalStackReference<EventMetadata> stack = this.metadataService.pushIfNotNull(this.metadata);
            try {
                super.fire(event);
            }
            finally {
                stack.pop();
            }
        }
    }
}

