/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.code;

import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.LocalVariableState;
import org.jboss.classfilewriter.code.StackEntry;
import org.jboss.classfilewriter.code.StackEntryType;
import org.jboss.classfilewriter.code.StackFrameType;
import org.jboss.classfilewriter.code.StackState;

public class StackFrame {
    private final StackState stackState;
    private final LocalVariableState localVariableState;
    private final StackFrameType type;

    public StackFrame(ClassMethod method) {
        this.stackState = new StackState(method.getClassFile().getConstPool());
        this.localVariableState = new LocalVariableState(method);
        this.type = StackFrameType.FULL_FRAME;
    }

    public StackFrame(StackState stackState, LocalVariableState localVariableState, StackFrameType type2) {
        this.stackState = stackState;
        this.localVariableState = localVariableState;
        this.type = type2;
    }

    public StackState getStackState() {
        return this.stackState;
    }

    public LocalVariableState getLocalVariableState() {
        return this.localVariableState;
    }

    public StackFrame push(String type2) {
        StackState ns = this.stackState.push(type2);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame push(StackEntry entry) {
        StackState ns = this.stackState.push(entry);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame aconstNull() {
        StackState ns = this.stackState.aconstNull();
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop(int no) {
        StackState ns = this.stackState.pop(no);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop() {
        StackState ns = this.stackState.pop(1);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop2() {
        StackState ns = this.stackState.pop(2);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop3() {
        StackState ns = this.stackState.pop(3);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop4() {
        StackState ns = this.stackState.pop(4);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame replace(String type2) {
        StackState ns = this.stackState.pop(1).push(type2);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame dup() {
        StackState ns = this.stackState.dup();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame dupX1() {
        StackState ns = this.stackState.dupX1();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame dupX2() {
        StackState ns = this.stackState.dupX2();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame dup2() {
        StackState ns = this.stackState.dup2();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame dup2X1() {
        StackState ns = this.stackState.dup2X1();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame dup2X2() {
        StackState ns = this.stackState.dup2X2();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    public StackFrame store(int no) {
        LocalVariableState ls;
        StackState ns;
        StackEntry top = this.stackState.top();
        if (top.getType() == StackEntryType.TOP) {
            StackEntry type2 = this.stackState.top_1();
            ns = this.stackState.pop(2);
            ls = this.localVariableState.storeWide(no, type2);
        } else {
            StackEntry type3 = this.stackState.top();
            ns = this.stackState.pop(1);
            ls = this.localVariableState.store(no, type3);
        }
        return new StackFrame(ns, ls, StackFrameType.FULL_FRAME);
    }

    public StackFrame pop2push1(String type2) {
        StackState ns = this.stackState.pop(2).push(type2);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public StackFrame pop4push1(String type2) {
        StackState ns = this.stackState.pop(4).push(type2);
        return new StackFrame(ns, this.localVariableState, this.typeNoLocalChange(ns));
    }

    public String toString() {
        return "StackFrame [localVariableState=" + this.localVariableState + ", stackState=" + this.stackState + "]";
    }

    public StackFrame constructorCall(int initializedValueStackPosition) {
        StackEntry entry = this.stackState.getContents().get(this.stackState.getContents().size() - 1 - initializedValueStackPosition);
        StackState ns = this.stackState.constructorCall(initializedValueStackPosition, entry);
        LocalVariableState locals = this.localVariableState.constructorCall(entry);
        return new StackFrame(ns, locals, StackFrameType.FULL_FRAME);
    }

    public StackFrame swap() {
        StackState ns = this.stackState.swap();
        return new StackFrame(ns, this.localVariableState, StackFrameType.FULL_FRAME);
    }

    private StackFrameType typeNoLocalChange(StackState ns) {
        int size = ns.getContents().size();
        if (size == 0) {
            return StackFrameType.SAME_FRAME;
        }
        if (size == 1) {
            return StackFrameType.SAME_LOCALS_1_STACK;
        }
        return StackFrameType.FULL_FRAME;
    }

    public StackFrameType getType() {
        return this.type;
    }
}

