/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.jboss.classfilewriter.annotations.AnnotationAnnotationValue;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.annotations.ArrayAnnotationValue;
import org.jboss.classfilewriter.annotations.BooleanAnnotationValue;
import org.jboss.classfilewriter.annotations.ByteAnnotationValue;
import org.jboss.classfilewriter.annotations.CharAnnotationValue;
import org.jboss.classfilewriter.annotations.ClassAnnotation;
import org.jboss.classfilewriter.annotations.ClassAnnotationValue;
import org.jboss.classfilewriter.annotations.DoubleAnnotationValue;
import org.jboss.classfilewriter.annotations.EnumAnnotationValue;
import org.jboss.classfilewriter.annotations.FloatAnnotationValue;
import org.jboss.classfilewriter.annotations.IntAnnotationValue;
import org.jboss.classfilewriter.annotations.LongAnnotationValue;
import org.jboss.classfilewriter.annotations.ShortAnnotationValue;
import org.jboss.classfilewriter.annotations.StringAnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class AnnotationBuilder {
    public static ClassAnnotation createAnnotation(ConstPool constPool, final Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>();
        try {
            for (final Method m : annotationType.getDeclaredMethods()) {
                Object value = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InvocationTargetException, IllegalAccessException {
                        m.setAccessible(true);
                        return m.invoke((Object)annotation, new Object[0]);
                    }
                });
                values.add(AnnotationBuilder.createValue(constPool, m.getName(), value));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        return new ClassAnnotation(constPool, annotationType.getName(), values);
    }

    public static AnnotationValue createValue(ConstPool constPool, String name, Object value) {
        Class<?> type2 = value.getClass();
        if (type2 == String.class) {
            return new StringAnnotationValue(constPool, name, (String)value);
        }
        if (type2 == Integer.TYPE || type2 == Integer.class) {
            return new IntAnnotationValue(constPool, name, (Integer)value);
        }
        if (type2 == Short.TYPE || type2 == Short.class) {
            return new ShortAnnotationValue(constPool, name, (Short)value);
        }
        if (type2 == Byte.TYPE || type2 == Byte.class) {
            return new ByteAnnotationValue(constPool, name, (Byte)value);
        }
        if (type2 == Boolean.TYPE || type2 == Boolean.class) {
            return new BooleanAnnotationValue(constPool, name, (Boolean)value);
        }
        if (type2 == Character.TYPE || type2 == Character.class) {
            return new CharAnnotationValue(constPool, name, ((Character)value).charValue());
        }
        if (type2 == Long.TYPE || type2 == Long.class) {
            return new LongAnnotationValue(constPool, name, (Long)value);
        }
        if (type2 == Float.TYPE || type2 == Float.class) {
            return new FloatAnnotationValue(constPool, name, ((Float)value).floatValue());
        }
        if (type2 == Double.TYPE || type2 == Double.class) {
            return new DoubleAnnotationValue(constPool, name, (Double)value);
        }
        if (type2 == Class.class) {
            return new ClassAnnotationValue(constPool, name, (Class)value);
        }
        if (type2.isEnum() || type2.getEnclosingClass() != null && type2.getEnclosingClass().isEnum()) {
            return new EnumAnnotationValue(constPool, name, (Enum)value);
        }
        if (value instanceof Annotation) {
            return new AnnotationAnnotationValue(constPool, name, AnnotationBuilder.createAnnotation(constPool, (Annotation)value));
        }
        if (type2.isArray()) {
            int length = Array.getLength(value);
            ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>();
            for (int i = 0; i < length; ++i) {
                values.add(AnnotationBuilder.createValue(constPool, null, Array.get(value, i)));
            }
            return new ArrayAnnotationValue(constPool, name, values);
        }
        throw new RuntimeException("Invalid type for annotation value. Type: " + type2 + " Value: " + value);
    }

    private AnnotationBuilder() {
    }
}

