/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.constraints.Mod11Check;
import org.hibernate.validator.internal.constraintvalidators.ModCheckBase;
import org.hibernate.validator.internal.util.ModUtil;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class Mod11CheckValidator
extends ModCheckBase
implements ConstraintValidator<Mod11Check, CharSequence> {
    private static final Log log = LoggerFactory.make();
    private boolean reverseOrder;
    private char treatCheck10As;
    private char treatCheck11As;
    private int threshold;

    @Override
    public void initialize(Mod11Check constraintAnnotation) {
        super.initialize(constraintAnnotation.startIndex(), constraintAnnotation.endIndex(), constraintAnnotation.checkDigitIndex(), constraintAnnotation.ignoreNonDigitCharacters());
        this.threshold = constraintAnnotation.threshold();
        this.reverseOrder = constraintAnnotation.processingDirection() == Mod11Check.ProcessingDirection.LEFT_TO_RIGHT;
        this.treatCheck10As = constraintAnnotation.treatCheck10As();
        this.treatCheck11As = constraintAnnotation.treatCheck11As();
        if (!Character.isLetterOrDigit(this.treatCheck10As)) {
            throw log.getTreatCheckAsIsNotADigitNorALetterException(this.treatCheck10As);
        }
        if (!Character.isLetterOrDigit(this.treatCheck11As)) {
            throw log.getTreatCheckAsIsNotADigitNorALetterException(this.treatCheck11As);
        }
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        if (this.reverseOrder) {
            Collections.reverse(digits);
        }
        int modResult = ModUtil.calculateMod11Check(digits, this.threshold);
        switch (modResult) {
            case 10: {
                return checkDigit == this.treatCheck10As;
            }
            case 11: {
                return checkDigit == this.treatCheck11As;
            }
        }
        return Character.isDigit(checkDigit) && modResult == this.extractDigit(checkDigit);
    }
}

