/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.descriptor;

import com.sun.enterprise.deployment.web.UserDataConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.deployment.common.Descriptor;

public class UserDataConstraintImpl
extends Descriptor
implements UserDataConstraint {
    public static final String TRANSPORT_GUARANTEE_NONE = "NONE";
    public static final String TRANSPORT_GUARANTEE_INTEGRAL = "INTEGRAL";
    public static final String TRANSPORT_GUARANTEE_CONFIDENTIAL = "CONFIDENTIAL";
    public static final String TRANSPORT_GUARANTEE_CLEAR = "CLEAR";
    private String transportGuarantee;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UserDataConstraintImpl.class);

    @Override
    public String getTransportGuarantee() {
        if (this.transportGuarantee == null) {
            this.transportGuarantee = TRANSPORT_GUARANTEE_NONE;
        }
        return this.transportGuarantee;
    }

    @Override
    public String[] getUnacceptableTransportGuarantees() {
        String acceptable = this.getTransportGuarantee();
        if (acceptable.equals(TRANSPORT_GUARANTEE_NONE)) {
            return null;
        }
        if (acceptable.equals(TRANSPORT_GUARANTEE_INTEGRAL)) {
            String[] ret = new String[]{TRANSPORT_GUARANTEE_CLEAR, TRANSPORT_GUARANTEE_CONFIDENTIAL};
            return ret;
        }
        if (acceptable.equals(TRANSPORT_GUARANTEE_CONFIDENTIAL)) {
            String[] ret = new String[]{TRANSPORT_GUARANTEE_CLEAR, TRANSPORT_GUARANTEE_INTEGRAL};
            return ret;
        }
        return null;
    }

    @Override
    public void setTransportGuarantee(String transportGuarantee) {
        if (this.isBoundsChecking() && !TRANSPORT_GUARANTEE_NONE.equals(transportGuarantee) && !TRANSPORT_GUARANTEE_INTEGRAL.equals(transportGuarantee) && !TRANSPORT_GUARANTEE_CONFIDENTIAL.equals(transportGuarantee)) {
            throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.exceptiontransportguarentee", "{0} is not a valid transport guarantee", transportGuarantee));
        }
        this.transportGuarantee = transportGuarantee;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("UserDataConstraint ");
        toStringBuffer.append(" description ").append(super.getDescription());
        toStringBuffer.append(" transportGuarantee ").append(this.getTransportGuarantee());
    }
}

