/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.websocket.DeploymentException;
import org.glassfish.tyrus.spi.ServerContainer;
import org.glassfish.tyrus.spi.ServerContainerFactory;

public class Server {
    public static final String STATIC_CONTENT_ROOT = "org.glassfish.tyrus.server.staticContentRoot";
    private static final Logger LOGGER = Logger.getLogger(Server.class.getClass().getName());
    private static final int DEFAULT_PORT = 8025;
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_CONTEXT_PATH = "/";
    private final Map<String, Object> properties;
    private final Set<Class<?>> configuration;
    private final String hostName;
    private final int port;
    private final String contextPath;
    private ServerContainer server;

    public Server(Class<?> ... configuration) {
        this(null, 0, null, null, configuration);
    }

    public Server(Map<String, Object> properties, Class<?> ... configuration) {
        this(null, 0, null, properties, configuration);
    }

    public Server(String hostName, int port, String contextPath, Map<String, Object> properties, Class<?> ... configuration) {
        this(hostName, port, contextPath, properties, new HashSet(Arrays.asList(configuration)));
    }

    public Server(String hostName, int port, String contextPath, Map<String, Object> properties, Set<Class<?>> configuration) {
        this.hostName = hostName == null ? DEFAULT_HOST_NAME : hostName;
        this.port = port == 0 ? 8025 : port;
        this.contextPath = contextPath == null ? DEFAULT_CONTEXT_PATH : contextPath;
        this.configuration = configuration;
        this.properties = properties == null ? null : new HashMap<String, Object>(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Please provide: (<hostname>, <port>, <websockets root path>, <;-sep fully qualfied classnames of your bean>) in the command line");
            System.out.println("e.g. localhost 8021 /websockets/myapp myapp.Bean1;myapp.Bean2");
            System.exit(1);
        }
        Set<Class<?>> beanClasses = Server.getClassesFromString(args[3]);
        int port = Integer.parseInt(args[1]);
        String hostname = args[0];
        String wsroot = args[2];
        Server server = new Server(hostname, port, wsroot, null, beanClasses);
        try {
            server.start();
            System.out.println("Press any key to stop the WebSocket server...");
            System.in.read();
        }
        catch (IOException ioe) {
            System.err.println("IOException during server run");
            ioe.printStackTrace();
        }
        catch (DeploymentException de) {
            de.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    private static Set<Class<?>> getClassesFromString(String rawString) {
        HashSet beanClasses = new HashSet();
        StringTokenizer st = new StringTokenizer(rawString, ";");
        while (st.hasMoreTokens()) {
            String nextClassname = st.nextToken().trim();
            if ("".equals(nextClassname)) continue;
            try {
                beanClasses.add(Class.forName(nextClassname));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Stop: cannot load class: " + nextClassname);
            }
        }
        return beanClasses;
    }

    public void start() throws DeploymentException {
        try {
            if (this.server == null) {
                this.server = ServerContainerFactory.createServerContainer(this.properties);
                for (Class<?> clazz : this.configuration) {
                    this.server.addEndpoint(clazz);
                }
                this.server.start(this.contextPath, this.port);
                LOGGER.info("WebSocket Registered apps: URLs all start with ws://" + this.hostName + ":" + this.port);
                LOGGER.info("WebSocket server started.");
            }
        }
        catch (IOException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
            LOGGER.info("Websocket Server stopped.");
        }
    }
}

