/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.services.commands.CLIUtil;
import org.glassfish.security.services.config.LoginModuleConfig;
import org.glassfish.security.services.config.SecurityProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="_create-login-module-config")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
public class CreateLoginModuleConfig
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(optional=false)
    private String serviceName;
    @Param(optional=false)
    private String providerName;
    @Param(optional=false)
    private String moduleClass;
    @Param(optional=false)
    private String controlFlag;
    @Param(optional=true, separator=58)
    private Properties configuration;
    @Param(primary=true)
    private String name;
    @Inject
    private Domain domain;
    @AccessRequired.NewChild(type=LoginModuleConfig.class)
    private SecurityProvider provider;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        SecurityProvider provider = CLIUtil.findSecurityProvider(this.domain, this.serviceName, this.providerName, context.getActionReport());
        return provider != null;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        LoginModuleConfig config = null;
        try {
            config = (LoginModuleConfig)ConfigSupport.apply(new SingleConfigCode<SecurityProvider>(){

                @Override
                public Object run(SecurityProvider param) throws PropertyVetoException, TransactionFailure {
                    LoginModuleConfig lmConfig = param.createChild(LoginModuleConfig.class);
                    lmConfig.setName(CreateLoginModuleConfig.this.name);
                    lmConfig.setModuleClass(CreateLoginModuleConfig.this.moduleClass);
                    lmConfig.setControlFlag(CreateLoginModuleConfig.this.controlFlag);
                    param.getSecurityProviderConfig().add(lmConfig);
                    return lmConfig;
                }
            }, this.provider);
        }
        catch (TransactionFailure transactionFailure) {
            report.setMessage("Unable to create login module config: " + transactionFailure.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(transactionFailure);
            return;
        }
        if (config != null && this.configuration != null && !this.configuration.isEmpty()) {
            try {
                ConfigSupport.apply(new SingleConfigCode<LoginModuleConfig>(){

                    @Override
                    public Object run(LoginModuleConfig param) throws PropertyVetoException, TransactionFailure {
                        for (Object configPropName : CreateLoginModuleConfig.this.configuration.keySet()) {
                            Property prop = param.createChild(Property.class);
                            String propName = (String)configPropName;
                            prop.setName(propName);
                            prop.setValue(CreateLoginModuleConfig.this.configuration.getProperty(propName));
                            param.getProperty().add(prop);
                        }
                        return param;
                    }
                }, config);
            }
            catch (TransactionFailure transactionFailure) {
                report.setMessage("Unable to create login module options: " + transactionFailure.getMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause(transactionFailure);
            }
        }
    }
}

