/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.spi;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.glassfish.pfl.dynamic.codegen.spi.ClassInfo;
import org.glassfish.pfl.dynamic.codegen.spi.InterceptorContext;
import org.glassfish.pfl.dynamic.codegen.spi.MethodInfo;
import org.glassfish.pfl.dynamic.codegen.spi.Signature;
import org.glassfish.pfl.dynamic.codegen.spi.Type;

public class GenericClass<T> {
    private Type implType;
    private ClassInfo implClassInfo;
    private Class<T> typeClass;
    private Constructor constructor;

    public GenericClass(Class<T> type2, InterceptorContext ic, byte[] classData) {
        throw new IllegalArgumentException("Not supported yet");
    }

    public GenericClass(Class<T> type2, Class<?> cls) {
        if (!type2.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " is not a subclass of " + type2.getName());
        }
        this.implType = Type.type(cls);
        this.implClassInfo = this.implType.classInfo();
        this.typeClass = type2;
    }

    private synchronized Constructor getConstructor(Object ... args) {
        if (this.constructor == null) {
            ArrayList<Type> atypes = new ArrayList<Type>();
            for (Object arg : args) {
                Type type2 = Type._null();
                if (arg != null) {
                    Class<?> cls = arg.getClass();
                    type2 = Type.type(cls);
                }
                atypes.add(type2);
            }
            Signature sig = Signature.fromConstructorUsingTypes(this.implType, atypes);
            MethodInfo minfo = this.implClassInfo.findConstructorInfo(sig);
            this.constructor = minfo.getConstructor();
        }
        return this.constructor;
    }

    private synchronized Constructor clearAndGetConstructor(Object ... args) {
        this.constructor = null;
        return this.getConstructor(args);
    }

    public T create(Object ... args) {
        try {
            try {
                return this.typeClass.cast(this.getConstructor(new Object[0]).newInstance(args));
            }
            catch (IllegalArgumentException argexc) {
                return this.typeClass.cast(this.clearAndGetConstructor(args).newInstance(args));
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not construct instance of class " + this.implType.name(), exc);
        }
    }
}

