/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.moxy.json;

import java.util.Map;
import javax.ws.rs.ext.ContextResolver;
import jersey.repackaged.com.google.common.collect.Maps;

public final class MoxyJsonConfig {
    private final Map<String, Object> marshallerProperties = Maps.newHashMap();
    private final Map<String, Object> unmarshallerProperties = Maps.newHashMap();

    public MoxyJsonConfig() {
        this(true);
    }

    public MoxyJsonConfig(boolean initDefaultProperties) {
        if (initDefaultProperties) {
            this.setFormattedOutput(false);
            this.setIncludeRoot(false);
            this.setMarshalEmptyCollections(true);
            this.setNamespaceSeparator('.');
        }
    }

    private MoxyJsonConfig(MoxyJsonConfig that) {
        this.marshallerProperties.putAll(that.marshallerProperties);
        this.unmarshallerProperties.putAll(that.unmarshallerProperties);
    }

    public MoxyJsonConfig property(String name, Object value) {
        this.marshallerProperty(name, value);
        this.unmarshallerProperty(name, value);
        return this;
    }

    public MoxyJsonConfig marshallerProperty(String name, Object value) {
        this.marshallerProperties.put(name, value);
        return this;
    }

    public MoxyJsonConfig unmarshallerProperty(String name, Object value) {
        this.unmarshallerProperties.put(name, value);
        return this;
    }

    public MoxyJsonConfig setMarshallerProperties(Map<String, Object> marshallerProperties) {
        this.marshallerProperties.putAll(marshallerProperties);
        return this;
    }

    public MoxyJsonConfig setUnmarshallerProperties(Map<String, Object> unmarshallerProperties) {
        this.unmarshallerProperties.putAll(unmarshallerProperties);
        return this;
    }

    public Map<String, Object> getMarshallerProperties() {
        return this.marshallerProperties;
    }

    public Map<String, Object> getUnmarshallerProperties() {
        return this.unmarshallerProperties;
    }

    public String getAttributePrefix() {
        return (String)this.marshallerProperties.get("eclipselink.json.attribute-prefix");
    }

    public MoxyJsonConfig setAttributePrefix(String attributePrefix) {
        if (attributePrefix != null) {
            this.marshallerProperties.put("eclipselink.json.attribute-prefix", attributePrefix);
            this.unmarshallerProperties.put("eclipselink.json.attribute-prefix", attributePrefix);
        } else {
            this.marshallerProperties.remove("eclipselink.json.attribute-prefix");
            this.unmarshallerProperties.remove("eclipselink.json.attribute-prefix");
        }
        return this;
    }

    public boolean isFormattedOutput() {
        return (Boolean)this.marshallerProperties.get("jaxb.formatted.output");
    }

    public MoxyJsonConfig setFormattedOutput(boolean formattedOutput) {
        this.marshallerProperties.put("jaxb.formatted.output", formattedOutput);
        return this;
    }

    public boolean isIncludeRoot() {
        return (Boolean)this.marshallerProperties.get("eclipselink.json.include-root");
    }

    public MoxyJsonConfig setIncludeRoot(boolean includeRoot) {
        this.marshallerProperties.put("eclipselink.json.include-root", includeRoot);
        this.unmarshallerProperties.put("eclipselink.json.include-root", includeRoot);
        return this;
    }

    public boolean isMarshalEmptyCollections() {
        return (Boolean)this.marshallerProperties.get("eclipselink.json.marshal-empty-collections");
    }

    public MoxyJsonConfig setMarshalEmptyCollections(boolean marshalEmptyCollections) {
        this.marshallerProperties.put("eclipselink.json.marshal-empty-collections", marshalEmptyCollections);
        return this;
    }

    public Map<String, String> getNamespacePrefixMapper() {
        return (Map)this.marshallerProperties.get("eclipselink.namespace-prefix-mapper");
    }

    public MoxyJsonConfig setNamespacePrefixMapper(Map<String, String> namespacePrefixMapper) {
        if (namespacePrefixMapper != null) {
            this.marshallerProperties.put("eclipselink.namespace-prefix-mapper", namespacePrefixMapper);
            this.unmarshallerProperties.put("eclipselink.namespace-prefix-mapper", namespacePrefixMapper);
        } else {
            this.marshallerProperties.remove("eclipselink.namespace-prefix-mapper");
            this.unmarshallerProperties.remove("eclipselink.namespace-prefix-mapper");
        }
        return this;
    }

    public char getNamespaceSeparator() {
        return ((Character)this.marshallerProperties.get("eclipselink.json.namespace-separator")).charValue();
    }

    public MoxyJsonConfig setNamespaceSeparator(char namespaceSeparator) {
        this.marshallerProperties.put("eclipselink.json.namespace-separator", Character.valueOf(namespaceSeparator));
        this.unmarshallerProperties.put("eclipselink.json.namespace-separator", Character.valueOf(namespaceSeparator));
        return this;
    }

    public String getValueWrapper() {
        return (String)this.marshallerProperties.get("eclipselink.json.value-wrapper");
    }

    public MoxyJsonConfig setValueWrapper(String valueWrapper) {
        if (valueWrapper != null) {
            this.marshallerProperties.put("eclipselink.json.value-wrapper", valueWrapper);
            this.unmarshallerProperties.put("eclipselink.json.value-wrapper", valueWrapper);
        } else {
            this.marshallerProperties.remove("eclipselink.json.value-wrapper");
            this.unmarshallerProperties.remove("eclipselink.json.value-wrapper");
        }
        return this;
    }

    public ContextResolver<MoxyJsonConfig> resolver() {
        return new ContextResolver<MoxyJsonConfig>(){
            private final MoxyJsonConfig config;
            {
                this.config = new MoxyJsonConfig(MoxyJsonConfig.this);
            }

            @Override
            public MoxyJsonConfig getContext(Class<?> type2) {
                return this.config;
            }
        };
    }
}

