/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartProperties;
import org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEParsingException;
import org.jvnet.mimepull.MIMEPart;

@Consumes(value={"multipart/*"})
@Singleton
@ConstrainedTo(value=RuntimeType.CLIENT)
public class MultiPartReaderClientSide
implements MessageBodyReader<MultiPart> {
    private static final Logger LOGGER = Logger.getLogger(MultiPartReaderClientSide.class.getName());
    @Inject
    private Provider<MessageBodyWorkers> messageBodyWorkers;
    private final MIMEConfig mimeConfig;

    public MultiPartReaderClientSide(@Context Providers providers) {
        ContextResolver<MultiPartProperties> contextResolver = providers.getContextResolver(MultiPartProperties.class, MediaType.WILDCARD_TYPE);
        MultiPartProperties properties = null;
        if (contextResolver != null) {
            properties = contextResolver.getContext(this.getClass());
        }
        if (properties == null) {
            properties = new MultiPartProperties();
        }
        this.mimeConfig = this.createMimeConfig(properties);
    }

    private MIMEConfig createMimeConfig(MultiPartProperties properties) {
        MIMEConfig mimeConfig = new MIMEConfig();
        mimeConfig.setMemoryThreshold(properties.getBufferThreshold());
        String tempDir = properties.getTempDir();
        if (tempDir != null) {
            mimeConfig.setDir(tempDir);
        }
        if (properties.getBufferThreshold() != -1) {
            try {
                File.createTempFile("MIME", null, tempDir != null ? new File(tempDir) : null).delete();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, LocalizationMessages.TEMP_FILE_CANNOT_BE_CREATED(properties.getBufferThreshold()), ioe);
            }
        }
        return mimeConfig;
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type2);
    }

    @Override
    public MultiPart readFrom(Class<MultiPart> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            return this.readMultiPart(type2, genericType, annotations, mediaType, headers, stream);
        }
        catch (MIMEParsingException mpe) {
            if (mpe.getCause() instanceof IOException) {
                throw (IOException)mpe.getCause();
            }
            throw new BadRequestException(mpe);
        }
    }

    protected MultiPart readMultiPart(Class<MultiPart> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, MIMEParsingException {
        boolean fileNameFix;
        mediaType = MultiPartReaderClientSide.unquoteMediaTypeParameters(mediaType, "boundary");
        MIMEMessage mimeMessage = new MIMEMessage(stream, mediaType.getParameters().get("boundary"), this.mimeConfig);
        boolean formData = MediaTypes.typeEqual(mediaType, MediaType.MULTIPART_FORM_DATA_TYPE);
        MultiPart multiPart = formData ? new FormDataMultiPart() : new MultiPart();
        MessageBodyWorkers workers = this.messageBodyWorkers.get();
        multiPart.setMessageBodyWorkers(workers);
        MultivaluedMap<String, String> multiPartHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (Object value : values) {
                multiPartHeaders.add((String)entry.getKey(), (String)value);
            }
        }
        if (!formData) {
            multiPart.setMediaType(mediaType);
            fileNameFix = false;
        } else {
            String userAgent = headers.getFirst("User-Agent");
            fileNameFix = userAgent != null && userAgent.contains(" MSIE ");
        }
        for (MIMEPart mimePart : mimeMessage.getAttachments()) {
            BodyPart bodyPart = formData ? new FormDataBodyPart(fileNameFix) : new BodyPart();
            bodyPart.setMessageBodyWorkers(workers);
            for (Header header : mimePart.getAllHeaders()) {
                bodyPart.getHeaders().add(header.getName(), header.getValue());
            }
            try {
                String contentType = bodyPart.getHeaders().getFirst("Content-Type");
                if (contentType != null) {
                    bodyPart.setMediaType(MediaType.valueOf(contentType));
                }
                bodyPart.getContentDisposition();
            }
            catch (IllegalArgumentException ex) {
                throw new BadRequestException(ex);
            }
            bodyPart.setEntity(new BodyPartEntity(mimePart));
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }

    protected static MediaType unquoteMediaTypeParameters(MediaType mediaType, String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return mediaType;
        }
        HashMap<String, String> unquotedParams = new HashMap<String, String>(mediaType.getParameters());
        for (String parameter : parameters) {
            String value = mediaType.getParameters().get(parameter);
            if (value == null || !value.startsWith("\"")) continue;
            value = value.substring(1, value.length() - 1);
            unquotedParams.put(parameter, value);
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), unquotedParams);
    }
}

