/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.IOException;
import java.net.URI;
import javax.ws.rs.ProcessingException;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.internal.LocalizationMessages;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;

public final class GrizzlyHttpServerFactory {
    private static final int DEFAULT_HTTP_PORT = 80;

    public static HttpServer createHttpServer(URI uri) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(configuration), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(configuration), false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(configuration), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(configuration), secure, sslEngineConfigurator, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, boolean secure, SSLEngineConfigurator sslEngineConfigurator, ServiceLocator parentLocator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(config, parentLocator), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig config, ServiceLocator parentLocator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(config, parentLocator), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, GrizzlyHttpContainer handler, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        String host = uri.getHost() == null ? "0.0.0.0" : uri.getHost();
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").setUncaughtExceptionHandler(new JerseyProcessingUncaughtExceptionHandler()).build());
        listener.setSecure(secure);
        if (sslEngineConfigurator != null) {
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        HttpServer server = new HttpServer();
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            String path = uri.getPath().replaceAll("/{2,}", "/");
            String contextPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            config.addHttpHandler((HttpHandler)handler, HttpHandlerRegistration.bulder().contextPath(contextPath).build());
        }
        config.setPassTraceRequest(true);
        if (start) {
            try {
                server.start();
            }
            catch (IOException ex) {
                server.shutdownNow();
                throw new ProcessingException(LocalizationMessages.FAILED_TO_START_SERVER(ex.getMessage()), ex);
            }
        }
        return server;
    }

    private GrizzlyHttpServerFactory() {
    }
}

