/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.jdbc.DataSource;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueue;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=JdbcConnectionPool.class)
@Singleton
public class JdbcConnectionPoolDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    @Optional
    private Domain domain;
    private static StringManager sm = StringManager.getManager(JdbcConnectionPoolDeployer.class);
    private static String msg = sm.getString("resource.restart_needed");
    private static Logger _logger = LogDomains.getLogger(JdbcConnectionPoolDeployer.class, "javax.enterprise.resource.resourceadapter");
    private static final Locale locale = Locale.getDefault();
    private ExecutorService execService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    });

    @Override
    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcConnectionPool jcp = (JdbcConnectionPool)resource;
        PoolInfo poolInfo = new PoolInfo(jcp.getName(), applicationName, moduleName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" JdbcConnectionPoolDeployer - deployResource : " + poolInfo + " calling actualDeploy");
        }
        this.actualDeployResource(resource, poolInfo);
    }

    @Override
    public void deployResource(Object resource) throws Exception {
        JdbcConnectionPool jcp = (JdbcConnectionPool)resource;
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(jcp);
        this.actualDeployResource(resource, poolInfo);
    }

    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void actualDeployResource(Object resource, PoolInfo poolInfo) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" JdbcConnectionPoolDeployer - actualDeployResource : " + poolInfo);
        }
        JdbcConnectionPool adminPool = (JdbcConnectionPool)resource;
        try {
            ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(adminPool, poolInfo);
            this.registerTransparentDynamicReconfigPool(poolInfo, adminPool);
            this.runtime.createConnectorConnectionPool(connConnPool);
        }
        catch (Exception e) {
            Object[] params = new Object[]{poolInfo, e};
            _logger.log(Level.WARNING, "error.creating.jdbc.pool", params);
        }
    }

    private void registerTransparentDynamicReconfigPool(PoolInfo poolInfo, JdbcConnectionPool resourcePool) {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        if (ConnectorsUtil.isDynamicReconfigurationEnabled(resourcePool)) {
            registry.addTransparentDynamicReconfigPool(poolInfo);
        } else {
            registry.removeTransparentDynamicReconfigPool(poolInfo);
        }
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        JdbcConnectionPool jdbcConnPool = (JdbcConnectionPool)resource;
        PoolInfo poolInfo = new PoolInfo(jdbcConnPool.getName(), applicationName, moduleName);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : calling actualUndeploy of " + poolInfo);
        }
        this.actualUndeployResource(poolInfo);
    }

    @Override
    public synchronized void undeployResource(Object resource) throws Exception {
        JdbcConnectionPool jdbcConnPool = (JdbcConnectionPool)resource;
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(jdbcConnPool);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" JdbcConnectionPoolDeployer - unDeployResource : calling actualUndeploy of " + poolInfo);
        }
        this.actualUndeployResource(poolInfo);
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof JdbcConnectionPool;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return true;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[]{DataSource.class};
    }

    private synchronized void actualUndeployResource(PoolInfo poolInfo) throws Exception {
        this.runtime.deleteConnectorConnectionPool(poolInfo);
        ConnectorRegistry.getInstance().removeTransparentDynamicReconfigPool(poolInfo);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Pool Undeployed");
        }
    }

    private ConnectorConfigProperty[] getMCFConfigProperties(JdbcConnectionPool adminPool, ConnectorConnectionPool conConnPool, ConnectorDescriptor connDesc) {
        ArrayList<ConnectorConfigProperty> propList = new ArrayList<ConnectorConfigProperty>();
        if (adminPool.getResType() != null) {
            if ("java.sql.Driver".equals(adminPool.getResType())) {
                propList.add(new ConnectorConfigProperty("ClassName", adminPool.getDriverClassname() == null ? "" : adminPool.getDriverClassname(), "The driver class name", "java.lang.String"));
            } else {
                propList.add(new ConnectorConfigProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", "java.lang.String"));
            }
        } else if (adminPool.getDriverClassname() != null) {
            propList.add(new ConnectorConfigProperty("ClassName", adminPool.getDriverClassname() == null ? "" : adminPool.getDriverClassname(), "The driver class name", "java.lang.String"));
        } else if (adminPool.getDatasourceClassname() != null) {
            propList.add(new ConnectorConfigProperty("ClassName", adminPool.getDatasourceClassname() == null ? "" : adminPool.getDatasourceClassname(), "The datasource class name", "java.lang.String"));
        }
        propList.add(new ConnectorConfigProperty("ConnectionValidationRequired", adminPool.getIsConnectionValidationRequired() + "", "Is connection validation required", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("ValidationMethod", adminPool.getConnectionValidationMethod() == null ? "" : adminPool.getConnectionValidationMethod(), "How the connection is validated", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("ValidationTableName", adminPool.getValidationTableName() == null ? "" : adminPool.getValidationTableName(), "Validation Table name", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("ValidationClassName", adminPool.getValidationClassname() == null ? "" : adminPool.getValidationClassname(), "Validation Class name", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("TransactionIsolation", adminPool.getTransactionIsolationLevel() == null ? "" : adminPool.getTransactionIsolationLevel(), "Transaction Isolatin Level", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("GuaranteeIsolationLevel", adminPool.getIsIsolationLevelGuaranteed() + "", "Transaction Isolation Guarantee", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("StatementWrapping", adminPool.getWrapJdbcObjects() + "", "Statement Wrapping", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("StatementTimeout", adminPool.getStatementTimeoutInSeconds() + "", "Statement Timeout", "java.lang.String"));
        PoolInfo poolInfo = conConnPool.getPoolInfo();
        propList.add(new ConnectorConfigProperty("PoolMonitoringSubTreeRoot", ConnectorsUtil.getPoolMonitoringSubTreeRoot(poolInfo, true) + "", "Pool Monitoring Sub Tree Root", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("PoolName", poolInfo.getName() + "", "Pool Name", "java.lang.String"));
        if (poolInfo.getApplicationName() != null) {
            propList.add(new ConnectorConfigProperty("ApplicationName", poolInfo.getApplicationName() + "", "Application Name", "java.lang.String"));
        }
        if (poolInfo.getModuleName() != null) {
            propList.add(new ConnectorConfigProperty("ModuleName", poolInfo.getModuleName() + "", "Module name", "java.lang.String"));
        }
        propList.add(new ConnectorConfigProperty("StatementCacheSize", adminPool.getStatementCacheSize() + "", "Statement Cache Size", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("StatementCacheType", adminPool.getStatementCacheType() + "", "Statement Cache Type", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("InitSql", adminPool.getInitSql() + "", "InitSql", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("SqlTraceListeners", adminPool.getSqlTraceListeners() + "", "Sql Trace Listeners", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("StatementLeakTimeoutInSeconds", adminPool.getStatementLeakTimeoutInSeconds() + "", "Statement Leak Timeout in seconds", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("StatementLeakReclaim", adminPool.getStatementLeakReclaim() + "", "Statement Leak Reclaim", "java.lang.String"));
        Set connDefDescSet = connDesc.getOutboundResourceAdapter().getConnectionDefs();
        if (connDefDescSet.size() != 1) {
            throw new MissingResourceException("Only one connDefDesc present", null, null);
        }
        Iterator iter = connDefDescSet.iterator();
        Set mcfConfigProps = null;
        while (iter.hasNext()) {
            mcfConfigProps = ((ConnectionDefDescriptor)iter.next()).getConfigProperties();
        }
        if (mcfConfigProps != null) {
            HashMap<String, String> mcfConPropKeys = new HashMap<String, String>();
            Iterator mcfConfigPropsIter = mcfConfigProps.iterator();
            while (mcfConfigPropsIter.hasNext()) {
                String key = ((ConnectorConfigProperty)mcfConfigPropsIter.next()).getName();
                mcfConPropKeys.put(key.toUpperCase(locale), key);
            }
            String driverProperties = "";
            for (Property rp : adminPool.getProperty()) {
                String value;
                if (rp == null) continue;
                String name = rp.getName();
                if ("MATCHCONNECTIONS".equals(name.toUpperCase(locale))) {
                    conConnPool.setMatchConnections(this.toBoolean(rp.getValue(), false));
                    this.logFine("MATCHCONNECTIONS");
                    continue;
                }
                if ("ASSOCIATEWITHTHREAD".equals(name.toUpperCase(locale))) {
                    conConnPool.setAssociateWithThread(this.toBoolean(rp.getValue(), false));
                    this.logFine("ASSOCIATEWITHTHREAD");
                    continue;
                }
                if ("LAZYCONNECTIONASSOCIATION".equals(name.toUpperCase(locale))) {
                    ConnectionPoolObjectsUtils.setLazyEnlistAndLazyAssocProperties(rp.getValue(), adminPool.getProperty(), conConnPool);
                    this.logFine("LAZYCONNECTIONASSOCIATION");
                    continue;
                }
                if ("LAZYCONNECTIONENLISTMENT".equals(name.toUpperCase(Locale.getDefault()))) {
                    conConnPool.setLazyConnectionEnlist(this.toBoolean(rp.getValue(), false));
                    this.logFine("LAZYCONNECTIONENLISTMENT");
                    continue;
                }
                if ("POOLDATASTRUCTURE".equals(name.toUpperCase(Locale.getDefault()))) {
                    conConnPool.setPoolDataStructureType(rp.getValue());
                    this.logFine("POOLDATASTRUCTURE");
                    continue;
                }
                if ("dynamic-reconfiguration-wait-timeout-in-seconds".equals(name.toLowerCase(locale))) {
                    value = rp.getValue();
                    try {
                        conConnPool.setDynamicReconfigWaitTimeout(Long.parseLong(rp.getValue()) * 1000L);
                        this.logFine("dynamic-reconfiguration-wait-timeout-in-seconds");
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.WARNING, "Invalid value for 'dynamic-reconfiguration-wait-timeout-in-seconds' : " + value);
                    }
                    continue;
                }
                if ("POOLWAITQUEUE".equals(name.toUpperCase(locale))) {
                    conConnPool.setPoolWaitQueue(rp.getValue());
                    this.logFine("POOLWAITQUEUE");
                    continue;
                }
                if ("DATASTRUCTUREPARAMETERS".equals(name.toUpperCase(locale))) {
                    conConnPool.setDataStructureParameters(rp.getValue());
                    this.logFine("DATASTRUCTUREPARAMETERS");
                    continue;
                }
                if ("USERNAME".equals(name.toUpperCase(Locale.getDefault())) || "USER".equals(name.toUpperCase(locale))) {
                    propList.add(new ConnectorConfigProperty("User", rp.getValue(), "user name", "java.lang.String"));
                    continue;
                }
                if ("PASSWORD".equals(name.toUpperCase(locale))) {
                    propList.add(new ConnectorConfigProperty("Password", rp.getValue(), "Password", "java.lang.String"));
                    continue;
                }
                if ("JDBC30DATASOURCE".equals(name.toUpperCase(locale))) {
                    propList.add(new ConnectorConfigProperty("JDBC30DataSource", rp.getValue(), "JDBC30DataSource", "java.lang.String"));
                    continue;
                }
                if ("PREFER-VALIDATE-OVER-RECREATE".equals(name.toUpperCase(Locale.getDefault()))) {
                    value = rp.getValue();
                    conConnPool.setPreferValidateOverRecreate(this.toBoolean(value, false));
                    this.logFine("PREFER-VALIDATE-OVER-RECREATE : " + value);
                    continue;
                }
                if ("STATEMENT-CACHE-TYPE".equals(name.toUpperCase(Locale.getDefault()))) {
                    if (adminPool.getStatementCacheType() == null) continue;
                    propList.add(new ConnectorConfigProperty("StatementCacheType", rp.getValue(), "StatementCacheType", "java.lang.String"));
                    continue;
                }
                if ("NUMBER-OF-TOP-QUERIES-TO-REPORT".equals(name.toUpperCase(Locale.getDefault()))) {
                    propList.add(new ConnectorConfigProperty("NumberOfTopQueriesToReport", rp.getValue(), "NumberOfTopQueriesToReport", "java.lang.String"));
                    continue;
                }
                if ("TIME-TO-KEEP-QUERIES-IN-MINUTES".equals(name.toUpperCase(Locale.getDefault()))) {
                    propList.add(new ConnectorConfigProperty("TimeToKeepQueriesInMinutes", rp.getValue(), "TimeToKeepQueriesInMinutes", "java.lang.String"));
                    continue;
                }
                if (mcfConPropKeys.containsKey(name.toUpperCase(Locale.getDefault()))) {
                    propList.add(new ConnectorConfigProperty((String)mcfConPropKeys.get(name.toUpperCase(Locale.getDefault())), rp.getValue() == null ? "" : rp.getValue(), "Some property", "java.lang.String"));
                    continue;
                }
                driverProperties = driverProperties + "set" + this.escape(name) + "#" + this.escape(rp.getValue()) + "##";
            }
            if (!driverProperties.equals("")) {
                propList.add(new ConnectorConfigProperty("DriverProperties", driverProperties, "some proprietarty properties", "java.lang.String"));
            }
        }
        propList.add(new ConnectorConfigProperty("Delimiter", "#", "delim", "java.lang.String"));
        propList.add(new ConnectorConfigProperty("EscapeCharacter", "\\", "escapeCharacter", "java.lang.String"));
        ConnectorConfigProperty[] eProps = new ConnectorConfigProperty[propList.size()];
        ListIterator propListIter = propList.listIterator();
        int i = 0;
        while (propListIter.hasNext()) {
            eProps[i] = (ConnectorConfigProperty)propListIter.next();
            ++i;
        }
        return eProps;
    }

    private String escape(String value) {
        String seq = "\\";
        String replacement = "\\\\";
        value = value.replace(seq, replacement);
        seq = "#";
        replacement = "\\#";
        value = value.replace(seq, replacement);
        return value;
    }

    private boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(((String)prop).toLowerCase(locale));
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE) && msg != null) {
            _logger.fine(msg);
        }
    }

    public ConnectorConnectionPool createConnectorConnectionPool(JdbcConnectionPool adminPool, PoolInfo poolInfo) throws ConnectorRuntimeException {
        String moduleName = JdbcResourcesUtil.createInstance().getRANameofJdbcConnectionPool(adminPool);
        int txSupport = this.getTxSupport(moduleName);
        ConnectorDescriptor connDesc = this.runtime.getConnectorDescriptor(moduleName);
        ConnectorConnectionPool conConnPool = new ConnectorConnectionPool(poolInfo);
        conConnPool.setTransactionSupport(txSupport);
        this.setConnectorConnectionPoolAttributes(conConnPool, adminPool);
        ConnectorDescriptorInfo connDescInfo = this.createConnectorDescriptorInfo(connDesc, moduleName);
        connDescInfo.setMCFConfigProperties(this.getMCFConfigProperties(adminPool, conConnPool, connDesc));
        connDescInfo.setResourceAdapterConfigProperties((Set)null);
        conConnPool.setConnectorDescriptorInfo(connDescInfo);
        return conConnPool;
    }

    private int getTxSupport(String moduleName) {
        if ("__xa_jdbc_ra".equals(moduleName)) {
            return ConnectionPoolObjectsUtils.parseTransactionSupportString("XATransaction");
        }
        return ConnectionPoolObjectsUtils.parseTransactionSupportString("LocalTransaction");
    }

    private ConnectorDescriptorInfo createConnectorDescriptorInfo(ConnectorDescriptor connDesc, String moduleName) {
        ConnectorDescriptorInfo connDescInfo = new ConnectorDescriptorInfo();
        connDescInfo.setManagedConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getManagedConnectionFactoryImpl());
        connDescInfo.setRarName(moduleName);
        connDescInfo.setResourceAdapterClassName(connDesc.getResourceAdapterClass());
        connDescInfo.setConnectionDefinitionName(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionFactoryClass(connDesc.getOutboundResourceAdapter().getConnectionFactoryImpl());
        connDescInfo.setConnectionFactoryInterface(connDesc.getOutboundResourceAdapter().getConnectionFactoryIntf());
        connDescInfo.setConnectionClass(connDesc.getOutboundResourceAdapter().getConnectionImpl());
        connDescInfo.setConnectionInterface(connDesc.getOutboundResourceAdapter().getConnectionIntf());
        return connDescInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setConnectorConnectionPoolAttributes(ConnectorConnectionPool ccp, JdbcConnectionPool adminPool) {
        String poolName = ccp.getName();
        ccp.setMaxPoolSize(adminPool.getMaxPoolSize());
        ccp.setSteadyPoolSize(adminPool.getSteadyPoolSize());
        ccp.setMaxWaitTimeInMillis(adminPool.getMaxWaitTimeInMillis());
        ccp.setPoolResizeQuantity(adminPool.getPoolResizeQuantity());
        ccp.setIdleTimeoutInSeconds(adminPool.getIdleTimeoutInSeconds());
        ccp.setFailAllConnections(Boolean.valueOf(adminPool.getFailAllConnections()));
        ccp.setConnectionValidationRequired(Boolean.valueOf(adminPool.getIsConnectionValidationRequired()));
        ccp.setNonTransactional(Boolean.valueOf(adminPool.getNonTransactionalConnections()));
        ccp.setNonComponent(Boolean.valueOf(adminPool.getAllowNonComponentCallers()));
        ccp.setPingDuringPoolCreation(Boolean.valueOf(adminPool.getPing()));
        ccp.setMatchConnections(Boolean.valueOf(adminPool.getMatchConnections()));
        ccp.setAssociateWithThread(Boolean.valueOf(adminPool.getAssociateWithThread()));
        ccp.setConnectionLeakTracingTimeout(adminPool.getConnectionLeakTimeoutInSeconds());
        ccp.setConnectionReclaim(Boolean.valueOf(adminPool.getConnectionLeakReclaim()));
        boolean lazyConnectionEnlistment = Boolean.valueOf(adminPool.getLazyConnectionEnlistment());
        boolean lazyConnectionAssociation = Boolean.valueOf(adminPool.getLazyConnectionAssociation());
        if (lazyConnectionAssociation) {
            if (!lazyConnectionEnlistment) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", poolName);
                String i18nMsg = sm.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination", poolName);
                throw new RuntimeException(i18nMsg);
            }
            ccp.setLazyConnectionAssoc(true);
            ccp.setLazyConnectionEnlist(true);
        } else {
            ccp.setLazyConnectionAssoc(lazyConnectionAssociation);
            ccp.setLazyConnectionEnlist(lazyConnectionEnlistment);
        }
        boolean pooling = Boolean.valueOf(adminPool.getPooling());
        if (!pooling) {
            if (Boolean.valueOf(adminPool.getAssociateWithThread()).booleanValue()) {
                _logger.log(Level.SEVERE, "conn_pool_obj_utils.pooling_disabled_assocwiththread_invalid_combination", poolName);
                String i18nMsg = sm.getString("cpou.pooling_disabled_assocwiththread_invalid_combination", poolName);
                throw new RuntimeException(i18nMsg);
            }
            if (Boolean.valueOf(adminPool.getIsConnectionValidationRequired()).booleanValue()) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_conn_validation_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getValidateAtmostOncePeriodInSeconds()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_validate_atmost_once_invalid_combination", poolName);
            }
            if (Boolean.valueOf(adminPool.getMatchConnections()).booleanValue()) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_match_connections_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getMaxConnectionUsageCount()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_max_conn_usage_invalid_combination", poolName);
            }
            if (Integer.parseInt(adminPool.getIdleTimeoutInSeconds()) > 0) {
                _logger.log(Level.WARNING, "conn_pool_obj_utils.pooling_disabled_idle_timeout_invalid_combination", poolName);
            }
        }
        ccp.setPooling(pooling);
        ccp.setMaxConnectionUsage(adminPool.getMaxConnectionUsageCount());
        ccp.setConCreationRetryAttempts(adminPool.getConnectionCreationRetryAttempts());
        ccp.setConCreationRetryInterval(adminPool.getConnectionCreationRetryIntervalInSeconds());
        ccp.setValidateAtmostOncePeriod(adminPool.getValidateAtmostOncePeriodInSeconds());
    }

    @Override
    public synchronized void redeployResource(Object resource) throws Exception {
        JdbcConnectionPool adminPool = (JdbcConnectionPool)resource;
        PoolInfo poolInfo = ConnectorsUtil.getPoolInfo(adminPool);
        if (!this.runtime.isConnectorConnectionPoolDeployed(poolInfo)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("The JDBC connection pool " + poolInfo + " is not referred or not yet created in this server " + "instance and hence pool redeployment is ignored");
            }
            return;
        }
        ConnectorConnectionPool connConnPool = this.createConnectorConnectionPool(adminPool, poolInfo);
        if (connConnPool == null) {
            throw new ConnectorRuntimeException("Unable to create ConnectorConnectionPoolfrom JDBC connection pool");
        }
        HashSet<String> excludes = new HashSet<String>();
        excludes.add("TransactionIsolation");
        excludes.add("GuaranteeIsolationLevel");
        excludes.add("ValidationTableName");
        excludes.add("ConnectionValidationRequired");
        excludes.add("ValidationMethod");
        excludes.add("StatementWrapping");
        excludes.add("StatementTimeout");
        excludes.add("ValidationClassName");
        excludes.add("StatementCacheSize");
        excludes.add("StatementCacheType");
        excludes.add("StatementLeakTimeoutInSeconds");
        excludes.add("StatementLeakReclaim");
        try {
            boolean requirePoolRecreation;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Calling reconfigure pool");
            }
            if (requirePoolRecreation = this.runtime.reconfigureConnectorConnectionPool(connConnPool, excludes)) {
                if (this.runtime.isServer() || this.runtime.isEmbedded()) {
                    this.handlePoolRecreation(connConnPool);
                } else {
                    this.recreatePool(connConnPool);
                }
            }
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{poolInfo, cre};
            _logger.log(Level.WARNING, "error.redeploying.jdbc.pool", params);
            throw cre;
        }
    }

    private void handlePoolRecreation(final ConnectorConnectionPool connConnPool) throws ConnectorRuntimeException {
        this.debug("[DRC] Pool recreation required");
        final long reconfigWaitTimeout = connConnPool.getDynamicReconfigWaitTimeout();
        PoolInfo poolInfo = new PoolInfo(connConnPool.getName(), connConnPool.getApplicationName(), connConnPool.getModuleName());
        final ResourcePool oldPool = this.runtime.getPoolManager().getPool(poolInfo);
        if (reconfigWaitTimeout > 0L) {
            oldPool.blockRequests(reconfigWaitTimeout);
            if (oldPool.getPoolWaitQueue().getQueueLength() > 0 || oldPool.getPoolStatus().getNumConnUsed() > 0) {
                Runnable thread = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        block10: {
                            try {
                                long numSeconds = 5000L;
                                long steps = reconfigWaitTimeout / numSeconds;
                                if (steps == 0L) {
                                    JdbcConnectionPoolDeployer.this.waitForCompletion(steps, oldPool, reconfigWaitTimeout);
                                } else {
                                    for (long i = 0L; i < steps; ++i) {
                                        JdbcConnectionPoolDeployer.this.waitForCompletion(steps, oldPool, reconfigWaitTimeout);
                                        if (oldPool.getPoolWaitQueue().getQueueLength() != 0 || oldPool.getPoolStatus().getNumConnUsed() != 0) continue;
                                        JdbcConnectionPoolDeployer.this.debug("wait-queue is empty and num-con-used is 0");
                                        break;
                                    }
                                }
                                JdbcConnectionPoolDeployer.this.handlePoolRecreationForExistingProxies(connConnPool);
                                PoolWaitQueue reconfigWaitQueue = oldPool.getReconfigWaitQueue();
                                JdbcConnectionPoolDeployer.this.debug("checking reconfig-wait-queue for notification");
                                if (reconfigWaitQueue.getQueueContents().size() > 0) {
                                    for (Object o : reconfigWaitQueue.getQueueContents()) {
                                        JdbcConnectionPoolDeployer.this.debug("notifying reconfig-wait-queue object [ " + o + " ]");
                                        Object e = o;
                                        synchronized (e) {
                                            o.notify();
                                        }
                                    }
                                }
                            }
                            catch (InterruptedException ie) {
                                if (!_logger.isLoggable(Level.FINEST)) break block10;
                                _logger.log(Level.FINEST, "Interrupted while waiting for all existing clients to return connections to pool", ie);
                            }
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("woke-up after giving time for in-use connections to return, WaitQueue-Length : [" + oldPool.getPoolWaitQueue().getQueueContents() + "], " + "Num-Conn-Used : [" + oldPool.getPoolStatus().getNumConnUsed() + "]");
                        }
                    }
                };
                Callable<Object> c = Executors.callable(thread);
                ArrayList<Callable<Object>> list = new ArrayList<Callable<Object>>();
                list.add(c);
                try {
                    this.execService.invokeAll(list);
                }
                catch (Exception e) {
                    Object[] params = new Object[]{connConnPool.getName(), e};
                    _logger.log(Level.WARNING, "exception.redeploying.pool.transparently", params);
                }
            } else {
                this.handlePoolRecreationForExistingProxies(connConnPool);
            }
        } else if (oldPool.getReconfigWaitTime() > 0L) {
            Collection<BindableResource> resources = JdbcResourcesUtil.getResourcesOfPool(this.runtime.getResources(oldPool.getPoolInfo()), oldPool.getPoolInfo().getName());
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            for (BindableResource resource : resources) {
                ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(resource);
                registry.removeResourceFactories(resourceInfo);
            }
            this.recreatePool(connConnPool);
        } else {
            this.recreatePool(connConnPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion(long steps, ResourcePool oldPool, long totalWaitTime) throws InterruptedException {
        this.debug("waiting for in-use connections to return to pool or waiting requests to complete");
        try {
            PoolWaitQueue poolWaitQueue;
            PoolWaitQueue poolWaitQueue2 = poolWaitQueue = oldPool.getPoolWaitQueue();
            synchronized (poolWaitQueue2) {
                long waitTime = totalWaitTime / steps;
                if (waitTime > 0L) {
                    poolWaitQueue.wait(waitTime);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.debug("woke-up to verify in-use / waiting requests list");
    }

    private void handlePoolRecreationForExistingProxies(ConnectorConnectionPool connConnPool) {
        Collection<BindableResource> resourcesList;
        this.recreatePool(connConnPool);
        if (!connConnPool.isApplicationScopedResource()) {
            resourcesList = JdbcResourcesUtil.getResourcesOfPool(this.domain.getResources(), connConnPool.getName());
        } else {
            PoolInfo poolInfo = connConnPool.getPoolInfo();
            Resources resources = ResourcesUtil.createInstance().getResources(poolInfo);
            resourcesList = JdbcResourcesUtil.getResourcesOfPool(resources, connConnPool.getName());
        }
        for (BindableResource bindableResource : resourcesList) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo(bindableResource);
            ConnectorRegistry.getInstance().updateResourceInfoVersion(resourceInfo);
        }
    }

    private void recreatePool(ConnectorConnectionPool connConnPool) {
        try {
            this.runtime.recreateConnectorConnectionPool(connConnPool);
            this.debug("Pool [" + connConnPool.getName() + "] recreation done");
        }
        catch (ConnectorRuntimeException cre) {
            Object[] params = new Object[]{connConnPool.getName(), cre};
            _logger.log(Level.WARNING, "error.redeploying.jdbc.pool", params);
        }
    }

    @Override
    public synchronized void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public synchronized void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[DRC] : " + message);
        }
    }
}

