/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelContext;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.internal.RunLevelControllerImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class RunLevelServiceUtilities {
    public static void enableRunLevelService(ServiceLocator locator) {
        if (locator.getService(RunLevelContext.class, new Annotation[0]) != null) {
            return;
        }
        ServiceLocatorUtilities.addClasses(locator, RunLevelContext.class, AsyncRunLevelContext.class, RunLevelControllerImpl.class);
    }

    public static RunLevel getRunLevelAnnotation(int value) {
        return RunLevelServiceUtilities.getRunLevelAnnotation(value, 1);
    }

    public static RunLevel getRunLevelAnnotation(int value, int mode) {
        return new RunLevelImpl(value, mode);
    }

    private static class RunLevelImpl
    extends AnnotationLiteral<RunLevel>
    implements RunLevel {
        private static final long serialVersionUID = -359213687920354669L;
        private final int value;
        private final int mode;

        private RunLevelImpl(int value, int mode) {
            this.value = value;
            this.mode = mode;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public int mode() {
            return this.mode;
        }
    }
}

