/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.AOPProxyCtl;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfigurationListener;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InstanceLifecycleEvent;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.api.messaging.SubscribeTo;
import org.glassfish.hk2.api.messaging.Topic;
import org.glassfish.hk2.api.messaging.TopicDistributionService;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DefaultTopicDistributionErrorService;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.TypeChecker;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Optional;

@Singleton
@Named(value="HK2TopicDistributionService")
@ContractsProvided(value={TopicDistributionService.class, InstanceLifecycleListener.class, DynamicConfigurationListener.class})
public class DefaultTopicDistributionService
implements TopicDistributionService,
InstanceLifecycleListener,
DynamicConfigurationListener {
    @Inject
    private ServiceLocator locator;
    @Inject
    private IterableProvider<DefaultTopicDistributionErrorService> errorHandlers;
    private final ClassReflectionHelper reflectionHelper = new ClassReflectionHelperImpl();
    private final HashMap<ActiveDescriptor<?>, Set<Class<?>>> descriptor2Classes = new HashMap();
    private final HashMap<ActivatorClassKey, List<SubscriberInfo>> class2Subscribers = new HashMap();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.readWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.readWriteLock.readLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fire(Object message, Method subscription, SubscriberInfo subscriptionInfo, Object target, ServiceLocator locator) throws Throwable {
        Object[] arguments = new Object[subscriptionInfo.otherInjectees.length];
        LinkedList destroyMe = new LinkedList();
        try {
            for (int lcv = 0; lcv < subscriptionInfo.otherInjectees.length; ++lcv) {
                InjecteeImpl injecteeImpl = subscriptionInfo.otherInjectees[lcv];
                if (injecteeImpl == null) {
                    arguments[lcv] = message;
                    continue;
                }
                if (injecteeImpl.isSelf()) {
                    arguments[lcv] = injecteeImpl.getInjecteeDescriptor();
                    continue;
                }
                ActiveDescriptor<?> injecteeDescriptor = locator.getInjecteeDescriptor(injecteeImpl);
                if (injecteeDescriptor == null) {
                    if (injecteeImpl.isOptional()) {
                        arguments[lcv] = null;
                        continue;
                    }
                    throw new IllegalStateException("Could not find injectee " + injecteeImpl + " for subscriber " + Pretty.method(subscription) + " on class " + target.getClass().getName());
                }
                ServiceHandle<?> handle = locator.getServiceHandle(injecteeDescriptor);
                if (injecteeDescriptor.getScope().equals(PerLookup.class.getName())) {
                    destroyMe.add(handle);
                }
                arguments[lcv] = handle.getService();
            }
            ReflectionHelper.invoke(target, subscription, arguments, locator.getNeutralContextClassLoader());
        }
        finally {
            for (ServiceHandle serviceHandle : destroyMe) {
                serviceHandle.destroy();
            }
        }
    }

    private List<FireResults> handleDescriptorToClass(ActiveDescriptor<?> descriptor, Class<?> clazz, Type eventType, Topic<?> topic) {
        LinkedList<FireResults> retVal = new LinkedList<FireResults>();
        List<SubscriberInfo> subscribers = this.class2Subscribers.get(new ActivatorClassKey(descriptor, clazz));
        if (subscribers == null) {
            subscribers = Collections.emptyList();
        }
        for (SubscriberInfo subscriberInfo : subscribers) {
            Type subscriptionType = subscriberInfo.eventType;
            if (!TypeChecker.isRawTypeSafe(subscriptionType, eventType) || !subscriberInfo.eventQualifiers.isEmpty() && !ReflectionHelper.annotationContainsAll(topic.getTopicQualifiers(), subscriberInfo.eventQualifiers)) continue;
            if (subscriberInfo.unqualified != null && !topic.getTopicQualifiers().isEmpty()) {
                if (subscriberInfo.unqualified.value().length == 0) continue;
                HashSet<Class<? extends Annotation>> topicQualifierClasses = new HashSet<Class<? extends Annotation>>();
                for (Annotation topicQualifier : topic.getTopicQualifiers()) {
                    topicQualifierClasses.add(topicQualifier.annotationType());
                }
                boolean found = false;
                for (Class<? extends Annotation> verbotenQualifier : subscriberInfo.unqualified.value()) {
                    if (!topicQualifierClasses.contains(verbotenQualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            for (WeakReference targetReference : subscriberInfo.targets) {
                Object target = targetReference.get();
                retVal.add(new FireResults(subscriberInfo.method, subscriberInfo, target));
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void distributeMessage(Topic<?> topic, Object message) {
        Type eventType = topic.getTopicType();
        LinkedList<FireResults> fireResults = new LinkedList<FireResults>();
        this.rLock.lock();
        try {
            for (Map.Entry<ActiveDescriptor<?>, Set<Class<?>>> d2cEntry : this.descriptor2Classes.entrySet()) {
                for (Class<?> clazz : d2cEntry.getValue()) {
                    fireResults.addAll(this.handleDescriptorToClass(d2cEntry.getKey(), clazz, eventType, topic));
                }
            }
        }
        finally {
            this.rLock.unlock();
        }
        HashSet<SubscriberInfo> hasDeadReferences = new HashSet<SubscriberInfo>();
        MultiException errors = null;
        for (FireResults fireResults2 : fireResults) {
            if (fireResults2.target == null) {
                hasDeadReferences.add(fireResults2.subscriberInfo);
                continue;
            }
            try {
                DefaultTopicDistributionService.fire(message, fireResults2.subscriberMethod, fireResults2.subscriberInfo, fireResults2.target, this.locator);
            }
            catch (Throwable th) {
                if (errors == null) {
                    errors = new MultiException(th);
                    continue;
                }
                errors.addError(th);
            }
        }
        if (errors != null) {
            for (ServiceHandle serviceHandle : this.errorHandlers.handleIterator()) {
                try {
                    ((DefaultTopicDistributionErrorService)serviceHandle.getService()).subscribersFailed(topic, message, errors);
                    if (!serviceHandle.getActiveDescriptor().getScope().equals(PerLookup.class.getName())) continue;
                    serviceHandle.destroy();
                }
                catch (Throwable ignore) {}
            }
        }
        if (!hasDeadReferences.isEmpty()) {
            this.wLock.lock();
            try {
                for (SubscriberInfo subscriberInfo : hasDeadReferences) {
                    Iterator iterator = subscriberInfo.targets.iterator();
                    while (iterator.hasNext()) {
                        WeakReference ref = (WeakReference)iterator.next();
                        if (ref.get() != null) continue;
                        iterator.remove();
                    }
                }
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    @Override
    public Filter getFilter() {
        return BuilderHelper.allFilter();
    }

    private void postProduction(InstanceLifecycleEvent lifecycleEvent) {
        ActiveDescriptor<?> activeDescriptor;
        ActiveDescriptor<?> descriptor = lifecycleEvent.getActiveDescriptor();
        Object target = lifecycleEvent.getLifecycleObject();
        if (target == null) {
            return;
        }
        Class<?> targetClass = target.getClass();
        Set<Class<?>> descriptorClazzes = this.descriptor2Classes.get(descriptor);
        List<Object> existingMethods = null;
        if (descriptorClazzes != null) {
            if (descriptorClazzes.contains(targetClass)) {
                existingMethods = this.class2Subscribers.get(new ActivatorClassKey(descriptor, targetClass));
                if (existingMethods != null) {
                    for (SubscriberInfo subscriberInfo : existingMethods) {
                        subscriberInfo.targets.add(new WeakReference<Object>(target));
                    }
                    return;
                }
            } else {
                descriptorClazzes.add(targetClass);
            }
        } else {
            descriptorClazzes = new HashSet();
            descriptorClazzes.add(targetClass);
            this.descriptor2Classes.put(descriptor, descriptorClazzes);
        }
        existingMethods = new LinkedList();
        this.class2Subscribers.put(new ActivatorClassKey(descriptor, targetClass), existingMethods);
        Class<?> resolvedClass = target instanceof AOPProxyCtl ? ((activeDescriptor = ((AOPProxyCtl)target).__getUnderlyingDescriptor()) == null ? targetClass : activeDescriptor.getImplementationClass()) : targetClass;
        Set<MethodWrapper> set = this.reflectionHelper.getAllMethods(resolvedClass);
        for (MethodWrapper methodWrapper : set) {
            Method useMethod;
            Annotation[][] paramAnnotations = methodWrapper.getMethod().getParameterAnnotations();
            int foundPosition = -1;
            for (int position = 0; position < paramAnnotations.length; ++position) {
                for (Annotation paramAnnotation : paramAnnotations[position]) {
                    if (!SubscribeTo.class.equals(paramAnnotation.annotationType())) continue;
                    if (foundPosition != -1) {
                        throw new IllegalArgumentException("A method " + Pretty.method(methodWrapper.getMethod()) + " on class " + methodWrapper.getMethod().getDeclaringClass().getName() + " has more than one @SubscribeTo annotation on its parameters");
                    }
                    foundPosition = position;
                }
            }
            if (foundPosition == -1) continue;
            if (resolvedClass == targetClass) {
                useMethod = methodWrapper.getMethod();
            } else {
                useMethod = this.findMethodOnDifferentClass(targetClass, methodWrapper.getMethod());
                if (useMethod == null) continue;
            }
            SubscriberInfo si = DefaultTopicDistributionService.generateSubscriberInfo(descriptor, methodWrapper.getMethod(), useMethod, foundPosition, paramAnnotations);
            si.targets.add(new WeakReference<Object>(target));
            existingMethods.add(si);
        }
    }

    private Method findMethodOnDifferentClass(Class<?> findOnMe, Method method) {
        if ((method.getModifiers() & 2) != 0) {
            return method;
        }
        if ((method.getModifiers() & 1) != 0) {
            try {
                return findOnMe.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Throwable th) {
                return null;
            }
        }
        Set<MethodWrapper> allMethods = this.reflectionHelper.getAllMethods(findOnMe);
        MethodWrapper findMe = this.reflectionHelper.createMethodWrapper(method);
        for (MethodWrapper allMethod : allMethods) {
            if (!allMethod.equals(findMe)) continue;
            return allMethod.getMethod();
        }
        return null;
    }

    private static SubscriberInfo generateSubscriberInfo(ActiveDescriptor<?> injecteeDescriptor, Method subscriber, Method useSubscriber, int subscribeToPosition, Annotation[][] paramAnnotations) {
        Annotation[] subscribeToAnnotations;
        Type[] parameterTypes = subscriber.getGenericParameterTypes();
        Type eventType = parameterTypes[subscribeToPosition];
        HashSet<Annotation> eventQualifiers = new HashSet<Annotation>();
        Unqualified eventUnqualified = null;
        for (Annotation possibleQualifier : subscribeToAnnotations = paramAnnotations[subscribeToPosition]) {
            if (ReflectionHelper.isAnnotationAQualifier(possibleQualifier)) {
                eventQualifiers.add(possibleQualifier);
            }
            if (!Unqualified.class.equals(possibleQualifier.annotationType())) continue;
            eventUnqualified = (Unqualified)possibleQualifier;
        }
        InjecteeImpl[] injectees = new InjecteeImpl[parameterTypes.length];
        for (int lcv = 0; lcv < injectees.length; ++lcv) {
            if (lcv == subscribeToPosition) {
                injectees[lcv] = null;
                continue;
            }
            InjecteeImpl ii = new InjecteeImpl();
            ii.setRequiredType(parameterTypes[lcv]);
            HashSet<Annotation> parameterQualifiers = new HashSet<Annotation>();
            Annotation[] parameterAnnotations = paramAnnotations[lcv];
            boolean isOptional = false;
            boolean isSelf = false;
            Unqualified unqualified = null;
            for (Annotation possibleQualifier : parameterAnnotations) {
                if (ReflectionHelper.isAnnotationAQualifier(possibleQualifier)) {
                    parameterQualifiers.add(possibleQualifier);
                }
                if (Optional.class.equals(possibleQualifier.annotationType())) {
                    isOptional = true;
                }
                if (Self.class.equals(possibleQualifier.annotationType())) {
                    isSelf = true;
                }
                if (!Unqualified.class.equals(possibleQualifier.annotationType())) continue;
                unqualified = (Unqualified)possibleQualifier;
            }
            ii.setRequiredQualifiers(parameterQualifiers);
            ii.setPosition(lcv);
            ii.setParent(useSubscriber);
            ii.setOptional(isOptional);
            ii.setSelf(isSelf);
            ii.setUnqualified(unqualified);
            ii.setInjecteeDescriptor(injecteeDescriptor);
            injectees[lcv] = ii;
        }
        return new SubscriberInfo(subscriber, eventType, eventQualifiers, eventUnqualified, injectees);
    }

    private void preDestruction(InstanceLifecycleEvent lifecycleEvent) {
        ActiveDescriptor<?> descriptor = lifecycleEvent.getActiveDescriptor();
        Object target = lifecycleEvent.getLifecycleObject();
        if (target == null) {
            return;
        }
        Set<Class<?>> classes = this.descriptor2Classes.get(descriptor);
        for (Class<?> clazz : classes) {
            List<SubscriberInfo> subscribers = this.class2Subscribers.get(new ActivatorClassKey(descriptor, clazz));
            for (SubscriberInfo subscriberInfo : subscribers) {
                Iterator targetIterator = subscriberInfo.targets.iterator();
                while (targetIterator.hasNext()) {
                    WeakReference ref = (WeakReference)targetIterator.next();
                    Object subscriberTarget = ref.get();
                    if (subscriberTarget == null) {
                        targetIterator.remove();
                        continue;
                    }
                    if (subscriberTarget != target) continue;
                    targetIterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(InstanceLifecycleEvent lifecycleEvent) {
        switch (lifecycleEvent.getEventType()) {
            case POST_PRODUCTION: {
                this.wLock.lock();
                try {
                    this.postProduction(lifecycleEvent);
                    break;
                }
                finally {
                    this.wLock.unlock();
                }
            }
            case PRE_DESTRUCTION: {
                this.wLock.lock();
                try {
                    this.preDestruction(lifecycleEvent);
                    break;
                }
                finally {
                    this.wLock.unlock();
                }
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged() {
        List<ActiveDescriptor<?>> allDescriptors = this.locator.getDescriptors(BuilderHelper.allFilter());
        this.wLock.lock();
        try {
            HashSet removeMe = new HashSet(this.descriptor2Classes.keySet());
            removeMe.removeAll(allDescriptors);
            for (ActiveDescriptor<?> activeDescriptor : removeMe) {
                Set<Class<?>> clazzes = this.descriptor2Classes.remove(activeDescriptor);
                if (clazzes == null) continue;
                for (Class<?> clazz : clazzes) {
                    this.class2Subscribers.remove(new ActivatorClassKey(activeDescriptor, clazz));
                }
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    private static class ActivatorClassKey {
        private final ActiveDescriptor<?> descriptor;
        private final Class<?> clazz;
        private final int hashCode;

        private ActivatorClassKey(ActiveDescriptor<?> descriptor, Class<?> clazz) {
            this.descriptor = descriptor;
            this.clazz = clazz;
            this.hashCode = descriptor.hashCode() ^ clazz.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof ActivatorClassKey)) {
                return false;
            }
            ActivatorClassKey other = (ActivatorClassKey)o;
            return this.descriptor.equals(other.descriptor) && this.clazz.equals(other.clazz);
        }
    }

    private static class FireResults {
        private final Method subscriberMethod;
        private final SubscriberInfo subscriberInfo;
        private final Object target;

        private FireResults(Method subscriberMethod, SubscriberInfo subscriberInfo, Object target) {
            this.subscriberMethod = subscriberMethod;
            this.subscriberInfo = subscriberInfo;
            this.target = target;
        }
    }

    private static class SubscriberInfo {
        private final Method method;
        private final LinkedList<WeakReference<Object>> targets = new LinkedList();
        private final Type eventType;
        private final Set<Annotation> eventQualifiers;
        private final Unqualified unqualified;
        private final InjecteeImpl[] otherInjectees;

        private SubscriberInfo(Method method, Type eventType, Set<Annotation> eventQualifiers, Unqualified unqualified, InjecteeImpl[] otherInjectees) {
            this.method = method;
            this.eventType = eventType;
            this.eventQualifiers = eventQualifiers;
            this.unqualified = unqualified;
            this.otherInjectees = otherInjectees;
        }
    }
}

