/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.glassfish.grizzly.config.ssl.JSSEKeyManager;
import org.glassfish.grizzly.config.ssl.JSSESocketFactory;
import org.glassfish.grizzly.http.util.StringManager;

public class JSSE14SocketFactory
extends JSSESocketFactory {
    private static final StringManager sm = StringManager.getManager(JSSE14SocketFactory.class.getPackage().getName(), JSSE14SocketFactory.class.getClassLoader());

    @Override
    public void init() throws IOException {
        try {
            String algorithm;
            this.clientAuthNeed = Boolean.valueOf((String)this.attributes.get("clientAuthNeed"));
            this.clientAuthWant = Boolean.valueOf((String)this.attributes.get("clientAuthWant"));
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = "TLS";
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            this.context = SSLContext.getInstance(protocol);
            this.configureSSLSessionContext(this.context.getServerSessionContext());
            String trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm");
            if (trustAlgorithm == null) {
                trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            this.context.init(this.getKeyManagers(algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(trustAlgorithm), new SecureRandom());
            this.sslProxy = this.context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            if (requestedCiphers != null) {
                this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
            }
            this.checkConfig();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String algorithm) throws Exception {
        String crlFile = (String)this.attributes.get("crlFile");
        TrustManager[] tms = null;
        KeyStore trustStore = this.getTrustStore();
        if (trustStore != null) {
            if (crlFile == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlFile, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = (String)this.attributes.get("trustMaxCertLength");
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    logger.warning("Bad maxCertLength: " + trustLength);
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        PKIXBuilderParameters params = xparams;
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return crls;
    }

    @Override
    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    @Override
    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] enabledProtocols = null;
        if (requestedProtocols != null) {
            ArrayList<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (supportedProtocols != null && protocol.length() > 0) {
                        String[] stringArray = supportedProtocols;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String supportedProtocol = stringArray[i];
                            if (!supportedProtocol.equals(protocol)) continue;
                            if (vec == null) {
                                vec = new ArrayList();
                            }
                            vec.add(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            assert (protocol != null);
            if ((protocol = protocol.trim()).length() > 0 && supportedProtocols != null) {
                for (String supportedProtocol : supportedProtocols) {
                    if (!supportedProtocol.equals(protocol)) continue;
                    if (vec == null) {
                        vec = new ArrayList<String>();
                    }
                    vec.add(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = vec.toArray(new String[vec.size()]);
            }
        }
        return enabledProtocols;
    }

    private void configureSSLSessionContext(SSLSessionContext sslSessionCtxt) {
        String attrValue = (String)this.attributes.get("sslSessionTimeout");
        if (attrValue != null) {
            sslSessionCtxt.setSessionTimeout(Integer.valueOf(attrValue));
        }
        if ((attrValue = (String)this.attributes.get("ssl3SessionTimeout")) != null) {
            sslSessionCtxt.setSessionTimeout(Integer.valueOf(attrValue));
        }
        if ((attrValue = (String)this.attributes.get("sslSessionCacheSize")) != null) {
            sslSessionCtxt.setSessionCacheSize(Integer.valueOf(attrValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() throws IOException {
        ServerSocket socket = this.sslProxy.createServerSocket();
        this.initServerSocket(socket);
        try {
            socket.setSoTimeout(1);
            socket.accept();
        }
        catch (SSLException ssle) {
            IOException ioe = new IOException(sm.getString("jsse.invalid_ssl_conf", ssle.getMessage()));
            ioe.initCause(ssle);
            throw ioe;
        }
        catch (Exception exception) {
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }
}

