/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.dom;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.glassfish.grizzly.config.dom.Range;

public class RangeValidator
implements ConstraintValidator<Range, String> {
    private int min;
    private int max;

    @Override
    public void initialize(Range range) {
        this.min = range.min();
        this.max = range.max();
    }

    @Override
    public boolean isValid(String s, ConstraintValidatorContext constraintValidatorContext) {
        if (s == null) {
            return true;
        }
        try {
            int value = Integer.parseInt(s);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return s.charAt(0) == '$' && s.charAt(1) == '{' && s.charAt(s.length() - 1) == '}';
        }
    }
}

