/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.enterprise.util.i18n.StringManager;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DomainXmlTransformer {
    private File in;
    private File out;
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private Logger _logger = Logger.getAnonymousLogger("com.sun.logging.enterprise.system.container.ejb.LogStrings");
    private static final String VIRTUAL_SERVER = "virtual-server";
    private static final String NETWORK_LISTENERS = "network-listeners";
    private static final String IIOP_LISTENER = "iiop-listener";
    private static final String PROTOCOLS = "protocols";
    private static final String APPLICATIONS = "applications";
    private static final String APPLICATION_REF = "application-ref";
    private static final String CLUSTERS = "clusters";
    private static final String JMS_HOST = "jms-host";
    private static final String JMX_CONNECTOR = "jmx-connector";
    private static final String LAZY_INIT_ATTR = "lazy-init";
    private static final String ADMIN_SERVICE = "admin-service";
    private static final String DAS_CONFIG = "das-config";
    private static final String DYNAMIC_RELOAD_ENABLED = "dynamic-reload-enabled";
    private static final String JAVA_CONFIG = "java-config";
    private static final String JVM_OPTIONS = "jvm-options";
    private static final String INITIALIZE_ON_DEMAND = "-Dorg.glassfish.jms.InitializeOnDemand=true";
    private static final String ENABLED = "enabled";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final Set<String> SKIP_ELEMENTS = new HashSet<String>(Arrays.asList("application-ref"));
    private static final Set<String> EMPTY_ELEMENTS = new HashSet<String>(Arrays.asList("network-listeners", "protocols", "applications", "clusters"));
    private static final Set<String> EMPTY_ELEMENTS_KEEP_PORTS = new HashSet<String>(Arrays.asList("applications", "clusters"));
    private static final Set<String> SKIP_SETTINGS_ELEMENTS = new HashSet<String>(Arrays.asList("iiop-listener"));
    private static final Set<String> DISABLE_ELEMENTS = new HashSet<String>(Arrays.asList("jmx-connector"));
    private static final Set<String> DISABLE_SUB_ELEMENTS = new HashSet<String>(Arrays.asList("lazy-init"));
    private static final StringManager localStrings = StringManager.getManager(DomainXmlTransformer.class);

    public DomainXmlTransformer(File domainXml) {
        this.in = domainXml;
    }

    public DomainXmlTransformer(File domainXml, Logger logger2) {
        this.in = domainXml;
        this._logger = logger2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File transform(boolean keepPorts) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        XMLEventReader parser = null;
        XMLEventWriter writer = null;
        XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newInstance() : XMLInputFactory.newInstance(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
        Set<String> empty_elements = keepPorts ? EMPTY_ELEMENTS_KEEP_PORTS : EMPTY_ELEMENTS;
        try {
            fis = new FileInputStream(this.in);
            this.out = File.createTempFile("domain", "xml");
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("[DomainXmlTransformer] Creating temp domain file: " + this.out);
            }
            if (System.getProperty("org.glassfish.ejb.embedded.keep-temporary-files") == null) {
                this.out.deleteOnExit();
            }
            fos = new FileOutputStream(this.out);
            parser = xif.createXMLEventReader(fis);
            writer = this.xof.createXMLEventWriter(fos);
            boolean fixedDasConfig = false;
            while (parser.hasNext()) {
                String name;
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement()) {
                    name = event.asStartElement().getName().getLocalPart();
                    if (SKIP_ELEMENTS.contains(name)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("[DomainXmlTransformer] Skipping all of: " + name);
                        }
                        this.getEndEventFor(parser, name);
                        continue;
                    }
                    boolean skip_to_end = false;
                    if (empty_elements.contains(name)) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("[DomainXmlTransformer] Skipping details of: " + name);
                        }
                        skip_to_end = true;
                    } else if (SKIP_SETTINGS_ELEMENTS.contains(name)) {
                        event = this.getSkippedElementStartEvent(event);
                        skip_to_end = true;
                    } else if (DISABLE_ELEMENTS.contains(name)) {
                        event = this.getReplaceAttributeInStartEvent(event, ENABLED, FALSE);
                        skip_to_end = true;
                    } else if (JMS_HOST.equals(name)) {
                        event = this.getReplaceAttributeInStartEvent(event, LAZY_INIT_ATTR, FALSE);
                        skip_to_end = true;
                    } else if (DAS_CONFIG.equals(name)) {
                        event = this.getReplaceAttributeInStartEvent(event, DYNAMIC_RELOAD_ENABLED, FALSE);
                        fixedDasConfig = true;
                        skip_to_end = true;
                    } else if (JAVA_CONFIG.equals(name)) {
                        writer.add(event);
                        event = this.getAddedEvent(event, writer, JVM_OPTIONS, INITIALIZE_ON_DEMAND);
                    }
                    if (skip_to_end) {
                        writer.add(event);
                        event = this.getEndEventFor(parser, name);
                    }
                } else if (event.isEndElement() && ADMIN_SERVICE.equals(name = event.asEndElement().getName().getLocalPart())) {
                    if (!fixedDasConfig) {
                        writer.add(this.getAddedEventBeforeEndElement(event, writer, DAS_CONFIG, DYNAMIC_RELOAD_ENABLED, FALSE));
                    }
                    fixedDasConfig = false;
                }
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.finest("[DomainXmlTransformer] Processing: " + event);
                }
                writer.add(event);
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "ejb.embedded.tmp_file_create_error", e.getMessage());
            this._logger.log(Level.FINE, e.getMessage(), e);
            File file = null;
            return file;
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("[DomainXmlTransformer] Created temp domain file: " + this.out);
        }
        return this.out;
    }

    private XMLEvent getEndEventFor(XMLEventReader parser, String name) throws XMLStreamException, EOFException {
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(name)) continue;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("[DomainXmlTransformer] END: " + name);
            }
            return event;
        }
        throw new EOFException(localStrings.getString("ejb.embedded.no_matching_end_element", name));
    }

    private StartElement getSkippedElementStartEvent(XMLEvent event) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Iterator<Attribute> i = event.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (DISABLE_SUB_ELEMENTS.contains(a.getName().getLocalPart())) continue;
            attributes.add(a);
        }
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), attributes.iterator(), oldStartEvent.getNamespaces());
    }

    private XMLEvent getAddedEvent(XMLEvent event, XMLEventWriter writer, String elementName, String text) throws XMLStreamException {
        StartElement oldStartEvent = event.asStartElement();
        StartElement newStartEvent = this.xmlEventFactory.createStartElement(new QName(elementName), null, oldStartEvent.getNamespaces());
        writer.add(newStartEvent);
        writer.add(this.xmlEventFactory.createCharacters(text));
        return this.xmlEventFactory.createEndElement(newStartEvent.getName(), newStartEvent.getNamespaces());
    }

    private XMLEvent getAddedEventBeforeEndElement(XMLEvent event, XMLEventWriter writer, String elementName, String attributeName, String attributeValue) throws XMLStreamException {
        Attribute newAttribute = this.xmlEventFactory.createAttribute(attributeName, attributeValue);
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        attributes.add(newAttribute);
        EndElement oldEvent = event.asEndElement();
        StartElement newStartEvent = this.xmlEventFactory.createStartElement(new QName(elementName), attributes.iterator(), oldEvent.getNamespaces());
        writer.add(newStartEvent);
        return this.xmlEventFactory.createEndElement(newStartEvent.getName(), newStartEvent.getNamespaces());
    }

    private StartElement getReplaceAttributeInStartEvent(XMLEvent event, String attr_name, String attr_value) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        Iterator<Attribute> i = event.asStartElement().getAttributes();
        while (i.hasNext()) {
            Attribute a = i.next();
            if (a.getName().getLocalPart().equals(attr_name)) continue;
            attributes.add(a);
        }
        Attribute newAttribute = this.xmlEventFactory.createAttribute(attr_name, attr_value);
        attributes.add(newAttribute);
        StartElement oldStartEvent = event.asStartElement();
        return this.xmlEventFactory.createStartElement(oldStartEvent.getName(), attributes.iterator(), oldStartEvent.getNamespaces());
    }
}

