/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.CommonResourceDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.ejb.deployment.BeanMethodCalculatorImpl;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.ScheduledTimerDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.ejb.deployment.util.EjbVisitor;
import org.glassfish.ejb.deployment.util.InterceptorBindingTranslator;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Role;

public abstract class EjbDescriptor
extends CommonResourceDescriptor
implements com.sun.enterprise.deployment.EjbDescriptor {
    private String homeClassName;
    private String remoteClassName;
    private String localHomeClassName;
    private String localClassName;
    private Set<String> remoteBusinessClassNames = new HashSet<String>();
    private Set<String> localBusinessClassNames = new HashSet<String>();
    private Set<String> noInterfaceLocalBeanClassNames = new HashSet<String>();
    private String webServiceEndpointInterfaceName;
    private String jndiName = "";
    private String mappedName = "";
    private boolean localBean = false;
    public static final String LOCAL_TRANSACTION_SCOPE = "Local";
    public static final String DISTRIBUTED_TRANSACTION_SCOPE = "Distributed";
    protected String transactionType = null;
    protected boolean usesDefaultTransaction = false;
    private Hashtable methodContainerTransactions = null;
    private Hashtable permissionedMethodsByPermission = null;
    private HashMap methodPermissionsFromDD = null;
    private Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private Set<EjbReference> ejbReferences = new HashSet<EjbReference>();
    private Set<ResourceEnvReferenceDescriptor> resourceEnvReferences = new HashSet<ResourceEnvReferenceDescriptor>();
    private Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();
    private Set<LifecycleCallbackDescriptor> postConstructDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<LifecycleCallbackDescriptor> preDestroyDescs = new HashSet<LifecycleCallbackDescriptor>();
    private WritableJndiNameEnvironment env;
    private Set<LifecycleCallbackDescriptor> aroundInvokeDescs = new HashSet<LifecycleCallbackDescriptor>();
    private Set<LifecycleCallbackDescriptor> aroundTimeoutDescs = new HashSet<LifecycleCallbackDescriptor>();
    private List<InterceptorDescriptor> frameworkInterceptors = new LinkedList<InterceptorDescriptor>();
    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private Set roleReferences = new HashSet();
    private EjbBundleDescriptorImpl bundleDescriptor;
    private Set<EjbIORConfigurationDescriptor> iorConfigDescriptors = new OrderedSet<EjbIORConfigurationDescriptor>();
    private String ejbClassName;
    private Set ejbReferencersPointingToMe = new HashSet();
    protected Boolean usesCallerIdentity = null;
    protected String securityIdentityDescription;
    protected boolean isDistributedTxScope = true;
    protected RunAsIdentityDescriptor runAsIdentity = null;
    private Map styledMethodDescriptors = new HashMap();
    private long uniqueId;
    private String remoteHomeImplClassName;
    private String ejbObjectImplClassName;
    private String localHomeImplClassName;
    private String ejbLocalObjectImplClassName;
    private MethodDescriptor timedObjectMethod;
    private List<ScheduledTimerDescriptor> timerSchedules = new ArrayList<ScheduledTimerDescriptor>();
    private List<MethodDescriptor> timerMethodDescriptors = new ArrayList<MethodDescriptor>();
    private Set<EjbInterceptor> allInterceptorClasses = new HashSet<EjbInterceptor>();
    private List<EjbInterceptor> interceptorChain = new LinkedList<EjbInterceptor>();
    private Map<MethodDescriptor, List<EjbInterceptor>> methodInterceptorsMap = new HashMap<MethodDescriptor, List<EjbInterceptor>>();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbDescriptor.class);
    static Logger _logger = DOLUtils.getDefaultLogger();
    private IASEjbExtraDescriptors iASEjbExtraDescriptors = new IASEjbExtraDescriptors();
    private final ServiceLocator sl = Globals.getDefaultHabitat();

    public IASEjbExtraDescriptors getIASEjbExtraDescriptors() {
        return this.iASEjbExtraDescriptors;
    }

    protected EjbDescriptor() {
    }

    public EjbDescriptor(EjbDescriptor other) {
        super(other);
        this.homeClassName = other.homeClassName;
        this.remoteClassName = other.remoteClassName;
        this.remoteBusinessClassNames = new HashSet<String>(other.remoteBusinessClassNames);
        this.localHomeClassName = other.localHomeClassName;
        this.localClassName = other.localClassName;
        this.localBusinessClassNames = new HashSet<String>(other.localBusinessClassNames);
        this.webServiceEndpointInterfaceName = other.webServiceEndpointInterfaceName;
        this.localBean = other.localBean;
        this.jndiName = other.jndiName;
        this.addEjbDescriptor(other);
    }

    @Override
    public abstract String getEjbTypeForDisplay();

    public void addEjbDescriptor(EjbDescriptor other) {
        this.setEjbBundleDescriptor(other.bundleDescriptor);
        this.transactionType = other.transactionType;
        this.methodContainerTransactions = new Hashtable(other.getMethodContainerTransactions());
        this.permissionedMethodsByPermission = new Hashtable(other.getPermissionedMethodsByPermission());
        if (other.env == null) {
            this.getEnvironmentProperties().addAll(other.getEnvironmentProperties());
            this.getEjbReferenceDescriptors().addAll(other.getEjbReferenceDescriptors());
            this.getResourceEnvReferenceDescriptors().addAll(other.getResourceEnvReferenceDescriptors());
            this.getMessageDestinationReferenceDescriptors().addAll(other.getMessageDestinationReferenceDescriptors());
            this.getResourceReferenceDescriptors().addAll(other.getResourceReferenceDescriptors());
            this.getServiceReferenceDescriptors().addAll(other.getServiceReferenceDescriptors());
            Set<ResourceDescriptor> allDescriptors = other.getAllResourcesDescriptors();
            if (allDescriptors.size() > 0) {
                for (ResourceDescriptor desc : allDescriptors) {
                    this.addResourceDescriptor(desc);
                }
            }
            this.getEntityManagerFactoryReferenceDescriptors().addAll(other.getEntityManagerFactoryReferenceDescriptors());
            this.getEntityManagerReferenceDescriptors().addAll(other.getEntityManagerReferenceDescriptors());
        }
        this.getRoleReferences().addAll(other.getRoleReferences());
        this.getIORConfigurationDescriptors().addAll(other.getIORConfigurationDescriptors());
        this.transactionType = other.transactionType;
        this.ejbClassName = other.ejbClassName;
        this.usesCallerIdentity = other.usesCallerIdentity;
        this.timerSchedules = new ArrayList<ScheduledTimerDescriptor>(other.timerSchedules);
        this.timerMethodDescriptors = new ArrayList<MethodDescriptor>(other.timerMethodDescriptors);
    }

    public abstract void setType(String var1);

    @Override
    public String getHomeClassName() {
        return this.homeClassName;
    }

    public void setHomeClassName(String homeClassName) {
        this.homeClassName = homeClassName;
    }

    public void setRemoteClassName(String remoteClassName) {
        this.remoteClassName = remoteClassName;
    }

    @Override
    public String getRemoteClassName() {
        return this.remoteClassName;
    }

    public void setLocalHomeClassName(String localHomeClassName) {
        this.localHomeClassName = localHomeClassName;
    }

    @Override
    public String getLocalHomeClassName() {
        return this.localHomeClassName;
    }

    public void setLocalClassName(String localClassName) {
        this.localClassName = localClassName;
    }

    @Override
    public String getLocalClassName() {
        return this.localClassName;
    }

    public void addNoInterfaceLocalBeanClass(String className) {
        this.noInterfaceLocalBeanClassNames.add(className);
    }

    public Set<String> getNoInterfaceLocalBeanClasses() {
        return this.noInterfaceLocalBeanClassNames;
    }

    public void addRemoteBusinessClassName(String className) {
        this.remoteBusinessClassNames.add(className);
    }

    public void addLocalBusinessClassName(String className) {
        this.localBusinessClassNames.add(className);
    }

    @Override
    public Set<String> getRemoteBusinessClassNames() {
        return new HashSet<String>(this.remoteBusinessClassNames);
    }

    @Override
    public Set<String> getLocalBusinessClassNames() {
        return new HashSet<String>(this.localBusinessClassNames);
    }

    @Override
    public void setWebServiceEndpointInterfaceName(String name) {
        this.webServiceEndpointInterfaceName = name;
    }

    @Override
    public String getWebServiceEndpointInterfaceName() {
        return this.webServiceEndpointInterfaceName;
    }

    @Override
    public String getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = "";
        }
        return this.jndiName != null && this.jndiName.length() > 0 ? this.jndiName : this.getMappedName();
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
        if (this.getName().equals("")) {
            super.setName(jndiName);
        }
    }

    public String getMappedName() {
        return this.mappedName != null ? this.mappedName : "";
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public void setLocalBean(boolean localBean) {
        this.localBean = localBean;
    }

    @Override
    public boolean isLocalInterfacesSupported() {
        return this.getLocalHomeClassName() != null;
    }

    @Override
    public boolean isLocalBusinessInterfacesSupported() {
        return this.localBusinessClassNames.size() > 0;
    }

    @Override
    public boolean isRemoteInterfacesSupported() {
        return this.getHomeClassName() != null;
    }

    @Override
    public boolean isRemoteBusinessInterfacesSupported() {
        return this.remoteBusinessClassNames.size() > 0;
    }

    @Override
    public boolean hasWebServiceEndpointInterface() {
        return this.getWebServiceEndpointInterfaceName() != null;
    }

    @Override
    public boolean isLocalBean() {
        return this.localBean;
    }

    public void setEjbClassName(String ejbClassName) {
        this.ejbClassName = ejbClassName;
    }

    @Override
    public String getEjbClassName() {
        return this.ejbClassName;
    }

    @Override
    public String getEjbImplClassName() {
        return this.getEjbClassName();
    }

    public void setRemoteHomeImplClassName(String name) {
        this.remoteHomeImplClassName = name;
    }

    public String getRemoteHomeImplClassName() {
        return this.remoteHomeImplClassName;
    }

    public void setLocalHomeImplClassName(String name) {
        this.localHomeImplClassName = name;
    }

    public String getLocalHomeImplClassName() {
        return this.localHomeImplClassName;
    }

    public void setEJBLocalObjectImplClassName(String name) {
        this.ejbLocalObjectImplClassName = name;
    }

    public String getEJBLocalObjectImplClassName() {
        return this.ejbLocalObjectImplClassName;
    }

    public void setEJBObjectImplClassName(String name) {
        this.ejbObjectImplClassName = name;
    }

    public String getEJBObjectImplClassName() {
        return this.ejbObjectImplClassName;
    }

    @Override
    public String getTransactionType() {
        return this.transactionType;
    }

    public abstract void setTransactionType(String var1);

    public Vector getPossibleTransactionAttributes() {
        Vector<ContainerTransaction> txAttributes = new Vector<ContainerTransaction>();
        txAttributes.add(new ContainerTransaction("Mandatory", ""));
        txAttributes.add(new ContainerTransaction("Never", ""));
        txAttributes.add(new ContainerTransaction("NotSupported", ""));
        txAttributes.add(new ContainerTransaction("Required", ""));
        txAttributes.add(new ContainerTransaction("RequiresNew", ""));
        txAttributes.add(new ContainerTransaction("Supports", ""));
        return txAttributes;
    }

    public boolean isTimedObject() {
        return this.timedObjectMethod != null || this.timerSchedules.size() > 0;
    }

    public MethodDescriptor getEjbTimeoutMethod() {
        return this.timedObjectMethod;
    }

    public void setEjbTimeoutMethod(MethodDescriptor method) {
        this.timedObjectMethod = method;
    }

    public void addScheduledTimerDescriptor(ScheduledTimerDescriptor scheduleDescriptor) {
        this.timerSchedules.add(scheduleDescriptor);
    }

    public void addScheduledTimerDescriptorFromDD(ScheduledTimerDescriptor scheduleDescriptor) {
        this.timerMethodDescriptors.add(scheduleDescriptor.getTimeoutMethod());
        this.timerSchedules.add(scheduleDescriptor);
    }

    public boolean hasScheduledTimerMethodFromDD(Method timerMethod) {
        boolean match = false;
        for (MethodDescriptor next : this.timerMethodDescriptors) {
            if (!next.getName().equals(timerMethod.getName()) || next.getParameterClassNames() != null && next.getParameterClassNames().length != timerMethod.getParameterTypes().length) continue;
            match = true;
            break;
        }
        return match;
    }

    public List<ScheduledTimerDescriptor> getScheduledTimerDescriptors() {
        return this.timerSchedules;
    }

    public Set<LifecycleCallbackDescriptor> getAroundInvokeDescriptors() {
        return this.aroundInvokeDescs;
    }

    public void addAroundInvokeDescriptor(LifecycleCallbackDescriptor aroundInvokeDesc) {
        String className = aroundInvokeDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getAroundInvokeDescriptors().add(aroundInvokeDesc);
        }
    }

    public LifecycleCallbackDescriptor getAroundInvokeDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getAroundInvokeDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasAroundInvokeMethod() {
        return this.getAroundInvokeDescriptors().size() > 0;
    }

    public Set<LifecycleCallbackDescriptor> getAroundTimeoutDescriptors() {
        return this.aroundTimeoutDescs;
    }

    public void addAroundTimeoutDescriptor(LifecycleCallbackDescriptor aroundTimeoutDesc) {
        String className = aroundTimeoutDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getAroundTimeoutDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getAroundTimeoutDescriptors().add(aroundTimeoutDesc);
        }
    }

    public LifecycleCallbackDescriptor getAroundTimeoutDescriptorByClass(String className) {
        for (LifecycleCallbackDescriptor next : this.getAroundTimeoutDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            return next;
        }
        return null;
    }

    public boolean hasAroundTimeoutMethod() {
        return this.getAroundTimeoutDescriptors().size() > 0;
    }

    @Override
    public void addFrameworkInterceptor(InterceptorDescriptor interceptor) {
        boolean found = false;
        for (InterceptorDescriptor next : this.frameworkInterceptors) {
            if (!next.getInterceptorClassName().equals(interceptor.getInterceptorClassName())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.frameworkInterceptors.add(interceptor);
        }
    }

    public List<InterceptorDescriptor> getFrameworkInterceptors() {
        return this.frameworkInterceptors;
    }

    public void applyDefaultClassToLifecycleMethods() {
        Set<LifecycleCallbackDescriptor> lifecycleMethods = this.getLifecycleCallbackDescriptors();
        lifecycleMethods.addAll(this.getAroundInvokeDescriptors());
        lifecycleMethods.addAll(this.getAroundTimeoutDescriptors());
        for (LifecycleCallbackDescriptor next : lifecycleMethods) {
            if (next.getLifecycleCallbackClass() != null) continue;
            next.setLifecycleCallbackClass(this.getEjbClassName());
        }
    }

    public Set<LifecycleCallbackDescriptor> getLifecycleCallbackDescriptors() {
        HashSet<LifecycleCallbackDescriptor> lifecycleMethods = new HashSet<LifecycleCallbackDescriptor>();
        lifecycleMethods.addAll(this.getPostConstructDescriptors());
        lifecycleMethods.addAll(this.getPreDestroyDescriptors());
        if (this.getType().equals("Session")) {
            EjbSessionDescriptor sfulDesc = (EjbSessionDescriptor)this;
            lifecycleMethods.addAll(sfulDesc.getPrePassivateDescriptors());
            lifecycleMethods.addAll(sfulDesc.getPostActivateDescriptors());
        }
        return lifecycleMethods;
    }

    public void applyInterceptors(InterceptorBindingTranslator bindingTranslator) {
        InterceptorBindingTranslator.TranslationResults results = bindingTranslator.apply(this.getName());
        this.allInterceptorClasses.clear();
        this.allInterceptorClasses.addAll(results.allInterceptorClasses);
        this.interceptorChain.clear();
        this.interceptorChain.addAll(results.classInterceptorChain);
        this.methodInterceptorsMap.clear();
        this.methodInterceptorsMap.putAll(results.methodInterceptorsMap);
        for (EjbInterceptor interceptor : this.allInterceptorClasses) {
            for (Object ejbRefObj : interceptor.getEjbReferenceDescriptors()) {
                this.addEjbReferenceDescriptor((EjbReference)ejbRefObj);
            }
            for (Object msgDestRefObj : interceptor.getMessageDestinationReferenceDescriptors()) {
                this.addMessageDestinationReferenceDescriptor((MessageDestinationReferenceDescriptor)msgDestRefObj);
            }
            for (Object envPropObj : interceptor.getEnvironmentProperties()) {
                this.addOrMergeEnvironmentProperty((EnvironmentProperty)envPropObj);
            }
            for (Object servRefObj : interceptor.getServiceReferenceDescriptors()) {
                this.addServiceReferenceDescriptor((ServiceReferenceDescriptor)servRefObj);
            }
            for (Object resRefObj : interceptor.getResourceReferenceDescriptors()) {
                this.addResourceReferenceDescriptor((ResourceReferenceDescriptor)resRefObj);
            }
            for (Object resourceEnvRefObj : interceptor.getResourceEnvReferenceDescriptors()) {
                this.addResourceEnvReferenceDescriptor((ResourceEnvReferenceDescriptor)resourceEnvRefObj);
            }
            for (EntityManagerFactoryReferenceDescriptor entMgrFacRef : interceptor.getEntityManagerFactoryReferenceDescriptors()) {
                this.addEntityManagerFactoryReferenceDescriptor(entMgrFacRef);
            }
            for (EntityManagerReferenceDescriptor entMgrRef : interceptor.getEntityManagerReferenceDescriptors()) {
                this.addEntityManagerReferenceDescriptor(entMgrRef);
            }
        }
    }

    @Override
    public boolean hasInterceptorClass(String interceptorClassName) {
        for (String next : this.getInterceptorClassNames()) {
            if (!next.equals(interceptorClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInterceptorClass(EjbInterceptor interceptor) {
        this.allInterceptorClasses.add(interceptor);
    }

    @Override
    public void appendToInterceptorChain(List<EjbInterceptor> chain) {
        this.interceptorChain.addAll(chain);
    }

    public Set<EjbInterceptor> getInterceptorClasses() {
        HashSet<EjbInterceptor> classes = new HashSet<EjbInterceptor>(this.allInterceptorClasses);
        return classes;
    }

    public Set<String> getInterceptorClassNames() {
        HashSet<String> classNames = new HashSet<String>();
        for (EjbInterceptor ei : this.getInterceptorClasses()) {
            classNames.add(ei.getInterceptorClassName());
        }
        return classNames;
    }

    public Map<MethodDescriptor, List<EjbInterceptor>> getMethodInterceptorsMap() {
        return new HashMap<MethodDescriptor, List<EjbInterceptor>>(this.methodInterceptorsMap);
    }

    public List<EjbInterceptor> getInterceptorChain() {
        return new LinkedList<EjbInterceptor>(this.interceptorChain);
    }

    public List<EjbInterceptor> getAroundInvokeInterceptors(MethodDescriptor businessMethod) {
        LinkedList<EjbInterceptor> aroundInvokeInterceptors = new LinkedList<EjbInterceptor>();
        List<EjbInterceptor> classOrMethodInterceptors = this.getClassOrMethodInterceptors(businessMethod);
        for (EjbInterceptor next : classOrMethodInterceptors) {
            if (next.getAroundInvokeDescriptors().size() <= 0) continue;
            aroundInvokeInterceptors.add(next);
        }
        if (this.hasAroundInvokeMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundInvokeDescriptors(this.getAroundInvokeDescriptors());
            interceptorInfo.setInterceptorClassName(this.getEjbImplClassName());
            aroundInvokeInterceptors.add(interceptorInfo);
        }
        return aroundInvokeInterceptors;
    }

    public List<EjbInterceptor> getAroundTimeoutInterceptors(MethodDescriptor businessMethod) {
        LinkedList<EjbInterceptor> aroundTimeoutInterceptors = new LinkedList<EjbInterceptor>();
        List<EjbInterceptor> classOrMethodInterceptors = this.getClassOrMethodInterceptors(businessMethod);
        for (EjbInterceptor next : classOrMethodInterceptors) {
            if (next.getAroundTimeoutDescriptors().size() <= 0) continue;
            aroundTimeoutInterceptors.add(next);
        }
        if (this.hasAroundTimeoutMethod()) {
            EjbInterceptor interceptorInfo = new EjbInterceptor();
            interceptorInfo.setFromBeanClass(true);
            interceptorInfo.addAroundTimeoutDescriptors(this.getAroundTimeoutDescriptors());
            interceptorInfo.setInterceptorClassName(this.getEjbImplClassName());
            aroundTimeoutInterceptors.add(interceptorInfo);
        }
        return aroundTimeoutInterceptors;
    }

    @Override
    public void addMethodLevelChain(List<EjbInterceptor> chain, Method m, boolean aroundInvoke) {
        if (chain.size() == 0) {
            return;
        }
        MethodDescriptor methodDesc = new MethodDescriptor(m);
        List<EjbInterceptor> existingChain = null;
        for (MethodDescriptor next : this.methodInterceptorsMap.keySet()) {
            if (!next.implies(methodDesc)) continue;
            existingChain = this.methodInterceptorsMap.get(methodDesc);
            break;
        }
        if (existingChain != null) {
            existingChain.addAll(chain);
        } else {
            LinkedList<EjbInterceptor> newChain = new LinkedList<EjbInterceptor>();
            for (EjbInterceptor interceptor : this.interceptorChain) {
                boolean include = aroundInvoke ? interceptor.hasAroundInvokeDescriptor() : interceptor.hasAroundTimeoutDescriptor();
                if (!include) continue;
                newChain.add(interceptor);
            }
            newChain.addAll(chain);
            this.methodInterceptorsMap.put(methodDesc, newChain);
        }
    }

    private List<EjbInterceptor> getClassOrMethodInterceptors(MethodDescriptor businessMethod) {
        List<EjbInterceptor> classOrMethodInterceptors = null;
        for (MethodDescriptor methodDesc : this.methodInterceptorsMap.keySet()) {
            if (!methodDesc.implies(businessMethod)) continue;
            classOrMethodInterceptors = this.methodInterceptorsMap.get(methodDesc);
        }
        if (classOrMethodInterceptors == null) {
            classOrMethodInterceptors = this.interceptorChain;
        }
        return classOrMethodInterceptors;
    }

    public List<EjbInterceptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2) {
        Set<LifecycleCallbackDescriptor> callbackDescriptors = null;
        switch (type2) {
            case AROUND_CONSTRUCT: {
                break;
            }
            case POST_CONSTRUCT: {
                callbackDescriptors = this.getPostConstructDescriptors();
                break;
            }
            case PRE_DESTROY: {
                callbackDescriptors = this.getPreDestroyDescriptors();
                break;
            }
            case PRE_PASSIVATE: {
                callbackDescriptors = ((EjbSessionDescriptor)this).getPrePassivateDescriptors();
                break;
            }
            case POST_ACTIVATE: {
                callbackDescriptors = ((EjbSessionDescriptor)this).getPostActivateDescriptors();
                break;
            }
            default: {
                throw new IllegalStateException(localStrings.getLocalString("enterprise.deployment.invalidcallbacktype", "Invalid callback type: [{0}]", new Object[]{type2}));
            }
        }
        return this.getCallbackInterceptors(type2, callbackDescriptors);
    }

    private LinkedList<EjbInterceptor> getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType type2, Set<LifecycleCallbackDescriptor> callbackDescriptors) {
        LinkedList<EjbInterceptor> callbackInterceptors = new LinkedList<EjbInterceptor>();
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        List<EjbInterceptor> classOrMethodInterceptors = type2.equals((Object)LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) ? this.getConstructorInterceptors(classLoader) : this.interceptorChain;
        for (EjbInterceptor next : classOrMethodInterceptors) {
            if (next.getCallbackDescriptors(type2).size() <= 0) continue;
            callbackInterceptors.add(next);
        }
        if (callbackDescriptors != null && callbackDescriptors.size() > 0) {
            EjbInterceptor beanClassCallbackInfo = new EjbInterceptor();
            beanClassCallbackInfo.setFromBeanClass(true);
            beanClassCallbackInfo.addCallbackDescriptors(type2, callbackDescriptors);
            beanClassCallbackInfo.setInterceptorClassName(this.getEjbImplClassName());
            callbackInterceptors.add(beanClassCallbackInfo);
        }
        return callbackInterceptors;
    }

    private List<EjbInterceptor> getConstructorInterceptors(ClassLoader classLoader) {
        JCDIService jcdiService;
        List<EjbInterceptor> callbackInterceptors = null;
        String shortClassName = this.ejbClassName;
        int i = this.ejbClassName.lastIndexOf(46);
        if (i > -1) {
            shortClassName = this.ejbClassName.substring(i + 1);
        }
        JCDIService jCDIService = jcdiService = this.sl == null ? null : this.sl.getService(JCDIService.class, new Annotation[0]);
        if (jcdiService != null && jcdiService.isJCDIEnabled(this.getEjbBundleDescriptor())) {
            try {
                Class<?> beanClass = classLoader.loadClass(this.getEjbClassName());
                Constructor<?>[] ctors = beanClass.getDeclaredConstructors();
                String[] parameterClassNames = null;
                MethodDescriptor dummy = new MethodDescriptor();
                for (Constructor<?> ctor : ctors) {
                    if (ctor.getAnnotation(Inject.class) == null) continue;
                    Class[] ctorParamTypes = ctor.getParameterTypes();
                    parameterClassNames = dummy.getParameterClassNamesFor(null, ctorParamTypes);
                    callbackInterceptors = this.getClassOrMethodInterceptors(new MethodDescriptor(shortClassName, null, parameterClassNames, "Bean"));
                    break;
                }
            }
            catch (Throwable t) {
                _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{this.getEjbClassName()});
                throw new RuntimeException(t);
            }
        }
        if (callbackInterceptors == null) {
            callbackInterceptors = this.getClassOrMethodInterceptors(new MethodDescriptor(shortClassName, null, new String[0], "Bean"));
        }
        return callbackInterceptors;
    }

    public boolean isDistributedTransactionScope() {
        return this.isDistributedTxScope;
    }

    public void setDistributedTransactionScope(boolean scope) {
        this.isDistributedTxScope = scope;
    }

    @Override
    public void setUsesCallerIdentity(boolean flag) {
        this.usesCallerIdentity = flag;
    }

    @Override
    public Boolean getUsesCallerIdentity() {
        return this.usesCallerIdentity;
    }

    public String getSecurityIdentityDescription() {
        if (this.securityIdentityDescription == null) {
            this.securityIdentityDescription = "";
        }
        return this.securityIdentityDescription;
    }

    public void setSecurityIdentityDescription(String s) {
        this.securityIdentityDescription = s;
    }

    @Override
    public void setRunAsIdentity(RunAsIdentityDescriptor desc) {
        if (this.usesCallerIdentity == null || this.usesCallerIdentity.booleanValue()) {
            throw new IllegalStateException(localStrings.getLocalString("exceptioncannotsetrunas", "Cannot set RunAs identity when using caller identity"));
        }
        this.runAsIdentity = desc;
    }

    @Override
    public RunAsIdentityDescriptor getRunAsIdentity() {
        if (this.usesCallerIdentity == null || this.usesCallerIdentity.booleanValue()) {
            throw new IllegalStateException(localStrings.getLocalString("exceptioncannotgetrunas", "Cannot get RunAs identity when using caller identity"));
        }
        return this.runAsIdentity;
    }

    public void setUsesDefaultTransaction() {
        this.usesDefaultTransaction = true;
    }

    public boolean isUsesDefaultTransaction() {
        return this.usesDefaultTransaction;
    }

    public Hashtable getMethodContainerTransactions() {
        if (this.methodContainerTransactions == null) {
            this.methodContainerTransactions = new Hashtable();
        }
        return this.methodContainerTransactions;
    }

    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        ContainerTransaction oldValue = this.getContainerTransactionFor(methodDescriptor);
        if (oldValue == null || !oldValue.equals(containerTransaction)) {
            String transactionType = this.getTransactionType();
            if (transactionType == null) {
                this.setTransactionType("Container");
            } else if ("Bean".equals(transactionType)) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontxattrbtnotspecifiedinbeanwithtxtype", "Method level transaction attributes may not be specified on a bean with transaction type {0}", "Bean"));
            }
            this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
        }
    }

    public void setMethodContainerTransactions(Hashtable methodContainerTransactions) {
        if (methodContainerTransactions != null) {
            Enumeration e = methodContainerTransactions.keys();
            while (e.hasMoreElements()) {
                MethodDescriptor methodDescriptor = (MethodDescriptor)e.nextElement();
                ContainerTransaction containerTransaction = (ContainerTransaction)methodContainerTransactions.get(methodDescriptor);
                this.setContainerTransactionFor(methodDescriptor, containerTransaction);
            }
        }
    }

    Set getAllMethodDescriptors() {
        HashSet<Object> allMethodDescriptors = new HashSet<Object>();
        Enumeration e = this.getMethodContainerTransactions().keys();
        while (e.hasMoreElements()) {
            allMethodDescriptors.add(e.nextElement());
        }
        for (MethodPermission nextPermission : this.getPermissionedMethodsByPermission().keySet()) {
            Set permissionedMethods = (Set)this.getPermissionedMethodsByPermission().get(nextPermission);
            Iterator itr = permissionedMethods.iterator();
            while (itr.hasNext()) {
                allMethodDescriptors.add(itr.next());
            }
        }
        return allMethodDescriptors;
    }

    public ContainerTransaction getContainerTransactionFor(MethodDescriptor methodDescriptor) {
        ContainerTransaction containerTransaction = null;
        if (this.needToConvertMethodContainerTransactions()) {
            this.convertMethodContainerTransactions();
        }
        if ((containerTransaction = (ContainerTransaction)this.getMethodContainerTransactions().get(methodDescriptor)) == null) {
            if (this.isBoundsChecking() && this.usesDefaultTransaction) {
                containerTransaction = new ContainerTransaction("Required", "");
                this.getMethodContainerTransactions().put(methodDescriptor, containerTransaction);
            } else {
                containerTransaction = null;
            }
        }
        return containerTransaction;
    }

    private boolean needToConvertMethodContainerTransactions() {
        if (this.getEjbBundleDescriptor() != null) {
            Enumeration e = this.getMethodContainerTransactions().keys();
            while (e.hasMoreElements()) {
                MethodDescriptor md = (MethodDescriptor)e.nextElement();
                if (md.isExact()) continue;
                return true;
            }
        }
        return false;
    }

    private void convertMethodContainerTransactions() {
        Hashtable convertedTransactions = new Hashtable();
        this.convertMethodContainerTransactionsOfStyle(1, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(2, convertedTransactions);
        this.convertMethodContainerTransactionsOfStyle(3, convertedTransactions);
        this.methodContainerTransactions = convertedTransactions;
    }

    private void convertMethodContainerTransactionsOfStyle(int requestedStyleForConversion, Hashtable convertedMethods) {
        Collection transactionMethods = this.getTransactionMethodDescriptors();
        Hashtable transactions = this.getMethodContainerTransactions();
        Enumeration e = transactions.keys();
        while (e.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e.nextElement();
            if (md.getStyle() != requestedStyleForConversion) continue;
            ContainerTransaction ct = (ContainerTransaction)this.getMethodContainerTransactions().get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedMethods.put(next, new ContainerTransaction(ct));
            }
        }
    }

    public ContainerTransaction getContainerTransaction() {
        Vector transactionalMethods = new Vector(this.getTransactionMethodDescriptors());
        MethodDescriptor md = (MethodDescriptor)transactionalMethods.firstElement();
        if (md != null) {
            ContainerTransaction first = this.getContainerTransactionFor(md);
            Enumeration e = transactionalMethods.elements();
            while (e.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)e.nextElement();
                ContainerTransaction nextCt = this.getContainerTransactionFor(next);
                if (nextCt == null || nextCt.equals(first)) continue;
                return null;
            }
            return first;
        }
        return null;
    }

    @Override
    public Set<EjbIORConfigurationDescriptor> getIORConfigurationDescriptors() {
        return this.iorConfigDescriptors;
    }

    public void addIORConfigurationDescriptor(EjbIORConfigurationDescriptor val) {
        this.iorConfigDescriptors.add(val);
    }

    @Override
    public Set<Role> getPermissionedRoles() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        HashSet<Role> allPermissionedRoles = new HashSet<Role>();
        for (MethodPermission pm : this.getPermissionedMethodsByPermission().keySet()) {
            if (!pm.isRoleBased()) continue;
            allPermissionedRoles.add(pm.getRole());
        }
        return allPermissionedRoles;
    }

    public Map getPermissionedMethodsByPermission() {
        if (this.permissionedMethodsByPermission == null) {
            this.permissionedMethodsByPermission = new Hashtable();
        }
        return this.permissionedMethodsByPermission;
    }

    @Override
    public void addPermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole()) && !"**".equals(mp.getRole().getName())) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbundle", "Cannot add roles when the bundle does not have them"));
        }
        if (md.isExact()) {
            this.updateMethodPermissionForMethod(mp, md);
        } else {
            this.addMethodPermissionForStyledMethodDescriptor(mp, md);
        }
        this.saveMethodPermissionFromDD(mp, md);
    }

    private void saveMethodPermissionFromDD(MethodPermission mp, MethodDescriptor md) {
        ArrayList<MethodDescriptor> descriptors;
        if (this.methodPermissionsFromDD == null) {
            this.methodPermissionsFromDD = new HashMap();
        }
        if ((descriptors = (ArrayList<MethodDescriptor>)this.methodPermissionsFromDD.get(mp)) == null) {
            descriptors = new ArrayList<MethodDescriptor>();
        }
        descriptors.add(md);
        this.methodPermissionsFromDD.put(mp, descriptors);
    }

    @Override
    public HashMap getMethodPermissionsFromDD() {
        return this.methodPermissionsFromDD;
    }

    private void addMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getPermissionedMethodsByPermission().containsKey(mp)) {
            Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByPermission().get(mp);
            alreadyPermissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        } else {
            HashSet<MethodDescriptor> permissionedMethodsForThisRole = new HashSet<MethodDescriptor>();
            permissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, permissionedMethodsForThisRole);
        }
    }

    public void removePermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncanotaddrolesdescriptor", "Cannot add roles when the descriptor is not part of a bundle"));
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole())) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotaddrolesbndledoesnothave", "Cannot add roles when the bundle does not have them"));
        }
        if (this.getPermissionedMethodsByPermission().containsKey(mp)) {
            Set alreadyPermissionedMethodsForThisRole = (Set)this.getPermissionedMethodsByPermission().get(mp);
            alreadyPermissionedMethodsForThisRole.remove(md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        }
    }

    private void addMethodPermissionForStyledMethodDescriptor(MethodPermission mp, MethodDescriptor md) {
        HashSet<MethodPermission> permissions;
        if (this.styledMethodDescriptors == null) {
            this.styledMethodDescriptors = new HashMap();
        }
        if ((permissions = (HashSet<MethodPermission>)this.styledMethodDescriptors.get(md)) == null) {
            permissions = new HashSet<MethodPermission>();
        }
        permissions.add(mp);
        this.styledMethodDescriptors.put(md, permissions);
    }

    public Map getStyledPermissionedMethodsByPermission() {
        if (this.styledMethodDescriptors == null) {
            return null;
        }
        HashMap<MethodPermission, HashSet<MethodDescriptor>> styledMethodDescriptorsByPermission = new HashMap<MethodPermission, HashSet<MethodDescriptor>>();
        for (MethodDescriptor md : this.styledMethodDescriptors.keySet()) {
            Set methodPermissions = (Set)this.styledMethodDescriptors.get(md);
            for (MethodPermission mp : methodPermissions) {
                HashSet<MethodDescriptor> methodDescriptors = (HashSet<MethodDescriptor>)styledMethodDescriptorsByPermission.get(mp);
                if (methodDescriptors == null) {
                    methodDescriptors = new HashSet<MethodDescriptor>();
                }
                methodDescriptors.add(md);
                styledMethodDescriptorsByPermission.put(mp, methodDescriptors);
            }
        }
        return styledMethodDescriptorsByPermission;
    }

    public Set getUncheckedMethodDescriptors() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return (Set)this.getPermissionedMethodsByPermission().get(MethodPermission.getUncheckedMethodPermission());
    }

    public Set getExcludedMethodDescriptors() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return (Set)this.getPermissionedMethodsByPermission().get(MethodPermission.getExcludedMethodPermission());
    }

    private void convertMethodPermissions() {
        if (this.styledMethodDescriptors == null) {
            return;
        }
        Set allMethods = this.getMethodDescriptors();
        Set unpermissionedMethods = this.getMethodDescriptors();
        Set methodDescriptors = this.styledMethodDescriptors.keySet();
        for (MethodDescriptor styledMd : methodDescriptors) {
            Set newPermissions = (Set)this.styledMethodDescriptors.get(styledMd);
            Vector mds = styledMd.doStyleConversion(this, allMethods);
            for (MethodDescriptor md : mds) {
                unpermissionedMethods.remove(md);
                for (MethodPermission newMp : newPermissions) {
                    this.updateMethodPermissionForMethod(newMp, md);
                }
            }
        }
        MethodPermission mp = MethodPermission.getUncheckedMethodPermission();
        for (MethodDescriptor md : unpermissionedMethods) {
            if (!this.getMethodPermissions(md).isEmpty()) continue;
            this.addMethodPermissionForMethod(mp, md);
        }
        this.styledMethodDescriptors = null;
    }

    private void updateMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        Set oldPermissions = this.getMethodPermissions(md);
        if (oldPermissions.isEmpty()) {
            this.addMethodPermissionForMethod(mp, md);
            return;
        }
        if (mp.isExcluded()) {
            for (MethodPermission oldMp : oldPermissions) {
                this.removePermissionedMethod(oldMp, md);
            }
            this.addMethodPermissionForMethod(mp, md);
        } else if (mp.isUnchecked()) {
            for (MethodPermission oldMp : oldPermissions) {
                if (oldMp.isExcluded()) continue;
                this.removePermissionedMethod(oldMp, md);
                this.addMethodPermissionForMethod(mp, md);
            }
        } else {
            for (MethodPermission oldMp : oldPermissions) {
                if (oldMp.isExcluded() || oldMp.isUnchecked()) continue;
                this.addMethodPermissionForMethod(mp, md);
            }
        }
    }

    private boolean needToConvertMethodPermissions() {
        return this.styledMethodDescriptors != null;
    }

    @Override
    public Set getMethodPermissionsFor(MethodDescriptor methodDescriptor) {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return this.getMethodPermissions(methodDescriptor);
    }

    private Set getMethodPermissions(MethodDescriptor methodDescriptor) {
        HashSet<MethodPermission> methodPermissionsForMethod = new HashSet<MethodPermission>();
        for (MethodPermission nextPermission : this.getPermissionedMethodsByPermission().keySet()) {
            Set permissionedMethods = (Set)this.getPermissionedMethodsByPermission().get(nextPermission);
            for (MethodDescriptor md : permissionedMethods) {
                if (!md.equals(methodDescriptor)) continue;
                methodPermissionsForMethod.add(nextPermission);
            }
        }
        return methodPermissionsForMethod;
    }

    @Override
    public Set<EjbReference> getEjbReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getEjbReferenceDescriptors();
        }
        return this.ejbReferences;
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        try {
            EjbReference existing = this.getEjbReference(ejbReference.getName());
            for (InjectionTarget next : ejbReference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env != null) {
                this.env.addEjbReferenceDescriptor(ejbReference);
            } else {
                this.ejbReferences.add(ejbReference);
            }
            ejbReference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
        }
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
        if (this.env != null) {
            this.env.removeEjbReferenceDescriptor(ejbReference);
        } else {
            this.ejbReferences.remove(ejbReference);
        }
        ejbReference.setReferringBundleDescriptor(null);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return this.postConstructDescs;
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        String className = postConstructDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPostConstructDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPostConstructDescriptors().add(postConstructDesc);
        }
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return this.bundleDescriptor.getPostConstructDescriptorByClass(className, this);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return this.preDestroyDescs;
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        String className = preDestroyDesc.getLifecycleCallbackClass();
        boolean found = false;
        for (LifecycleCallbackDescriptor next : this.getPreDestroyDescriptors()) {
            if (!next.getLifecycleCallbackClass().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.getPreDestroyDescriptors().add(preDestroyDesc);
        }
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return this.bundleDescriptor.getPreDestroyDescriptorByClass(className, this);
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getServiceReferenceDescriptors();
        }
        return this.serviceReferences;
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        try {
            ServiceReferenceDescriptor existing = this.getServiceReferenceByName(serviceRef.getName());
            for (InjectionTarget next : serviceRef.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env != null) {
                this.env.addServiceReferenceDescriptor(serviceRef);
            } else {
                this.serviceReferences.add(serviceRef);
            }
            serviceRef.setBundleDescriptor(this.getEjbBundleDescriptor());
        }
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        if (this.env != null) {
            this.env.removeServiceReferenceDescriptor(serviceRef);
        } else {
            this.serviceReferences.remove(serviceRef);
        }
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getServiceReferenceByName(name);
        }
        for (ServiceReferenceDescriptor srd : this.getServiceReferenceDescriptors()) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionejbhasnoservicerefbyname", "This ejb [{0}] has no service reference by the name of [{1}]", this.getName(), name));
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getMessageDestinationReferenceDescriptors();
        }
        return this.messageDestReferences;
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        block5: {
            try {
                MessageDestinationReferenceDescriptor existing = this.getMessageDestinationReferenceByName(messageDestRef.getName());
                for (InjectionTarget next : messageDestRef.getInjectionTargets()) {
                    existing.addInjectionTarget(next);
                }
            }
            catch (IllegalArgumentException e) {
                if (this.env != null) {
                    this.env.addMessageDestinationReferenceDescriptor(messageDestRef);
                } else {
                    this.messageDestReferences.add(messageDestRef);
                }
                if (this.getEjbBundleDescriptor() == null) break block5;
                messageDestRef.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
            }
        }
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        if (this.env != null) {
            this.env.removeMessageDestinationReferenceDescriptor(msgDestRef);
        } else {
            this.messageDestReferences.remove(msgDestRef);
        }
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getMessageDestinationReferenceByName(name);
        }
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("exceptionejbhasnomsgdestrefbyname", "This ejb [{0}] has no message destination reference by the name of [{1}]", this.getName(), name));
    }

    @Override
    public Set<ResourceDescriptor> getResourceDescriptors(JavaEEResourceType type2) {
        if (this.env != null) {
            return this.env.getResourceDescriptors(type2);
        }
        return super.getResourceDescriptors(type2);
    }

    @Override
    public Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getResourceEnvReferenceDescriptors();
        }
        return this.resourceEnvReferences;
    }

    @Override
    public void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        try {
            ResourceEnvReferenceDescriptor existing = this.getResourceEnvReferenceByName(resourceEnvReference.getName());
            for (InjectionTarget next : resourceEnvReference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env != null) {
                this.env.addResourceEnvReferenceDescriptor(resourceEnvReference);
            }
            this.resourceEnvReferences.add(resourceEnvReference);
        }
    }

    @Override
    public void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        if (this.env != null) {
            this.env.removeResourceEnvReferenceDescriptor(resourceEnvReference);
        } else {
            this.resourceEnvReferences.remove(resourceEnvReference);
        }
    }

    @Override
    public ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor jdr : this.getResourceEnvReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoresourceenvrefbyname", "This bean {0} has no resource environment reference by the name of {1}", this.getName(), name));
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getResourceReferenceDescriptors();
        }
        return this.resourceReferences;
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        try {
            ResourceReferenceDescriptor existing = this.getResourceReferenceByName(resourceReference.getName());
            for (InjectionTarget next : resourceReference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env != null) {
                this.env.addResourceReferenceDescriptor(resourceReference);
            }
            this.resourceReferences.add(resourceReference);
        }
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        if (this.env != null) {
            this.env.removeResourceReferenceDescriptor(resourceReference);
        } else {
            this.resourceReferences.remove(resourceReference);
        }
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        if (this.env != null) {
            return this.env.getEnvironmentPropertyByName(name);
        }
        for (EnvironmentProperty ev : this.getEnvironmentProperties()) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoenvpropertybyname", "This bean {0} has no environment property by the name of {1}", this.getName(), name));
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        if (this.env != null) {
            return this.env.getEnvironmentProperties();
        }
        return this.environmentProperties;
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.env != null) {
            this.env.addEnvironmentProperty(environmentProperty);
            return;
        }
        if (this.environmentProperties.contains(environmentProperty)) {
            this.removeEnvironmentProperty(environmentProperty);
            this.addEnvironmentProperty(environmentProperty);
        } else {
            this.environmentProperties.add(environmentProperty);
        }
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.env != null) {
            this.env.removeEnvironmentProperty(environmentProperty);
        } else {
            this.getEnvironmentProperties().remove(environmentProperty);
        }
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getEntityManagerFactoryReferenceDescriptors();
        }
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getEntityManagerFactoryReferenceByName(name);
        }
        for (EntityManagerFactoryReferenceDescriptor next : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoentitymgrfactoryrefbyname", "This ejb {0} has no entity manager factory reference by the name of {1}", this.getName(), name));
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        try {
            EntityManagerFactoryReferenceDescriptor existing = this.getEntityManagerFactoryReferenceByName(reference.getName());
            for (InjectionTarget next : reference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.getEjbBundleDescriptor() != null) {
                reference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
            }
            if (this.env != null) {
                this.env.addEntityManagerFactoryReferenceDescriptor(reference);
            }
            this.entityManagerFactoryReferences.add(reference);
        }
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        if (this.env != null) {
            return this.env.getEntityManagerReferenceDescriptors();
        }
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getEntityManagerReferenceByName(name);
        }
        for (EntityManagerReferenceDescriptor next : this.getEntityManagerReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoentitymgrrefbyname", "This ejb {0} has no entity manager reference by the name of {1}", this.getName(), name));
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        try {
            EntityManagerReferenceDescriptor existing = this.getEntityManagerReferenceByName(reference.getName());
            for (InjectionTarget next : reference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.getEjbBundleDescriptor() != null) {
                reference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
            }
            if (this.env != null) {
                this.env.addEntityManagerReferenceDescriptor(reference);
            }
            this.getEntityManagerReferenceDescriptors().add(reference);
        }
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        if (this.env != null) {
            return this.env.getInjectableResourcesByClass(className);
        }
        return this.bundleDescriptor.getInjectableResourcesByClass(className, this);
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class clazz) {
        if (this.env != null) {
            return this.env.getInjectionInfoByClass(clazz);
        }
        return this.bundleDescriptor.getInjectionInfoByClass(clazz, this);
    }

    public boolean hasPostConstructMethod() {
        return this.getPostConstructDescriptors().size() > 0;
    }

    public boolean hasPreDestroyMethod() {
        return this.getPreDestroyDescriptors().size() > 0;
    }

    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors(boolean resolved) {
        HashSet<ResourceReferenceDescriptor> toReturn = new HashSet<ResourceReferenceDescriptor>();
        for (ResourceReferenceDescriptor next : this.getResourceReferenceDescriptors()) {
            if (next.isResolved() != resolved) continue;
            toReturn.add(next);
        }
        return toReturn;
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor next : this.getResourceReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoresourcerefbyname", "This bean {0} has no resource reference by the name of {1}", this.getName(), name));
    }

    public boolean hasResolvedResourceReferences() {
        if (!this.getResourceReferenceDescriptors().isEmpty()) {
            return false;
        }
        for (ResourceReferenceDescriptor resourceReference : this.getResourceReferenceDescriptors()) {
            if (!resourceReference.isResolved()) continue;
            return true;
        }
        return false;
    }

    private void addOrMergeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        try {
            EnvironmentProperty existing = this.getEnvironmentPropertyByName(environmentProperty.getName());
            for (InjectionTarget next : environmentProperty.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            this.addEnvironmentProperty(environmentProperty);
        }
    }

    @Override
    public EjbReference getEjbReference(String name) {
        for (EjbReference er : this.getEjbReferenceDescriptors()) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanhasnoejbrefbyname", "This bean {0} has no ejb reference by the name of {1}", this.getName(), name));
    }

    void removeRole(Role role) {
        this.getPermissionedMethodsByPermission().remove(new MethodPermission(role));
        HashSet<RoleReference> roleReferences = new HashSet<RoleReference>(this.getRoleReferences());
        for (RoleReference roleReference : roleReferences) {
            if (!roleReference.getRole().equals(role)) continue;
            roleReference.setValue("");
        }
    }

    public Set<RoleReference> getRoleReferences() {
        if (this.roleReferences == null) {
            this.roleReferences = new HashSet();
        }
        return this.roleReferences;
    }

    @Override
    public void addRoleReference(RoleReference roleReference) {
        this.getRoleReferences().add(roleReference);
    }

    public void removeRoleReference(RoleReference roleReference) {
        this.getRoleReferences().remove(roleReference);
    }

    @Override
    public RoleReference getRoleReferenceByName(String roleReferenceName) {
        for (RoleReference nextRR : this.getRoleReferences()) {
            if (!nextRR.getName().equals(roleReferenceName)) continue;
            return nextRR;
        }
        return null;
    }

    @Override
    public EjbBundleDescriptorImpl getEjbBundleDescriptor() {
        return this.bundleDescriptor;
    }

    public void setEjbBundleDescriptor(EjbBundleDescriptorImpl bundleDescriptor) {
        this.bundleDescriptor = bundleDescriptor;
    }

    @Override
    public void notifyNewModule(WebBundleDescriptor wbd) {
        wbd.addJndiNameEnvironment(this);
        this.environmentProperties.clear();
        this.ejbReferences.clear();
        this.resourceEnvReferences.clear();
        this.messageDestReferences.clear();
        this.resourceReferences.clear();
        this.serviceReferences.clear();
        this.entityManagerFactoryReferences.clear();
        this.entityManagerReferences.clear();
        this.env = wbd;
    }

    @Override
    public Application getApplication() {
        if (this.getEjbBundleDescriptor() != null) {
            return this.getEjbBundleDescriptor().getApplication();
        }
        return null;
    }

    @Override
    public Set getMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        Set methods = this.getBusinessMethodDescriptors();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getHomeClassName()), "Home");
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalHomeClassName()), "LocalHome");
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getMethods())"});
            throw new RuntimeException(t);
        }
        return methods;
    }

    public Set getTxBusinessMethodDescriptors() {
        Set txBusMethods = this.getBusinessMethodDescriptors();
        if (this.isTimedObject() && this.timedObjectMethod != null) {
            txBusMethods.add(this.timedObjectMethod);
        }
        return txBusMethods;
    }

    @Override
    public Set getSecurityBusinessMethodDescriptors() {
        return this.getBusinessMethodDescriptors();
    }

    public Set getClientBusinessMethodDescriptors() {
        return this.getLocalRemoteBusinessMethodDescriptors();
    }

    private Set getLocalRemoteBusinessMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        HashSet methods = new HashSet();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getRemoteClassName()), "Remote");
            }
            if (this.isRemoteBusinessInterfacesSupported()) {
                for (String intf : this.getRemoteBusinessClassNames()) {
                    this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf), "Remote");
                }
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalClassName()), LOCAL_TRANSACTION_SCOPE);
            }
            if (this.isLocalBusinessInterfacesSupported()) {
                for (String intf : this.getLocalBusinessClassNames()) {
                    this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf), LOCAL_TRANSACTION_SCOPE);
                }
            }
            if (this.isLocalBean()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getEjbClassName()), LOCAL_TRANSACTION_SCOPE);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getBusinessMethodDescriptors())"});
            throw new RuntimeException(t);
        }
        return methods;
    }

    private Set getBusinessMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        Set methods = this.getLocalRemoteBusinessMethodDescriptors();
        try {
            if (this.hasWebServiceEndpointInterface()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getWebServiceEndpointInterfaceName()), "ServiceEndpoint");
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getBusinessMethodDescriptors())"});
            throw new RuntimeException(t);
        }
        return methods;
    }

    protected void addAllInterfaceMethodsIn(Collection methodDescriptors, Class c, String methodIntf) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getDeclaringClass() == Object.class) continue;
            methodDescriptors.add(new MethodDescriptor(methods[i], methodIntf));
        }
    }

    public MethodDescriptor getBusinessMethodDescriptorFor(Method m, String methodIntf) {
        Set businessMethodDescriptors = this.getBusinessMethodDescriptors();
        MethodDescriptor methodDesc = new MethodDescriptor(m, methodIntf);
        MethodDescriptor match = null;
        for (Object next : businessMethodDescriptors) {
            MethodDescriptor nextMethodDesc = (MethodDescriptor)next;
            if (!nextMethodDesc.equals(methodDesc)) continue;
            match = nextMethodDesc;
            break;
        }
        return match;
    }

    public Collection getTransactionMethodDescriptors() {
        return this.getTransactionMethods(this.getEjbBundleDescriptor().getClassLoader());
    }

    protected Collection getTransactionMethods(ClassLoader classLoader) {
        try {
            BeanMethodCalculatorImpl bmc = new BeanMethodCalculatorImpl();
            return bmc.getTransactionalMethodsFor(this, classLoader);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getMethods())"});
            throw new RuntimeException(t);
        }
    }

    public Set<Method> getOptionalLocalBusinessMethods() {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            Method[] ms;
            Class<?> c = this.getEjbBundleDescriptor().getClassLoader().loadClass(this.getEjbClassName());
            for (Method m : ms = c.getMethods()) {
                if (m.getDeclaringClass() == Object.class) continue;
                methods.add(m);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getMethods())"});
            throw new RuntimeException(t);
        }
        return methods;
    }

    public abstract String getContainerFactoryQualifier();

    public Vector getMethods() {
        return this.getMethods(this.getEjbBundleDescriptor().getClassLoader());
    }

    public Vector getMethods(ClassLoader classLoader) {
        try {
            BeanMethodCalculatorImpl bmc = new BeanMethodCalculatorImpl();
            return bmc.getMethodsFor(this, classLoader);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{"(EjbDescriptor.getMethods())"});
            throw new RuntimeException(t);
        }
    }

    public Vector getFields() {
        Vector<Field> fieldsVector = new Vector<Field>();
        Class<?> ejb = null;
        try {
            ClassLoader cl = this.getEjbBundleDescriptor().getClassLoader();
            ejb = cl.loadClass(this.getEjbClassName());
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.methodClassLoadFailure", new Object[]{this.getEjbClassName()});
            return fieldsVector;
        }
        Field[] fields = ejb.getFields();
        for (int i = 0; i < fields.length; ++i) {
            fieldsVector.addElement(fields[i]);
        }
        return fieldsVector;
    }

    public Vector getFieldDescriptors() {
        Vector fields = this.getFields();
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        for (int fieldIndex = 0; fieldIndex < fields.size(); ++fieldIndex) {
            Field field = (Field)fields.elementAt(fieldIndex);
            fieldDescriptors.insertElementAt(new FieldDescriptor(field), fieldIndex);
        }
        return fieldDescriptors;
    }

    void doMethodDescriptorConversions() throws Exception {
        Hashtable transactions = this.getMethodContainerTransactions();
        Hashtable<MethodDescriptor, ContainerTransaction> convertedTransactions = new Hashtable<MethodDescriptor, ContainerTransaction>();
        Collection transactionMethods = this.getTransactionMethodDescriptors();
        Enumeration e = transactions.keys();
        while (e.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e.nextElement();
            ContainerTransaction ct = (ContainerTransaction)transactions.get(md);
            Enumeration mds = md.doStyleConversion(this, transactionMethods).elements();
            while (mds.hasMoreElements()) {
                MethodDescriptor next = (MethodDescriptor)mds.nextElement();
                convertedTransactions.put(next, new ContainerTransaction(ct));
            }
        }
        this.setMethodContainerTransactions(convertedTransactions);
        this.convertMethodPermissions();
    }

    @Override
    public void removeEjbReferencer(EjbReferenceDescriptor ref) {
        this.ejbReferencersPointingToMe.remove(ref);
    }

    @Override
    public void addEjbReferencer(EjbReferenceDescriptor ref) {
        this.ejbReferencersPointingToMe.add(ref);
    }

    public Set getAllEjbReferencers() {
        return this.ejbReferencersPointingToMe;
    }

    @Override
    public void setUniqueId(long id) {
        this.uniqueId = id;
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n homeClassName ").append(this.homeClassName);
        toStringBuffer.append("\n remoteClassName ").append(this.remoteClassName);
        toStringBuffer.append("\n remoteBusinessIntfs ").append(this.remoteBusinessClassNames).append("\n");
        toStringBuffer.append("\n localhomeClassName ").append(this.localHomeClassName);
        toStringBuffer.append("\n localClassName ").append(this.localClassName);
        toStringBuffer.append("\n localBusinessIntfs ").append(this.localBusinessClassNames);
        toStringBuffer.append("\n isLocalBean ").append(this.isLocalBean()).append("\n");
        toStringBuffer.append("\n jndiName ").append(this.jndiName).append("\n");
        toStringBuffer.append("\n ejbClassName ").append(this.ejbClassName);
        toStringBuffer.append("\n transactionType ").append(this.transactionType);
        toStringBuffer.append("\n methodContainerTransactions ").append(this.getMethodContainerTransactions());
        toStringBuffer.append("\n environmentProperties ");
        if (this.environmentProperties != null) {
            this.printDescriptorSet(this.environmentProperties, toStringBuffer);
        }
        toStringBuffer.append("\n ejbReferences ");
        if (this.ejbReferences != null) {
            this.printDescriptorSet(this.ejbReferences, toStringBuffer);
        }
        toStringBuffer.append("\n resourceEnvReferences ");
        if (this.resourceEnvReferences != null) {
            this.printDescriptorSet(this.resourceEnvReferences, toStringBuffer);
        }
        toStringBuffer.append("\n messageDestReferences ");
        if (this.messageDestReferences != null) {
            this.printDescriptorSet(this.messageDestReferences, toStringBuffer);
        }
        toStringBuffer.append("\n resourceReferences ");
        if (this.resourceReferences != null) {
            this.printDescriptorSet(this.resourceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n serviceReferences ");
        if (this.serviceReferences != null) {
            this.printDescriptorSet(this.serviceReferences, toStringBuffer);
        }
        toStringBuffer.append("\n roleReferences ");
        if (this.roleReferences != null) {
            this.printDescriptorSet(this.roleReferences, toStringBuffer);
        }
        for (MethodPermission nextPermission : this.getPermissionedMethodsByPermission().keySet()) {
            toStringBuffer.append("\n method-permission->method: ");
            nextPermission.print(toStringBuffer);
            toStringBuffer.append(" -> ").append(this.getPermissionedMethodsByPermission().get(nextPermission));
        }
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof EjbVisitor) {
            this.visit((EjbVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    public void visit(EjbVisitor aVisitor) {
        aVisitor.accept(this);
    }

    @Override
    public boolean allMechanismsRequireSSL() {
        if (this.iorConfigDescriptors == null || this.iorConfigDescriptors.isEmpty()) {
            return false;
        }
        for (EjbIORConfigurationDescriptor iorDesc : this.iorConfigDescriptors) {
            if ("REQUIRED".equalsIgnoreCase(iorDesc.getConfidentiality()) || "REQUIRED".equalsIgnoreCase(iorDesc.getConfidentiality()) || "REQUIRED".equalsIgnoreCase(iorDesc.getEstablishTrustInTarget()) || "REQUIRED".equalsIgnoreCase(iorDesc.getEstablishTrustInClient())) continue;
            return false;
        }
        return true;
    }
}

