/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.impl;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejb")
@PerLookup
public class EjbJarScanner
extends ModuleScanner<EjbBundleDescriptor> {
    @Override
    public void process(File af, EjbBundleDescriptor desc, ClassLoader cl) throws IOException {
        this.archiveFile = af;
        this.classLoader = cl;
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + this.archiveFile);
            AnnotationUtils.getLogger().fine("classLoader is " + this.classLoader);
        }
        if (!this.archiveFile.isDirectory()) {
            return;
        }
        this.addScanDirectories();
        this.addClassesFromDescriptor(desc);
    }

    protected void addScanDirectories() throws IOException {
        this.addScanDirectory(this.archiveFile);
    }

    protected void addClassesFromDescriptor(EjbBundleDescriptor desc) {
        for (EjbDescriptor ejbDescriptor : desc.getEjbs()) {
            if (!(ejbDescriptor instanceof EjbSessionDescriptor) && !(ejbDescriptor instanceof EjbMessageBeanDescriptor)) continue;
            this.addScanClassName(ejbDescriptor.getEjbClassName());
        }
        for (EjbInterceptor ejbInterceptor : desc.getInterceptors()) {
            this.addScanClassName(ejbInterceptor.getInterceptorClassName());
        }
    }
}

