/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-admin-object-config-properties")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-admin-object-config-properties", description="Get Admin Object Config Properties")})
public class GetAdminObjectConfigProps
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String rarName;
    @Param
    private String adminObjectInterface;
    @Param(optional=true)
    private String adminObjectClass;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Properties extraProperties = new Properties();
        try {
            Map<String, String> adminObjectConfigProps = this.adminObjectClass == null ? this.connectorRuntime.getAdminObjectConfigProps(this.rarName, this.adminObjectInterface) : this.connectorRuntime.getAdminObjectConfigProps(this.rarName, this.adminObjectInterface, this.adminObjectClass);
            extraProperties.put("adminObjectConfigProps", adminObjectConfigProps);
            List<String> confidentialProperties = this.connectorRuntime.getConfidentialProperties(this.rarName, "AdminObject", this.adminObjectInterface, this.adminObjectClass);
            extraProperties.put("confidentialConfigProps", confidentialProperties);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-admin-object-config-properties failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

