/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.ExceptionUtil;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.HostVerifier;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Service;

@Service(name="SSHLauncher")
@PerLookup
public class SSHLauncher {
    private static final String SSH_DIR = ".ssh" + File.separator;
    private static final String AUTH_KEY_FILE = "authorized_keys";
    private static final int DEFAULT_TIMEOUT_MSEC = 120000;
    private static final String SSH_KEYGEN = "ssh-keygen";
    private static final char LINE_SEP = System.getProperty("line.separator").charAt(0);
    private static KnownHosts knownHostsDatabase = new KnownHosts();
    private String host;
    private int port;
    private String userName;
    private String keyFile;
    private char[] privateKey;
    private Connection connection;
    private String authType;
    private String keyPassPhrase;
    private File knownHosts;
    private Logger logger;
    private String password;
    private String rawPassword = null;
    private String rawKeyPassPhrase = null;

    public void init(Logger logger2) {
        this.logger = logger2;
    }

    public void init(Node node, Logger logger2) {
        int port;
        String sshHost;
        this.logger = logger2;
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine("Connecting to host " + host);
        }
        if ((sshHost = connector.getSshHost()) != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = sshAuth.getKeyfile();
            this.rawPassword = sshAuth.getPassword();
            this.rawKeyPassPhrase = sshAuth.getKeyPassphrase();
        }
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.init(userName, this.host, port, this.rawPassword, this.keyFile, this.rawKeyPassPhrase, logger2);
    }

    public void init(String userName, String host, int port, String password, char[] privateKey, Logger logger2) {
        this.init(userName, host, port, password, null, null, privateKey, logger2);
    }

    public void init(String userName, String host, int port, String password, String keyFile, String keyPassPhrase, Logger logger2) {
        this.init(userName, host, port, password, keyFile, keyPassPhrase, null, logger2);
    }

    private void init(String userName, String host, int port, String password, String keyFile, String keyPassPhrase, char[] privateKey, Logger logger2) {
        this.port = port == 0 ? 22 : port;
        this.host = host;
        this.privateKey = privateKey != null ? Arrays.copyOf(privateKey, privateKey.length) : null;
        this.keyFile = keyFile == null && privateKey == null ? SSHUtil.getExistingKeyFile() : keyFile;
        this.logger = logger2;
        this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        this.rawPassword = password;
        this.password = this.expandPasswordAlias(password);
        this.rawKeyPassPhrase = keyPassPhrase;
        this.keyPassPhrase = this.expandPasswordAlias(keyPassPhrase);
        if (this.knownHosts == null) {
            File home = new File(System.getProperty("user.home"));
            this.knownHosts = new File(home, ".ssh/known_hosts");
        }
        if (this.knownHosts.exists()) {
            try {
                knownHostsDatabase.addHostkeys(this.knownHosts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (logger2.isLoggable(Level.FINER)) {
            logger2.finer("SSH info is " + this.toString());
        }
    }

    private void openConnection() throws IOException {
        boolean isAuthenticated = false;
        String message = "";
        this.connection = new Connection(this.host, this.port);
        this.connection.connect(new HostVerifier(knownHostsDatabase));
        if (SSHUtil.checkString(this.keyFile) == null && SSHUtil.checkString(this.password) == null && this.privateKey == null) {
            message = message + "No key or password specified - trying default keys \n";
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("keyfile and password are null. Will try to authenticate with default key file if available");
            }
            File home = new File(System.getProperty("user.home"));
            for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                message = message + "Tried to authenticate using " + keyName + "\n";
                File key = new File(home, ".ssh/" + keyName);
                if (key.exists()) {
                    isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, null);
                }
                if (!isAuthenticated) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Authentication successful using key " + keyName);
                }
                message = null;
                break;
            }
        }
        if (!isAuthenticated && SSHUtil.checkString(this.password) != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Authenticating with password " + this.getPrintablePassword(this.password));
            }
            try {
                isAuthenticated = this.connection.authenticateWithPassword(this.userName, this.password);
            }
            catch (IOException iex) {
                message = "SSH authentication with password failed: " + ExceptionUtil.getRootCause(iex).getMessage();
                this.logger.log(Level.WARNING, message, iex);
            }
        }
        if (!isAuthenticated && this.privateKey != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Authenticating with privateKey");
            }
            try {
                isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, this.privateKey, this.keyPassPhrase);
            }
            catch (IOException iex) {
                message = "SSH authentication with private key failed: " + ExceptionUtil.getRootCause(iex).getMessage();
                this.logger.log(Level.WARNING, message, iex);
            }
        }
        if (!isAuthenticated && SSHUtil.checkString(this.keyFile) != null) {
            File key;
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Specified key file is " + this.keyFile);
            }
            if ((key = new File(this.keyFile)).exists()) {
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Specified key file exists at " + key);
                }
                try {
                    isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, this.keyPassPhrase);
                }
                catch (IOException iex) {
                    message = "SSH authentication with key file " + key + " failed: " + ExceptionUtil.getRootCause(iex).getMessage();
                    this.logger.log(Level.WARNING, message, iex);
                }
            }
        }
        if (!isAuthenticated && !this.connection.isAuthenticationComplete()) {
            this.connection.close();
            this.connection = null;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not authenticate");
            }
            throw new IOException("Could not authenticate. " + message);
        }
        message = null;
        SSHUtil.register(this.connection);
    }

    public int runCommand(List<String> command, OutputStream os, List<String> stdinLines) throws IOException, InterruptedException {
        return this.runCommand(SSHLauncher.commandListToQuotedString(command), os, stdinLines);
    }

    public int runCommand(List<String> command, OutputStream os) throws IOException, InterruptedException {
        return this.runCommand(command, os, null);
    }

    public int runCommand(String command, OutputStream os) throws IOException, InterruptedException {
        return this.runCommand(command, os, null);
    }

    public int runCommand(String command, OutputStream os, List<String> stdinLines) throws IOException, InterruptedException {
        command = SFTPClient.normalizePath(command);
        return this.runCommandAsIs(command, os, stdinLines);
    }

    public int runCommandAsIs(List<String> command, OutputStream os, List<String> stdinLines) throws IOException, InterruptedException {
        return this.runCommandAsIs(SSHLauncher.commandListToQuotedString(command), os, stdinLines);
    }

    private int runCommandAsIs(String command, OutputStream os, List<String> stdinLines) throws IOException, InterruptedException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Running command " + command + " on host: " + this.host);
        }
        this.openConnection();
        Session sess = this.connection.openSession();
        int status = this.exec(sess, command, os, this.listInputStream(stdinLines));
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return status;
    }

    public int runCommandAsIs(List<String> command, OutputStream os, List<String> stdinLines, String[] env) throws IOException, InterruptedException {
        return this.runCommandAsIs(SSHLauncher.commandListToQuotedString(command), os, stdinLines, env);
    }

    private int runCommandAsIs(String command, OutputStream os, List<String> stdinLines, String[] env) throws IOException, InterruptedException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Running command " + command + " on host: " + this.host);
        }
        this.openConnection();
        StringBuffer buff = new StringBuffer();
        if (env != null) {
            String prefix;
            Session tempSession = this.connection.openSession();
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            this.exec(tempSession, "ps -p $$ | tail -1 | awk '{print $NF}'", ous, null);
            if (((Object)ous).toString().contains("csh")) {
                this.logger.fine("CSH shell");
                prefix = "setenv";
            } else {
                this.logger.fine("BASH shell");
                prefix = "export";
            }
            for (String st : env) {
                String cmd = prefix + " " + st;
                buff.append(cmd).append(";");
            }
        }
        buff.append(command);
        Session sess = this.connection.openSession();
        int status = this.exec(sess, buff.toString(), os, this.listInputStream(stdinLines));
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(Session session, String command, OutputStream os, InputStream is) throws IOException, InterruptedException {
        try {
            session.execCommand(command);
            PumpThread t1 = new PumpThread(session.getStdout(), os);
            t1.start();
            PumpThread t2 = new PumpThread(session.getStderr(), os);
            t2.start();
            OutputStream stdin = session.getStdin();
            if (is != null) {
                PumpThread inputPump = new PumpThread(is, stdin);
                inputPump.run();
            }
            stdin.close();
            t1.join();
            t2.join();
            session.waitForCondition(32, 3000L);
            Integer r = session.getExitStatus();
            if (r != null) {
                int n = r;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            session.close();
        }
    }

    private InputStream listInputStream(List<String> stdinLines) throws IOException {
        if (stdinLines == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (String line : stdinLines) {
            baos.write(line.getBytes());
            baos.write(LINE_SEP);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void pingConnection() throws IOException, InterruptedException {
        this.logger.fine("Pinging connection for host: " + this.host);
        this.openConnection();
        SSHUtil.unregister(this.connection);
        this.connection = null;
    }

    public void validate(String host, int port, String userName, String password, String keyFile, String keyPassPhrase, String installDir, String landmarkPath, Logger logger2) throws IOException {
        boolean validInstallDir = false;
        this.init(userName, host, port, password, keyFile, keyPassPhrase, logger2);
        this.openConnection();
        logger2.fine("Connection settings valid");
        String testPath = installDir;
        if (StringUtils.ok(testPath)) {
            SFTPClient sftpClient = new SFTPClient(this.connection);
            if (sftpClient.exists(testPath)) {
                if (StringUtils.ok(landmarkPath)) {
                    testPath = installDir + "/" + landmarkPath;
                }
                validInstallDir = sftpClient.exists(testPath);
            } else {
                validInstallDir = false;
            }
            SSHUtil.unregister(this.connection);
            this.connection = null;
            if (!validInstallDir) {
                String msg = "Invalid install directory: could not find " + testPath + " on " + host;
                throw new FileNotFoundException(msg);
            }
            logger2.fine("Node home validated");
        }
    }

    public void validate(String host, int port, String userName, String password, String keyFile, String keyPassPhrase, String installDir, Logger logger2) throws IOException {
        this.validate(host, port, userName, password, keyFile, keyPassPhrase, installDir, null, logger2);
    }

    public SFTPClient getSFTPClient() throws IOException {
        this.openConnection();
        SFTPClient sftpClient = new SFTPClient(this.connection);
        return sftpClient;
    }

    public SCPClient getSCPClient() throws IOException {
        this.openConnection();
        return new SCPClient(this.connection);
    }

    public String expandPasswordAlias(String alias) {
        String expandedPassword = null;
        if (alias == null) {
            return null;
        }
        try {
            expandedPassword = RelativePathResolver.getRealPasswordFromAlias(alias);
        }
        catch (Exception e) {
            this.logger.warning(StringUtils.cat(": ", alias, e.getMessage()));
            return null;
        }
        return expandedPassword;
    }

    public boolean isPasswordAlias(String alias) {
        String aliasName = RelativePathResolver.getAlias(alias);
        return aliasName != null;
    }

    private String getPrintablePassword(String p) {
        String printable = "null";
        if (p != null) {
            printable = this.isPasswordAlias(p) ? p : "<concealed>";
        }
        return printable;
    }

    public void setupKey(String node, String pubKeyFile, boolean generateKey, String passwd2) throws IOException, InterruptedException {
        boolean connected = false;
        File key = new File(this.keyFile);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Key = " + this.keyFile);
        }
        if (key.exists()) {
            if (this.checkConnection()) {
                throw new IOException("SSH public key authentication is already configured for " + this.userName + "@" + node);
            }
        } else if (generateKey) {
            if (!this.generateKeyPair()) {
                throw new IOException("SSH key pair generation failed. Please generate key manually.");
            }
        } else {
            throw new IOException("SSH key pair not present. Please generate a key pair manually or specify an existing one and re-run the command.");
        }
        if (passwd2 == null) {
            throw new IOException("SSH password is required for distributing the public key. You can specify the SSH password in a password file and pass it through --passwordfile option.");
        }
        this.connection = new Connection(node, this.port);
        this.connection.connect();
        connected = this.connection.authenticateWithPassword(this.userName, passwd2);
        if (!connected) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        Connection conn = new Connection(node, this.port);
        conn.connect();
        boolean ret = conn.authenticateWithPassword(this.userName, passwd2);
        if (!ret) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        SCPClient scp = new SCPClient(conn);
        SFTPClient sftp = new SFTPClient(this.connection);
        if (key.exists()) {
            File pubKey;
            this.setupSSHDir();
            if (pubKeyFile == null) {
                pubKeyFile = this.keyFile + ".pub";
            }
            if (!(pubKey = new File(pubKeyFile)).exists()) {
                throw new IOException("Public key file " + pubKeyFile + " does not exist.");
            }
            try {
                if (!sftp.exists(SSH_DIR)) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(SSH_DIR + " does not exist");
                    }
                    sftp.mkdirs(".ssh", 448);
                }
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.FINER)) {
                    e.printStackTrace();
                }
                throw new IOException("Error while creating .ssh directory on remote host:" + e.getMessage());
            }
            scp.put(pubKey.getAbsolutePath(), "key.tmp", ".ssh", "0600");
            String mergeCommand = "cd .ssh; cat key.tmp >> authorized_keys";
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("mergeCommand = " + mergeCommand);
            }
            if (conn.exec(mergeCommand, new ByteArrayOutputStream()) != 0) {
                throw new IOException("Failed to propogate the public key " + pubKeyFile + " to " + this.host);
            }
            this.logger.info("Copied keyfile " + pubKeyFile + " to " + this.userName + "@" + this.host);
            if (conn.exec("rm .ssh/key.tmp", new ByteArrayOutputStream()) != 0) {
                this.logger.warning("WARNING: Failed to remove the public key file key.tmp on remote host " + this.host);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Removed the temporary key file on remote host");
            }
            this.logger.info("Fixing file permissions for home(755), .ssh(700) and authorized_keys file(644)");
            sftp.chmod(".", 493);
            sftp.chmod(SSH_DIR, 448);
            sftp.chmod(SSH_DIR + AUTH_KEY_FILE, 420);
            sftp.close();
            conn.close();
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) >= 0) {
            output.write(buf, 0, len);
        }
        byte[] o = output.toByteArray();
        output.close();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        boolean status = false;
        Connection c = null;
        c = new Connection(this.host, this.port);
        try {
            c.connect();
            File f = new File(this.keyFile);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Checking connection...");
            }
            if (status = c.authenticateWithPublicKey(this.userName, f, this.rawKeyPassPhrase)) {
                this.logger.info("Successfully connected to " + this.userName + "@" + this.host + " using keyfile " + this.keyFile);
            }
        }
        catch (IOException ioe) {
            Throwable t = ioe.getCause();
            if (t != null) {
                String msg = t.getMessage();
                this.logger.warning("Failed to connect or authenticate: " + msg);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "Failed to connect or autheticate: ", ioe);
            }
        }
        finally {
            c.close();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPasswordAuth() {
        boolean status = false;
        try (Connection c = null;){
            c = new Connection(this.host, this.port);
            c.connect();
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Checking connection...");
            }
            if ((status = c.authenticateWithPassword(this.userName, this.password)) && this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Successfully connected to " + this.userName + "@" + this.host + " using password authentication");
            }
        }
        return status;
    }

    private boolean generateKeyPair() throws IOException {
        int exit;
        String keygenCmd = this.findSSHKeygen();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Using " + keygenCmd + " to generate key pair");
        }
        if (!this.setupSSHDir()) {
            throw new IOException("Failed to set proper permissions on .ssh directory");
        }
        StringBuffer k = new StringBuffer();
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(keygenCmd);
        k.append(keygenCmd);
        cmdLine.add("-t");
        k.append(" ").append("-t");
        cmdLine.add("rsa");
        k.append(" ").append("rsa");
        cmdLine.add("-N");
        k.append(" ").append("-N");
        if (this.rawKeyPassPhrase != null && this.rawKeyPassPhrase.length() > 0) {
            cmdLine.add(this.rawKeyPassPhrase);
            k.append(" ").append(this.getPrintablePassword(this.rawKeyPassPhrase));
        } else if (OS.isWindows()) {
            cmdLine.add("\"\"");
            k.append(" ").append("\"\"");
        } else {
            cmdLine.add("");
            k.append(" ").append("");
        }
        cmdLine.add("-f");
        k.append(" ").append("-f");
        cmdLine.add(this.keyFile);
        k.append(" ").append(this.keyFile);
        ProcessManager pm = new ProcessManager(cmdLine);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Command = " + k);
        }
        pm.setTimeoutMsec(120000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing ssh-keygen: " + ex.getMessage());
            }
            exit = 1;
        }
        if (exit == 0) {
            this.logger.info(keygenCmd + " successfully generated the identification " + this.keyFile);
        } else {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(pm.getStderr());
            }
            this.logger.info(keygenCmd + " failed");
        }
        return exit == 0;
    }

    private String findSSHKeygen() {
        File exe;
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList("/usr/bin/", "/usr/local/bin/"));
        if (OS.isWindows()) {
            paths.add("C:/cygwin/bin/");
            String mks = System.getenv("ROOTDIR");
            if (mks != null) {
                paths.add(mks + "/bin/");
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Paths = " + paths);
        }
        if ((exe = ProcessUtils.getExe(SSH_KEYGEN)) != null) {
            return exe.getPath();
        }
        for (String s : paths) {
            File f = new File(s + SSH_KEYGEN);
            if (!f.canExecute()) continue;
            return f.getAbsolutePath();
        }
        return SSH_KEYGEN;
    }

    private boolean setupSSHDir() throws IOException {
        boolean ret = true;
        File home = new File(System.getProperty("user.home"));
        File f = new File(home, SSH_DIR);
        if (!FileUtils.safeIsDirectory(f)) {
            if (!f.mkdirs()) {
                throw new IOException("Failed to create " + f.getPath());
            }
            this.logger.info("Created directory " + f.toString());
        }
        if (!f.setReadable(false, false) || !f.setReadable(true)) {
            ret = false;
        }
        if (!f.setWritable(false, false) || !f.setWritable(true)) {
            ret = false;
        }
        if (!f.setExecutable(false, false) || !f.setExecutable(true)) {
            ret = false;
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Fixed the .ssh directory permissions to 0700");
        }
        return ret;
    }

    public String toString() {
        String knownHostsPath = "null";
        if (this.knownHosts != null) {
            try {
                knownHostsPath = this.knownHosts.getCanonicalPath();
            }
            catch (IOException e) {
                knownHostsPath = this.knownHosts.getAbsolutePath();
            }
        }
        String displayPassword = this.getPrintablePassword(this.rawPassword);
        String displayKeyPassPhrase = this.getPrintablePassword(this.rawKeyPassPhrase);
        return String.format("host=%s port=%d user=%s password=%s keyFile=%s keyPassPhrase=%s authType=%s knownHostFile=%s", this.host, this.port, this.userName, displayPassword, this.keyFile, displayKeyPassPhrase, this.authType, knownHostsPath);
    }

    private static String commandListToQuotedString(List<String> command) {
        if (command.size() == 1) {
            return command.get(0);
        }
        StringBuilder commandBuilder = new StringBuilder();
        boolean first = true;
        for (String s : command) {
            if (!first) {
                commandBuilder.append(" ");
            } else {
                first = false;
            }
            if (s.contains(" ")) {
                commandBuilder.append(FileUtils.quoteString(s));
                continue;
            }
            commandBuilder.append(s);
        }
        return commandBuilder.toString();
    }

    private static final class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out) {
            super("pump thread");
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                while (true) {
                    int len;
                    if ((len = this.in.read(buf)) < 0) {
                        this.in.close();
                        return;
                    }
                    this.out.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

