/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRED)
public class TransactionalInterceptorRequired
extends TransactionalInterceptorBase {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.resource.jta", "org.glassfish.cdi.LogMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.log(Level.INFO, "AS-JTA-00009");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            boolean isTransactionStarted = false;
            if (this.getTransactionManager().getTransaction() == null) {
                _logger.log(Level.INFO, "AS-JTA-00010");
                try {
                    this.getTransactionManager().begin();
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during begin " + exception;
                    _logger.log(Level.INFO, "AS-JTA-00011", exception);
                    throw new TransactionalException(messageString, exception);
                }
                isTransactionStarted = true;
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                if (isTransactionStarted) {
                    try {
                        this.getTransactionManager().commit();
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during commit " + exception;
                        _logger.log(Level.INFO, "AS-JTA-00012", exception);
                        throw new TransactionalException(messageString, exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

