/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.DefaultJPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPAVersion;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.jpa.jpql.utility.CollectionTools;

public abstract class AbstractValidator
extends AnonymousExpressionVisitor {
    private BypassChildCollectionExpressionVisitor bypassChildCollectionExpressionVisitor;
    private BypassParentSubExpressionVisitor bypassParentSubExpressionVisitor;
    private ChildrenCollectorVisitor childrenCollectorVisitor;
    private LiteralVisitor literalVisitor;
    private NestedArrayVisitor nestedArrayVisitor;
    private OwningClauseVisitor owningClauseVisitor;
    private OwningStatementVisitor owningStatementVisitor;
    private Collection<JPQLQueryProblem> problems;
    private SubqueryVisitor subqueryVisitor;
    private Map<String, JPQLQueryBNFValidator> validators;

    protected AbstractValidator() {
        this.initialize();
    }

    protected void addProblem(Expression expression, int startPosition, int endPosition, String messageKey, String ... messageArguments) {
        this.problems.add(this.buildProblem(expression, startPosition, endPosition, messageKey, messageArguments));
    }

    protected void addProblem(Expression expression, int startPosition, String messageKey, String ... messageArguments) {
        this.addProblem(expression, startPosition, startPosition, messageKey, messageArguments);
    }

    protected void addProblem(Expression expression, String messageKey) {
        this.addProblem(expression, messageKey, ExpressionTools.EMPTY_STRING_ARRAY);
    }

    protected void addProblem(Expression expression, String messageKey, String ... arguments) {
        int startPosition = expression.getOffset();
        int endPosition = startPosition + this.length(expression);
        this.addProblem(expression, startPosition, endPosition, messageKey, arguments);
    }

    protected ChildrenCollectorVisitor buildChildrenCollector() {
        return new ChildrenCollectorVisitor();
    }

    protected abstract LiteralVisitor buildLiteralVisitor();

    protected NestedArrayVisitor buildNestedArrayVisitor() {
        return new NestedArrayVisitor();
    }

    protected abstract OwningClauseVisitor buildOwningClauseVisitor();

    protected OwningStatementVisitor buildOwningStatementVisitor() {
        return new OwningStatementVisitor();
    }

    protected JPQLQueryProblem buildProblem(Expression expression, int startPosition, int endPosition, String messageKey, String ... messageArguments) {
        return new DefaultJPQLQueryProblem(expression, startPosition, endPosition, messageKey, messageArguments);
    }

    protected SubqueryVisitor buildSubqueryVisitor() {
        return new SubqueryVisitor();
    }

    public void dispose() {
        this.problems = null;
    }

    protected BypassChildCollectionExpressionVisitor getBypassChildCollectionExpressionVisitor() {
        if (this.bypassChildCollectionExpressionVisitor == null) {
            this.bypassChildCollectionExpressionVisitor = new BypassChildCollectionExpressionVisitor();
        }
        return this.bypassChildCollectionExpressionVisitor;
    }

    protected BypassParentSubExpressionVisitor getBypassParentSubExpressionVisitor() {
        if (this.bypassParentSubExpressionVisitor == null) {
            this.bypassParentSubExpressionVisitor = new BypassParentSubExpressionVisitor();
        }
        return this.bypassParentSubExpressionVisitor;
    }

    protected List<Expression> getChildren(Expression expression) {
        ChildrenCollectorVisitor visitor = this.getChildrenCollectorVisitor();
        try {
            visitor.expressions = new LinkedList<Expression>();
            expression.accept(visitor);
            List<Expression> list = visitor.expressions;
            return list;
        }
        finally {
            visitor.expressions = null;
        }
    }

    protected ChildrenCollectorVisitor getChildrenCollectorVisitor() {
        if (this.childrenCollectorVisitor == null) {
            this.childrenCollectorVisitor = this.buildChildrenCollector();
        }
        return this.childrenCollectorVisitor;
    }

    protected ExpressionRegistry getExpressionRegistry() {
        return this.getGrammar().getExpressionRegistry();
    }

    protected JPQLQueryBNFValidator getExpressionValidator(String queryBNF) {
        JPQLQueryBNFValidator validator = this.validators.get(queryBNF);
        if (validator == null) {
            validator = new JPQLQueryBNFValidator(this.getExpressionRegistry().getQueryBNF(queryBNF));
            this.validators.put(queryBNF, validator);
        }
        return validator;
    }

    protected abstract JPQLGrammar getGrammar();

    protected JPAVersion getJPAVersion() {
        return this.getGrammar().getJPAVersion();
    }

    protected JPQLQueryBNFValidator getJPQLQueryBNFValidator(JPQLQueryBNF queryBNF) {
        JPQLQueryBNFValidator validator = this.validators.get(queryBNF);
        if (validator == null) {
            validator = new JPQLQueryBNFValidator(queryBNF);
            this.validators.put(queryBNF.getId(), validator);
        }
        return validator;
    }

    protected JPQLQueryBNFValidator getJPQLQueryBNFValidator(String queryBNF) {
        return this.getJPQLQueryBNFValidator(this.getQueryBNF(queryBNF));
    }

    protected LiteralVisitor getLiteralVisitor() {
        if (this.literalVisitor == null) {
            this.literalVisitor = this.buildLiteralVisitor();
        }
        return this.literalVisitor;
    }

    protected NestedArrayVisitor getNestedArrayVisitor() {
        if (this.nestedArrayVisitor == null) {
            this.nestedArrayVisitor = this.buildNestedArrayVisitor();
        }
        return this.nestedArrayVisitor;
    }

    protected OwningClauseVisitor getOwningClauseVisitor() {
        if (this.owningClauseVisitor == null) {
            this.owningClauseVisitor = this.buildOwningClauseVisitor();
        }
        return this.owningClauseVisitor;
    }

    protected OwningStatementVisitor getOwningStatementVisitor() {
        if (this.owningStatementVisitor == null) {
            this.owningStatementVisitor = this.buildOwningStatementVisitor();
        }
        return this.owningStatementVisitor;
    }

    protected String getProvider() {
        return this.getGrammar().getProvider();
    }

    protected String getProviderVersion() {
        return this.getGrammar().getProviderVersion();
    }

    protected JPQLQueryBNF getQueryBNF(String queryBNFId) {
        return this.getGrammar().getExpressionRegistry().getQueryBNF(queryBNFId);
    }

    protected SubqueryVisitor getSubqueryVisitor() {
        if (this.subqueryVisitor == null) {
            this.subqueryVisitor = this.buildSubqueryVisitor();
        }
        return this.subqueryVisitor;
    }

    protected void initialize() {
        this.validators = new HashMap<String, JPQLQueryBNFValidator>();
    }

    protected boolean isNestedArray(Expression expression) {
        return this.nestedArraySize(expression) > -1;
    }

    protected boolean isSubquery(Expression expression) {
        SubqueryVisitor visitor = this.getSubqueryVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.expression != null;
            return bl;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected boolean isValid(Expression expression, JPQLQueryBNF queryBNF) {
        JPQLQueryBNFValidator validator = this.getJPQLQueryBNFValidator(queryBNF);
        try {
            expression.accept(validator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    protected boolean isValid(Expression expression, String queryBNFId) {
        return this.isValid(expression, this.getQueryBNF(queryBNFId));
    }

    protected boolean isValid(Expression expression, String ... queryBNFIds) {
        String[] stringArray = queryBNFIds;
        int n = queryBNFIds.length;
        int n2 = 0;
        while (n2 < n) {
            String queryBNFId = stringArray[n2];
            if (this.isValid(expression, queryBNFId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isValidWithChildCollectionBypass(Expression expression, String queryBNF) {
        JPQLQueryBNFValidator validator = this.getExpressionValidator(queryBNF);
        BypassChildCollectionExpressionVisitor bypassValidator = this.getBypassChildCollectionExpressionVisitor();
        try {
            bypassValidator.visitor = validator;
            expression.accept(bypassValidator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            bypassValidator.visitor = null;
            validator.valid = false;
        }
    }

    protected boolean isWithinSubquery(Expression expression) {
        OwningStatementVisitor visitor = this.getOwningStatementVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.simpleSelectStatement != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected boolean isWithinTopLevelQuery(Expression expression) {
        OwningStatementVisitor visitor = this.getOwningStatementVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.deleteStatement != null || visitor.selectStatement != null || visitor.updateStatement != null;
            return bl;
        }
        finally {
            visitor.dispose();
        }
    }

    protected int length(Expression expression) {
        return expression.getLength();
    }

    protected String literal(Expression expression, LiteralType type2) {
        LiteralVisitor visitor = this.getLiteralVisitor();
        try {
            visitor.setType(type2);
            expression.accept(visitor);
            String string = visitor.literal;
            return string;
        }
        finally {
            visitor.literal = "";
        }
    }

    protected int nestedArraySize(Expression expression) {
        NestedArrayVisitor visitor = this.getNestedArrayVisitor();
        try {
            visitor.nestedArraySize = -1;
            expression.accept(visitor);
            int n = visitor.nestedArraySize;
            return n;
        }
        finally {
            visitor.nestedArraySize = -1;
        }
    }

    protected int position(Expression expression) {
        return expression.getOffset();
    }

    public final int problemsSize() {
        return this.problems.size();
    }

    public void setProblems(Collection<JPQLQueryProblem> problems) {
        Assert.isNotNull(problems, "The Collection cannot be null");
        this.problems = problems;
    }

    @Override
    protected void visit(Expression expression) {
        expression.acceptChildren(this);
    }

    public static class BypassChildCollectionExpressionVisitor
    extends AnonymousExpressionVisitor {
        public JPQLQueryBNFValidator visitor;

        @Override
        public void visit(CollectionExpression expression) {
            for (Expression child : expression.children()) {
                child.accept(this);
                if (!this.visitor.valid) break;
            }
        }

        @Override
        protected void visit(Expression expression) {
            expression.accept(this.visitor);
        }

        @Override
        public void visit(NullExpression expression) {
        }
    }

    public static class BypassParentSubExpressionVisitor
    extends AnonymousExpressionVisitor {
        public ExpressionVisitor visitor;

        @Override
        protected void visit(Expression expression) {
            expression.accept(this.visitor);
        }

        @Override
        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }
    }

    public static class ChildrenCollectorVisitor
    extends AnonymousExpressionVisitor {
        protected List<Expression> expressions;

        @Override
        public void visit(CollectionExpression expression) {
            CollectionTools.addAll(this.expressions, expression.children());
        }

        @Override
        protected void visit(Expression expression) {
            this.expressions.add(expression);
        }

        @Override
        public void visit(NullExpression expression) {
        }
    }

    public static class JPQLQueryBNFValidator
    extends AnonymousExpressionVisitor {
        protected boolean bypassCompound;
        private JPQLQueryBNF queryBNF;
        protected boolean valid;

        public JPQLQueryBNFValidator(JPQLQueryBNF queryBNF) {
            this.queryBNF = queryBNF;
        }

        private void allJPQLQueryBNFs(Set<String> queryBNFIds, JPQLQueryBNF queryBNF) {
            if (queryBNFIds.add(queryBNF.getId()) && (this.bypassCompound || !queryBNF.isCompound())) {
                for (JPQLQueryBNF childQueryBNF : queryBNF.nonCompoundChildren()) {
                    this.allJPQLQueryBNFs(queryBNFIds, childQueryBNF);
                }
            }
        }

        public void dispose() {
            this.valid = false;
            this.bypassCompound = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setBypassCompound(boolean bypassCompound) {
            this.bypassCompound = bypassCompound;
        }

        public void validate(JPQLQueryBNF queryBNF) {
            this.valid = false;
            if (queryBNF.getId() == this.queryBNF.getId()) {
                this.valid = true;
            } else {
                HashSet<String> allQueryBNFIds = new HashSet<String>();
                this.allJPQLQueryBNFs(allQueryBNFIds, this.queryBNF);
                this.valid = allQueryBNFIds.contains(queryBNF.getId());
            }
        }

        @Override
        public void visit(BadExpression expression) {
        }

        @Override
        public void visit(CollectionExpression expression) {
            this.valid = false;
        }

        @Override
        protected void visit(Expression expression) {
            this.validate(((AbstractExpression)expression).getQueryBNF());
        }

        @Override
        public void visit(NullExpression expression) {
            this.valid = true;
        }

        @Override
        public void visit(SubExpression expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        @Override
        public void visit(UnknownExpression expression) {
        }
    }

    protected static class NestedArrayVisitor
    extends AbstractExpressionVisitor {
        public int nestedArraySize;
        protected boolean subExpression;

        protected NestedArrayVisitor() {
        }

        @Override
        public void visit(CollectionExpression expression) {
            this.nestedArraySize = this.subExpression ? expression.childrenSize() : -1;
        }

        @Override
        public void visit(SubExpression expression) {
            this.subExpression = true;
            expression.getExpression().accept(this);
            this.subExpression = false;
        }
    }

    public static class OwningClauseVisitor
    extends AbstractTraverseParentVisitor {
        public DeleteClause deleteClause;
        public FromClause fromClause;
        public GroupByClause groupByClause;
        public HavingClause havingClause;
        public OrderByClause orderByClause;
        public SelectClause selectClause;
        public SimpleFromClause simpleFromClause;
        public SimpleSelectClause simpleSelectClause;
        public UpdateClause updateClause;
        public WhereClause whereClause;

        public void dispose() {
            this.deleteClause = null;
            this.fromClause = null;
            this.groupByClause = null;
            this.havingClause = null;
            this.orderByClause = null;
            this.selectClause = null;
            this.simpleFromClause = null;
            this.simpleSelectClause = null;
            this.updateClause = null;
            this.whereClause = null;
        }

        @Override
        public void visit(DeleteClause expression) {
            this.deleteClause = expression;
        }

        @Override
        public void visit(FromClause expression) {
            this.fromClause = expression;
        }

        @Override
        public void visit(GroupByClause expression) {
            this.groupByClause = expression;
        }

        @Override
        public void visit(HavingClause expression) {
            this.havingClause = expression;
        }

        @Override
        public void visit(OrderByClause expression) {
            this.orderByClause = expression;
        }

        @Override
        public void visit(SelectClause expression) {
            this.selectClause = expression;
        }

        @Override
        public void visit(SimpleFromClause expression) {
            this.simpleFromClause = expression;
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            this.simpleSelectClause = expression;
        }

        @Override
        public void visit(UpdateClause expression) {
            this.updateClause = expression;
        }

        @Override
        public void visit(WhereClause expression) {
            this.whereClause = expression;
        }
    }

    protected static class OwningStatementVisitor
    extends AbstractTraverseParentVisitor {
        public DeleteStatement deleteStatement;
        public SelectStatement selectStatement;
        public SimpleSelectStatement simpleSelectStatement;
        public UpdateStatement updateStatement;

        protected OwningStatementVisitor() {
        }

        protected void dispose() {
            this.deleteStatement = null;
            this.selectStatement = null;
            this.simpleSelectStatement = null;
            this.updateStatement = null;
        }

        @Override
        public void visit(DeleteStatement expression) {
            this.deleteStatement = expression;
        }

        @Override
        public void visit(SelectStatement expression) {
            this.selectStatement = expression;
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            this.simpleSelectStatement = expression;
        }

        @Override
        public void visit(UpdateStatement expression) {
            this.updateStatement = expression;
        }
    }

    protected static class SubqueryVisitor
    extends AbstractExpressionVisitor {
        private SimpleSelectStatement expression;

        protected SubqueryVisitor() {
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            this.expression = expression;
        }
    }
}

