/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.CharactersEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.CommentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.DocumentLocatorEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndCDATAEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndDTDEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndDocumentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndElementEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.EndPrefixMappingEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.IgnorableWhitespaceEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.ProcessingInstructionEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.SAXEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.SkippedEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartCDATAEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartDTDEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartDocumentEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartElementEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartEntityEvent;
import org.eclipse.persistence.internal.oxm.record.deferred.StartPrefixMappingEvent;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class DeferredContentHandler
implements ExtendedContentHandler,
LexicalHandler {
    private int levelIndex = 0;
    private List<SAXEvent> events = new ArrayList<SAXEvent>();
    private UnmarshalRecord parent;
    private boolean startOccurred;
    private boolean charactersOccurred;
    private boolean attributesOccurred;

    public DeferredContentHandler(UnmarshalRecord parentRecord) {
        this.parent = parentRecord;
    }

    @Override
    public void setNil(boolean isNil) {
    }

    protected abstract void processEmptyElement() throws SAXException;

    protected abstract void processComplexElement() throws SAXException;

    protected abstract void processSimpleElement() throws SAXException;

    protected void processEmptyElementWithAttributes() throws SAXException {
        this.processEmptyElement();
    }

    protected void executeEvents(UnmarshalRecord unmarshalRecord) throws SAXException {
        int i = 0;
        while (i < this.events.size()) {
            SAXEvent nextEvent = this.events.get(i);
            nextEvent.processEvent(unmarshalRecord);
            ++i;
        }
        XMLReader parentXMLReader = this.parent.getXMLReader();
        if (parentXMLReader.getContentHandler().equals(this)) {
            parentXMLReader.setContentHandler(unmarshalRecord);
            parentXMLReader.setLexicalHandler(unmarshalRecord);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        StartPrefixMappingEvent event = new StartPrefixMappingEvent(prefix, uri);
        this.events.add(event);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        EndPrefixMappingEvent event = new EndPrefixMappingEvent(prefix);
        this.events.add(event);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.levelIndex;
        AttributeList copiedAttrs = this.buildAttributeList(atts);
        StartElementEvent event = new StartElementEvent(uri, localName, qName, copiedAttrs);
        this.events.add(event);
        if (this.startOccurred) {
            this.processComplexElement();
            return;
        }
        this.startOccurred = true;
    }

    protected AttributeList buildAttributeList(Attributes attrs) throws SAXException {
        int attrsLength = attrs.getLength();
        AttributeList attributes = new AttributeList(attrsLength);
        int i = 0;
        while (i < attrsLength) {
            String qName = attrs.getQName(i);
            String uri = attrs.getURI(i);
            attributes.addAttribute(attrs.getLocalName(i), qName, uri, attrs.getType(i), attrs.getValue(i), i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(uri) && qName != null && !qName.startsWith("xmlns")) {
                this.attributesOccurred = true;
            }
            ++i;
        }
        return attributes;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.levelIndex;
        EndElementEvent event = new EndElementEvent(uri, localName, qName);
        this.events.add(event);
        if (this.charactersOccurred) {
            this.processSimpleElement();
        } else if (this.startOccurred) {
            if (this.attributesOccurred) {
                this.processEmptyElementWithAttributes();
            } else {
                this.processEmptyElement();
            }
        }
        if (this.levelIndex == 0 && this.parent != null) {
            XMLReader xmlReader = this.parent.getXMLReader();
            xmlReader.setContentHandler(this.parent);
            xmlReader.setLexicalHandler(this.parent);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        DocumentLocatorEvent event = new DocumentLocatorEvent(locator);
        this.events.add(event);
    }

    @Override
    public void startDocument() throws SAXException {
        StartDocumentEvent event = new StartDocumentEvent();
        this.events.add(event);
    }

    @Override
    public void endDocument() throws SAXException {
        EndDocumentEvent event = new EndDocumentEvent();
        this.events.add(event);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersOccurred = true;
        CharactersEvent event = new CharactersEvent(ch, start, length);
        this.events.add(event);
    }

    @Override
    public void characters(CharSequence characters) {
        this.charactersOccurred = true;
        CharactersEvent event = new CharactersEvent(characters);
        this.events.add(event);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        IgnorableWhitespaceEvent event = new IgnorableWhitespaceEvent(ch, start, length);
        this.events.add(event);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        ProcessingInstructionEvent event = new ProcessingInstructionEvent(target, data);
        this.events.add(event);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        SkippedEntityEvent event = new SkippedEntityEvent(name);
        this.events.add(event);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        StartDTDEvent event = new StartDTDEvent(name, publicId, systemId);
        this.events.add(event);
    }

    @Override
    public void endDTD() throws SAXException {
        EndDTDEvent event = new EndDTDEvent();
        this.events.add(event);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        StartEntityEvent event = new StartEntityEvent(name);
        this.events.add(event);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        EndEntityEvent event = new EndEntityEvent(name);
        this.events.add(event);
    }

    @Override
    public void startCDATA() throws SAXException {
        StartCDATAEvent event = new StartCDATAEvent();
        this.events.add(event);
    }

    @Override
    public void endCDATA() throws SAXException {
        EndCDATAEvent event = new EndCDATAEvent();
        this.events.add(event);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        CommentEvent event = new CommentEvent(ch, start, length);
        this.events.add(event);
    }

    protected UnmarshalRecord getParent() {
        return this.parent;
    }

    protected List getEvents() {
        return this.events;
    }

    private static final class AttributeList
    implements Attributes {
        private String[] localNames;
        private String[] uris;
        private String[] values;
        private String[] types;
        private ArrayList<String> qNames;

        public AttributeList(int size) {
            this.qNames = new ArrayList(size);
            this.localNames = new String[size];
            this.uris = new String[size];
            this.types = new String[size];
            this.values = new String[size];
        }

        public void addAttribute(String localName, String qName, String uri, String type2, String value, int index) {
            this.qNames.add(index, qName);
            this.localNames[index] = localName;
            this.uris[index] = uri;
            this.types[index] = type2;
            this.values[index] = value;
        }

        @Override
        public String getQName(int index) {
            return this.qNames.get(index);
        }

        @Override
        public String getType(String namespaceUri, String localName) {
            int i = 0;
            while (i < this.localNames.length) {
                String nextLocalName = this.localNames[i];
                if (nextLocalName != null && localName != null && localName.equals(nextLocalName)) {
                    String uriAtIndex = this.uris[i];
                    if (uriAtIndex == null) {
                        uriAtIndex = "";
                    }
                    if (uriAtIndex.equals(namespaceUri)) {
                        return this.types[i];
                    }
                }
                ++i;
            }
            return null;
        }

        @Override
        public String getType(int index) {
            return this.types[index];
        }

        @Override
        public String getType(String qname) {
            return this.types[this.getIndex(qname)];
        }

        @Override
        public int getIndex(String qname) {
            return this.qNames.indexOf(qname);
        }

        @Override
        public int getIndex(String uri, String localName) {
            int i = 0;
            while (i < this.localNames.length) {
                String nextLocalName = this.localNames[i];
                if (nextLocalName != null && localName != null && localName.equals(nextLocalName)) {
                    String uriAtIndex = this.uris[i];
                    if (uriAtIndex == null) {
                        uriAtIndex = "";
                    }
                    if (uriAtIndex.equals(uri)) {
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.localNames.length;
        }

        @Override
        public String getLocalName(int index) {
            return this.localNames[index];
        }

        @Override
        public String getURI(int index) {
            return this.uris[index];
        }

        @Override
        public String getValue(int index) {
            return this.values[index];
        }

        @Override
        public String getValue(String qname) {
            return this.values[this.getIndex(qname)];
        }

        @Override
        public String getValue(String uri, String localName) {
            int i = 0;
            while (i < this.localNames.length) {
                String nextLocalName = this.localNames[i];
                if (nextLocalName != null && localName != null && localName.equals(nextLocalName)) {
                    String uriAtIndex = this.uris[i];
                    if (uriAtIndex == null) {
                        uriAtIndex = "";
                    }
                    if (uriAtIndex.equals(uri)) {
                        return this.values[i];
                    }
                }
                ++i;
            }
            return null;
        }
    }
}

