/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class BeanValidationHelper
extends Enum<BeanValidationHelper> {
    public static final /* enum */ BeanValidationHelper BEAN_VALIDATION_HELPER = new BeanValidationHelper();
    private static final int DEFAULT_CONSTRAINTS_QUANTITY = 25;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int KNOWN_CONSTRAINTS_DEFAULT_SIZE;
    private static final Set<String> KNOWN_CONSTRAINTS;
    private static final Map<Class<?>, Boolean> CONSTRAINTS_ON_CLASSES;
    private static final /* synthetic */ BeanValidationHelper[] ENUM$VALUES;

    static {
        ENUM$VALUES = new BeanValidationHelper[]{BEAN_VALIDATION_HELPER};
        KNOWN_CONSTRAINTS_DEFAULT_SIZE = BeanValidationHelper.nextPowerOfTwo(33);
        KNOWN_CONSTRAINTS = Collections.newSetFromMap(new ConcurrentHashMap(KNOWN_CONSTRAINTS_DEFAULT_SIZE, 0.75f));
        CONSTRAINTS_ON_CLASSES = Collections.synchronizedMap(new WeakHashMap());
        BeanValidationHelper.initializeKnownConstraints();
    }

    public boolean isConstrained(Class<?> clazz) {
        Boolean annotated = CONSTRAINTS_ON_CLASSES.get(clazz);
        if (annotated == null) {
            annotated = this.detectConstraints(clazz);
            CONSTRAINTS_ON_CLASSES.put(clazz, annotated);
        }
        return annotated;
    }

    private Boolean detectConstraints(Class<?> clazz) {
        Field[] fieldArray = this.getDeclaredFields(clazz);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Annotation[] annotationArray = f.getDeclaredAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation a = annotationArray[n4];
                Class<? extends Annotation> type2 = a.annotationType();
                String typeCanonicalName = type2.getCanonicalName();
                if (KNOWN_CONSTRAINTS.contains(typeCanonicalName)) {
                    return true;
                }
                Annotation[] annotationArray2 = type2.getAnnotations();
                int n5 = annotationArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation typesClassAnnotation = annotationArray2[n6];
                    Class<? extends Annotation> classAnnotationType = typesClassAnnotation.annotationType();
                    if ("javax.validation.Constraint".equals(classAnnotationType.getCanonicalName())) {
                        if (typeCanonicalName != null) {
                            KNOWN_CONSTRAINTS.add(typeCanonicalName);
                        }
                        return true;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private Field[] getDeclaredFields(final Class<?> clazz) {
        return PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        }) : PrivilegedAccessHelper.getDeclaredFields(clazz);
    }

    private static void initializeKnownConstraints() {
        KNOWN_CONSTRAINTS.add("javax.validation.Valid");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Max");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Min");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMax");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMin");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Digits");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.NotNull");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Pattern");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Size");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertTrue");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertFalse");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Future");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.Past");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Max");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Min");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.DecimalMax");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.DecimalMin");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Digits");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.NotNull");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Pattern");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Size");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.AssertTrue");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.AssertFalse");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Future");
        KNOWN_CONSTRAINTS.add("javax.validation.constraints.List.Past");
    }

    private static int nextPowerOfTwo(int x) {
        assert (x > 0);
        x = x-- | x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static BeanValidationHelper[] values() {
        BeanValidationHelper[] beanValidationHelperArray = ENUM$VALUES;
        int n = beanValidationHelperArray.length;
        BeanValidationHelper[] beanValidationHelperArray2 = new BeanValidationHelper[n];
        System.arraycopy(ENUM$VALUES, 0, beanValidationHelperArray2, 0, n);
        return beanValidationHelperArray2;
    }

    public static BeanValidationHelper valueOf(String string) {
        return Enum.valueOf(BeanValidationHelper.class, string);
    }
}

