/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JasperTagInfo;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.servlet.JspServletWrapper;

class TagFileProcessor {
    private ArrayList<Compiler> tempVector;

    TagFileProcessor() {
    }

    public static TagInfo parseTagFileDirectives(ParserController pc, String name, String path, TagLibraryInfo tagLibInfo) throws JasperException {
        ErrorDispatcher err = pc.getCompiler().getErrorDispatcher();
        Node.Nodes page = null;
        try {
            page = pc.parseTagFileDirectives(path);
        }
        catch (FileNotFoundException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        catch (IOException e) {
            err.jspError("jsp.error.file.not.found", path);
        }
        TagFileDirectiveVisitor tagFileVisitor = new TagFileDirectiveVisitor(pc.getCompiler(), tagLibInfo, name, path);
        page.visit(tagFileVisitor);
        tagFileVisitor.postCheck();
        return tagFileVisitor.getTagInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadTagFile(Compiler compiler, String tagFilePath, TagInfo tagInfo, PageInfo parentPageInfo) throws JasperException {
        JspRuntimeContext rctxt;
        JspCompilationContext ctxt = compiler.getCompilationContext();
        JspRuntimeContext jspRuntimeContext = rctxt = ctxt.getRuntimeContext();
        synchronized (jspRuntimeContext) {
            Class tagClazz;
            JspServletWrapper wrapper = rctxt.getWrapper(tagFilePath);
            if (wrapper == null) {
                wrapper = new JspServletWrapper(ctxt.getServletContext(), ctxt.getOptions(), tagFilePath, tagInfo, ctxt.getRuntimeContext(), ctxt.getTagFileJarUrls().get(tagFilePath));
                rctxt.addWrapper(tagFilePath, wrapper);
                wrapper.getJspEngineContext().setClassLoader((URLClassLoader)ctxt.getClassLoader());
                wrapper.getJspEngineContext().setClassPath(ctxt.getClassPath());
            } else {
                wrapper.getJspEngineContext().setTagInfo(tagInfo);
            }
            int tripCount = wrapper.incTripCount();
            try {
                if (tripCount > 0) {
                    JspServletWrapper tempWrapper = new JspServletWrapper(ctxt.getServletContext(), ctxt.getOptions(), tagFilePath, tagInfo, ctxt.getRuntimeContext(), ctxt.getTagFileJarUrls().get(tagFilePath));
                    tagClazz = tempWrapper.loadTagFilePrototype();
                    this.tempVector.add(tempWrapper.getJspEngineContext().getCompiler());
                } else {
                    tagClazz = wrapper.loadTagFile();
                }
            }
            finally {
                wrapper.decTripCount();
            }
            try {
                Object tagIns = tagClazz.newInstance();
                if (tagIns instanceof JspSourceDependent) {
                    for (String dependant : ((JspSourceDependent)tagIns).getDependants()) {
                        parentPageInfo.addDependant(dependant);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return tagClazz;
        }
    }

    public void loadTagFiles(Compiler compiler, Node.Nodes page) throws JasperException {
        this.tempVector = new ArrayList();
        page.visit(new TagFileLoaderVisitor(compiler));
    }

    public void removeProtoTypeFiles(String classFileName) {
        for (Compiler c : this.tempVector) {
            if (classFileName == null) {
                c.removeGeneratedClassFiles();
                continue;
            }
            if (!classFileName.equals(c.getCompilationContext().getClassFileName())) continue;
            c.removeGeneratedClassFiles();
            this.tempVector.remove(c);
            return;
        }
    }

    private class TagFileLoaderVisitor
    extends Node.Visitor {
        private Compiler compiler;
        private PageInfo pageInfo;

        TagFileLoaderVisitor(Compiler compiler) {
            this.compiler = compiler;
            this.pageInfo = compiler.getPageInfo();
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            TagFileInfo tagFileInfo = n.getTagFileInfo();
            if (tagFileInfo != null) {
                String tagFilePath = tagFileInfo.getPath();
                if (tagFilePath.startsWith("/META-INF/")) {
                    String[] location = this.compiler.getCompilationContext().getTldLocation(tagFileInfo.getTagInfo().getTagLibrary().getURI());
                    this.pageInfo.addDependant("jar:" + location[0] + "!/" + location[1]);
                    this.pageInfo.addDependant("jar:" + location[0] + "!" + tagFilePath);
                } else {
                    this.pageInfo.addDependant(tagFilePath);
                }
                Class c = TagFileProcessor.this.loadTagFile(this.compiler, tagFilePath, n.getTagInfo(), this.pageInfo);
                n.setTagHandlerClass(c);
            }
            this.visitBody(n);
        }
    }

    private static class TagFileDirectiveVisitor
    extends Node.Visitor {
        private static final JspUtil.ValidAttribute[] tagDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("display-name"), new JspUtil.ValidAttribute("body-content"), new JspUtil.ValidAttribute("dynamic-attributes"), new JspUtil.ValidAttribute("small-icon"), new JspUtil.ValidAttribute("large-icon"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("example"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces")};
        private static final JspUtil.ValidAttribute[] attributeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("required"), new JspUtil.ValidAttribute("fragment"), new JspUtil.ValidAttribute("rtexprvalue"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("description"), new JspUtil.ValidAttribute("deferredValue"), new JspUtil.ValidAttribute("deferredValueType"), new JspUtil.ValidAttribute("deferredMethod"), new JspUtil.ValidAttribute("deferredMethodSignature")};
        private static final JspUtil.ValidAttribute[] variableDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name-given"), new JspUtil.ValidAttribute("name-from-attribute"), new JspUtil.ValidAttribute("alias"), new JspUtil.ValidAttribute("variable-class"), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("declare"), new JspUtil.ValidAttribute("description")};
        private ErrorDispatcher err;
        private TagLibraryInfo tagLibInfo;
        private String name = null;
        private String path = null;
        private TagExtraInfo tei = null;
        private String bodycontent = null;
        private String description = null;
        private String displayName = null;
        private String smallIcon = null;
        private String largeIcon = null;
        private String dynamicAttrsMapName;
        private String example = null;
        private List<TagAttributeInfo> attributeVector;
        private List<TagVariableInfo> variableVector;
        private HashMap<String, NameEntry> nameTable = new HashMap();
        private HashMap<String, NameEntry> nameFromTable = new HashMap();
        private Double jspVersionDouble;

        public TagFileDirectiveVisitor(Compiler compiler, TagLibraryInfo tagLibInfo, String name, String path) {
            this.err = compiler.getErrorDispatcher();
            this.tagLibInfo = tagLibInfo;
            this.name = name;
            this.path = path;
            this.attributeVector = new ArrayList<TagAttributeInfo>();
            this.variableVector = new ArrayList<TagVariableInfo>();
            this.jspVersionDouble = Double.valueOf(tagLibInfo.getRequiredVersion());
        }

        @Override
        public void visit(Node.JspRoot n) throws JasperException {
            String jspRootVersion = n.getTextAttribute("version");
            if (jspRootVersion == null) {
                this.err.jspError((Node)n, "jsp.error.mandatory.attribute", n.getQName(), "version");
            }
            if (!jspRootVersion.equals(this.jspVersionDouble.toString())) {
                this.err.jspError((Node)n, "jsp.error.tagfile.jspVersionMismatch", jspRootVersion, this.jspVersionDouble.toString());
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.TagDirective n) throws JasperException {
            JspUtil.checkAttributes("Tag directive", n, tagDirectiveAttrs, this.err);
            this.bodycontent = this.checkConflict(n, this.bodycontent, "body-content");
            if (!(this.bodycontent == null || this.bodycontent.equals("empty") || this.bodycontent.equals("tagdependent") || this.bodycontent.equals("scriptless"))) {
                this.err.jspError((Node)n, "jsp.error.tagdirective.badbodycontent", this.bodycontent);
            }
            this.dynamicAttrsMapName = this.checkConflict(n, this.dynamicAttrsMapName, "dynamic-attributes");
            if (this.dynamicAttrsMapName != null) {
                this.checkUniqueName(this.dynamicAttrsMapName, Name.TAG_DYNAMIC, n);
            }
            this.smallIcon = this.checkConflict(n, this.smallIcon, "small-icon");
            this.largeIcon = this.checkConflict(n, this.largeIcon, "large-icon");
            this.description = this.checkConflict(n, this.description, "description");
            this.displayName = this.checkConflict(n, this.displayName, "display-name");
            this.example = this.checkConflict(n, this.example, "example");
            if (n.getAttributeValue("deferredSyntaxAllowedAsLiteral") != null && Double.compare(this.jspVersionDouble, Constants.JSP_VERSION_2_1) < 0) {
                this.err.jspError("jsp.error.invalidTagDirectiveAttrUnless21", "deferredSyntaxAllowedAsLiteral");
            }
        }

        private String checkConflict(Node n, String oldAttrValue, String attr) throws JasperException {
            String result = oldAttrValue;
            String attrValue = n.getAttributeValue(attr);
            if (attrValue != null) {
                if (oldAttrValue != null && !oldAttrValue.equals(attrValue)) {
                    this.err.jspError(n, "jsp.error.tag.conflict.attr", attr, oldAttrValue, attrValue);
                }
                result = attrValue;
            }
            return result;
        }

        @Override
        public void visit(Node.AttributeDirective n) throws JasperException {
            JspUtil.checkAttributes("Attribute directive", n, attributeDirectiveAttrs, this.err);
            String attrName = n.getAttributeValue("name");
            boolean required = JspUtil.booleanValue(n.getAttributeValue("required"));
            boolean rtexprvalue = true;
            String rtexprvalueString = n.getAttributeValue("rtexprvalue");
            if (rtexprvalueString != null) {
                rtexprvalue = JspUtil.booleanValue(rtexprvalueString);
            }
            boolean fragment = JspUtil.booleanValue(n.getAttributeValue("fragment"));
            String type2 = n.getAttributeValue("type");
            String deferredValue = n.getAttributeValue("deferredValue");
            String deferredMethod = n.getAttributeValue("deferredMethod");
            String expectedType = n.getAttributeValue("deferredValueType");
            String methodSignature = n.getAttributeValue("deferredMethodSignature");
            if (Double.compare(this.jspVersionDouble, Constants.JSP_VERSION_2_1) < 0) {
                if (deferredValue != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredValue");
                }
                if (deferredMethod != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredMethod");
                }
                if (expectedType != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredValueType");
                }
                if (methodSignature != null) {
                    this.err.jspError("jsp.error.invalidAttrDirectiveAttrUnless21", "deferredMethodSignature");
                }
            }
            boolean isDeferredValue = JspUtil.booleanValue(deferredValue);
            boolean isDeferredMethod = JspUtil.booleanValue(deferredMethod);
            if (expectedType == null) {
                if (isDeferredValue) {
                    expectedType = "java.lang.Object";
                }
            } else {
                if (deferredValue != null && !isDeferredValue) {
                    this.err.jspError("jsp.error.deferredvaluewithtype");
                }
                isDeferredValue = true;
            }
            if (methodSignature == null) {
                if (isDeferredMethod) {
                    methodSignature = "void method()";
                }
            } else {
                if (deferredMethod != null && !isDeferredMethod) {
                    this.err.jspError("jsp.error.deferredmethodwithsignature");
                }
                isDeferredMethod = true;
            }
            if (fragment) {
                if (type2 != null) {
                    this.err.jspError(n, "jsp.error.fragmentwithtype");
                }
                rtexprvalue = true;
                if (rtexprvalueString != null) {
                    this.err.jspError(n, "jsp.error.frgmentwithrtexprvalue");
                }
            } else if (type2 == null) {
                type2 = isDeferredValue ? "javax.el.ValueExpression" : (isDeferredMethod ? "javax.el.MethodExpression" : "java.lang.String");
            } else if (isDeferredValue || isDeferredMethod) {
                this.err.jspError("jsp.error.deferredwithtype");
            }
            if (isDeferredValue || isDeferredMethod) {
                rtexprvalue = false;
            }
            TagAttributeInfo tagAttributeInfo = new TagAttributeInfo(attrName, required, type2, rtexprvalue, fragment, this.description, isDeferredValue, isDeferredMethod, expectedType, methodSignature);
            this.attributeVector.add(tagAttributeInfo);
            this.checkUniqueName(attrName, Name.ATTR_NAME, n, tagAttributeInfo);
        }

        @Override
        public void visit(Node.VariableDirective n) throws JasperException {
            String className;
            JspUtil.checkAttributes("Variable directive", n, variableDirectiveAttrs, this.err);
            String nameGiven = n.getAttributeValue("name-given");
            String nameFromAttribute = n.getAttributeValue("name-from-attribute");
            if (nameGiven == null && nameFromAttribute == null) {
                this.err.jspError("jsp.error.variable.either.name");
            }
            if (nameGiven != null && nameFromAttribute != null) {
                this.err.jspError("jsp.error.variable.both.name");
            }
            String alias = n.getAttributeValue("alias");
            if (nameFromAttribute != null && alias == null || nameFromAttribute == null && alias != null) {
                this.err.jspError("jsp.error.variable.alias");
            }
            if ((className = n.getAttributeValue("variable-class")) == null) {
                className = "java.lang.String";
            }
            String declareStr = n.getAttributeValue("declare");
            boolean declare = true;
            if (declareStr != null) {
                declare = JspUtil.booleanValue(declareStr);
            }
            int scope = 0;
            String scopeStr = n.getAttributeValue("scope");
            if (scopeStr != null && !"NESTED".equals(scopeStr)) {
                if ("AT_BEGIN".equals(scopeStr)) {
                    scope = 1;
                } else if ("AT_END".equals(scopeStr)) {
                    scope = 2;
                }
            }
            if (nameFromAttribute != null) {
                nameGiven = alias;
                this.checkUniqueName(nameFromAttribute, Name.VAR_NAME_FROM, n);
                this.checkUniqueName(alias, Name.VAR_ALIAS, n);
            } else {
                this.checkUniqueName(nameGiven, Name.VAR_NAME_GIVEN, n);
            }
            this.variableVector.add(new TagVariableInfo(nameGiven, nameFromAttribute, className, declare, scope));
        }

        public TagInfo getTagInfo() throws JasperException {
            if (this.name == null) {
                // empty if block
            }
            if (this.bodycontent == null) {
                this.bodycontent = "scriptless";
            }
            String tagClassName = JspUtil.getTagHandlerClassName(this.path, this.err);
            TagVariableInfo[] tagVariableInfos = this.variableVector.toArray(new TagVariableInfo[0]);
            TagAttributeInfo[] tagAttributeInfo = this.attributeVector.toArray(new TagAttributeInfo[0]);
            return new JasperTagInfo(this.name, tagClassName, this.bodycontent, this.description, this.tagLibInfo, this.tei, tagAttributeInfo, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfos, this.dynamicAttrsMapName);
        }

        private void checkUniqueName(String name, Name type2, Node n) throws JasperException {
            this.checkUniqueName(name, type2, n, null);
        }

        private void checkUniqueName(String name, Name type2, Node n, TagAttributeInfo attr) throws JasperException {
            HashMap<String, NameEntry> table = type2 == Name.VAR_NAME_FROM ? this.nameFromTable : this.nameTable;
            NameEntry nameEntry = table.get(name);
            if (nameEntry != null) {
                if (type2 != Name.TAG_DYNAMIC || nameEntry.getType() != Name.TAG_DYNAMIC) {
                    int line = nameEntry.getNode().getStart().getLineNumber();
                    this.err.jspError(n, "jsp.error.tagfile.nameNotUnique", type2.getAttribute(), type2.getDirective(), nameEntry.getType().getAttribute(), nameEntry.getType().getDirective(), Integer.toString(line));
                }
            } else {
                table.put(name, new NameEntry(type2, n, attr));
            }
        }

        void postCheck() throws JasperException {
            for (String nameFrom : this.nameFromTable.keySet()) {
                NameEntry nameEntry = this.nameTable.get(nameFrom);
                NameEntry nameFromEntry = this.nameFromTable.get(nameFrom);
                Node nameFromNode = nameFromEntry.getNode();
                if (nameEntry == null) {
                    this.err.jspError(nameFromNode, "jsp.error.tagfile.nameFrom.noAttribute", nameFrom);
                    continue;
                }
                Node node = nameEntry.getNode();
                TagAttributeInfo tagAttr = nameEntry.getTagAttributeInfo();
                if ("java.lang.String".equals(tagAttr.getTypeName()) && tagAttr.isRequired() && !tagAttr.canBeRequestTime()) continue;
                this.err.jspError(nameFromNode, "jsp.error.tagfile.nameFrom.badAttribute", nameFrom, Integer.toString(node.getStart().getLineNumber()));
            }
        }

        static class NameEntry {
            private Name type;
            private Node node;
            private TagAttributeInfo attr;

            NameEntry(Name type2, Node node, TagAttributeInfo attr) {
                this.type = type2;
                this.node = node;
                this.attr = attr;
            }

            Name getType() {
                return this.type;
            }

            Node getNode() {
                return this.node;
            }

            TagAttributeInfo getTagAttributeInfo() {
                return this.attr;
            }
        }

        private static enum Name {
            ATTR_NAME("name", "attribute"),
            VAR_NAME_GIVEN("name-given", "variable"),
            VAR_NAME_FROM("name-from-attribute", "variable"),
            VAR_ALIAS("alias", "variable"),
            TAG_DYNAMIC("dynamic-attributes", "tag");

            private String attribute;
            private String directive;

            String getAttribute() {
                return this.attribute;
            }

            String getDirective() {
                return this.directive;
            }

            private Name(String attribute, String directive) {
                this.attribute = attribute;
                this.directive = directive;
            }
        }
    }
}

