/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

public class FloatingPoint {
    public static final int IEEE_754_FLOATING_POINT = 72;

    private FloatingPoint() {
    }

    private static final int convertFromByteToInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static final long convertFromByteToLong(byte[] byArray, int n) {
        return ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final float getFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(FloatingPoint.convertFromByteToInt(byArray, n));
    }

    public static final double getDouble(byte[] byArray, int n) {
        return Double.longBitsToDouble(FloatingPoint.convertFromByteToLong(byArray, n));
    }
}

