/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.logging.annotation.LogMessageInfo;

final class StandardWrapperValve
extends ValveBase {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="This application is not currently available", level="WARNING")
    public static final String APP_UNAVAILABLE = "AS-WEB-CORE-00274";
    @LogMessageInfo(message="Servlet {0} is currently unavailable", level="WARNING")
    public static final String SERVLET_UNAVAILABLE = "AS-WEB-CORE-00275";
    @LogMessageInfo(message="Servlet {0} is not available", level="WARNING")
    public static final String SERVLET_NOT_FOUND = "AS-WEB-CORE-00276";
    @LogMessageInfo(message="Allocate exception for servlet {0}", level="WARNING")
    public static final String SERVLET_ALLOCATE_EXCEPTION = "AS-WEB-CORE-00277";
    @LogMessageInfo(message="Exception for sending acknowledgment of a request: {0}", level="WARNING")
    public static final String SEND_ACKNOWLEDGEMENT_EXCEPTION = "AS-WEB-CORE-00278";
    @LogMessageInfo(message="Servlet.service() for servlet {0} threw exception", level="WARNING")
    public static final String SERVLET_SERVICE_EXCEPTION = "AS-WEB-CORE-00279";
    @LogMessageInfo(message="Release filters exception for servlet {0}", level="WARNING")
    public static final String RELEASE_FILTERS_EXCEPTION = "AS-WEB-CORE-00280";
    @LogMessageInfo(message="Deallocate exception for servlet {0}", level="WARNING")
    public static final String DEALLOCATE_EXCEPTION = "AS-WEB-CORE-00281";
    @LogMessageInfo(message="Servlet {0} threw unload() exception", level="WARNING")
    public static final String SERVLET_UNLOAD_EXCEPTION = "AS-WEB-CORE-00282";
    @LogMessageInfo(message="StandardWrapperValve[{0}]: {1}", level="INFO")
    public static final String STANDARD_WRAPPER_VALVE = "AS-WEB-CORE-00283";

    StandardWrapperValve() {
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        block41: {
            String msg;
            StandardWrapper wrapper;
            Servlet servlet;
            Throwable throwable;
            block40: {
                block39: {
                    boolean unavailable = false;
                    throwable = null;
                    servlet = null;
                    wrapper = (StandardWrapper)this.getContainer();
                    Context context = (Context)wrapper.getParent();
                    HttpRequest hrequest = (HttpRequest)request;
                    RequestFacade hreq = (RequestFacade)request.getRequest(true);
                    HttpServletResponse hres = (HttpServletResponse)response.getResponse();
                    if (!context.getAvailable()) {
                        hres.sendError(503);
                        response.setDetailMessage(rb.getString(APP_UNAVAILABLE));
                        unavailable = true;
                    }
                    if (!unavailable && wrapper.isUnavailable()) {
                        String msg2 = MessageFormat.format(rb.getString(SERVLET_UNAVAILABLE), wrapper.getName());
                        this.log(msg2);
                        if (hres != null) {
                            long available = wrapper.getAvailable();
                            if (available > 0L && available < Long.MAX_VALUE) {
                                hres.setDateHeader("Retry-After", available);
                                hres.sendError(503);
                                response.setDetailMessage(msg2);
                            } else if (available == Long.MAX_VALUE) {
                                hres.sendError(404);
                                msg2 = MessageFormat.format(rb.getString(SERVLET_NOT_FOUND), wrapper.getName());
                                response.setDetailMessage(msg2);
                            }
                        }
                        unavailable = true;
                    }
                    try {
                        if (!unavailable) {
                            servlet = wrapper.allocate();
                        }
                    }
                    catch (UnavailableException e) {
                        String msg3;
                        if (e.isPermanent()) {
                            hres.sendError(404);
                            msg3 = MessageFormat.format(rb.getString(SERVLET_NOT_FOUND), wrapper.getName());
                            response.setDetailMessage(msg3);
                        } else {
                            hres.setDateHeader("Retry-After", e.getUnavailableSeconds());
                            hres.sendError(503);
                            msg3 = MessageFormat.format(rb.getString(SERVLET_UNAVAILABLE), wrapper.getName());
                            response.setDetailMessage(msg3);
                        }
                    }
                    catch (ServletException e) {
                        String msg4 = MessageFormat.format(rb.getString(SERVLET_ALLOCATE_EXCEPTION), wrapper.getName());
                        this.log(msg4, StandardWrapper.getRootCause(e));
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    catch (Throwable e) {
                        String msg5 = MessageFormat.format(rb.getString(SERVLET_ALLOCATE_EXCEPTION), wrapper.getName());
                        this.log(msg5, e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    try {
                        response.sendAcknowledgement();
                    }
                    catch (IOException e) {
                        String msg6 = MessageFormat.format(rb.getString(SEND_ACKNOWLEDGEMENT_EXCEPTION), wrapper.getName());
                        this.log(msg6, e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        String msg7 = MessageFormat.format(rb.getString(SEND_ACKNOWLEDGEMENT_EXCEPTION), wrapper.getName());
                        this.log(msg7, e);
                        throwable = e;
                        this.exception(request, response, e);
                        servlet = null;
                    }
                    DataChunk requestPathMB = hrequest.getRequestPathMB();
                    hreq.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", requestPathMB);
                    ApplicationFilterFactory factory = ApplicationFilterFactory.getInstance();
                    ApplicationFilterChain filterChain = factory.createFilterChain((ServletRequest)((Object)request), wrapper, servlet);
                    try {
                        String jspFile = wrapper.getJspFile();
                        if (jspFile != null) {
                            hreq.setAttribute("org.apache.catalina.jsp_file", jspFile);
                        }
                        if (servlet != null) {
                            if (filterChain != null) {
                                filterChain.setWrapper(wrapper);
                                filterChain.doFilter(hreq, hres);
                            } else {
                                wrapper.service(hreq, hres, servlet);
                            }
                        }
                    }
                    catch (ClientAbortException e) {
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (IOException e) {
                        msg = MessageFormat.format(rb.getString(SERVLET_SERVICE_EXCEPTION), wrapper.getName());
                        this.log(msg, e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (UnavailableException e) {
                        msg = MessageFormat.format(rb.getString(SERVLET_SERVICE_EXCEPTION), wrapper.getName());
                        this.log(msg, e);
                        wrapper.unavailable(e);
                        long available = wrapper.getAvailable();
                        if (available > 0L && available < Long.MAX_VALUE) {
                            hres.setDateHeader("Retry-After", available);
                            hres.sendError(503);
                            String msgServletUnavailable = MessageFormat.format(rb.getString(SERVLET_UNAVAILABLE), wrapper.getName());
                            response.setDetailMessage(msgServletUnavailable);
                        } else if (available == Long.MAX_VALUE) {
                            hres.sendError(404);
                            String msgServletNotFound = MessageFormat.format(rb.getString(SERVLET_NOT_FOUND), wrapper.getName());
                            response.setDetailMessage(msgServletNotFound);
                        }
                    }
                    catch (ServletException e) {
                        Throwable rootCause = StandardWrapper.getRootCause(e);
                        if (!(rootCause instanceof ClientAbortException)) {
                            String msg8 = MessageFormat.format(rb.getString(SERVLET_SERVICE_EXCEPTION), wrapper.getName());
                            this.log(msg8, rootCause);
                        }
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    catch (Throwable e) {
                        msg = MessageFormat.format(rb.getString(SERVLET_SERVICE_EXCEPTION), wrapper.getName());
                        this.log(msg, e);
                        throwable = e;
                        this.exception(request, response, e);
                    }
                    try {
                        if (filterChain != null) {
                            filterChain.release();
                        }
                    }
                    catch (Throwable e) {
                        msg = MessageFormat.format(rb.getString(RELEASE_FILTERS_EXCEPTION), wrapper.getName());
                        this.log(msg, e);
                        if (throwable != null) break block39;
                        throwable = e;
                        this.exception(request, response, e);
                    }
                }
                try {
                    if (servlet != null) {
                        wrapper.deallocate(servlet);
                    }
                }
                catch (Throwable e) {
                    msg = MessageFormat.format(rb.getString(DEALLOCATE_EXCEPTION), wrapper.getName());
                    this.log(msg, e);
                    if (throwable != null) break block40;
                    throwable = e;
                    this.exception(request, response, e);
                }
            }
            try {
                if (servlet != null && wrapper.getAvailable() == Long.MAX_VALUE) {
                    wrapper.unload();
                }
            }
            catch (Throwable e) {
                msg = MessageFormat.format(rb.getString(SERVLET_UNLOAD_EXCEPTION), wrapper.getName());
                this.log(msg, e);
                if (throwable != null) break block41;
                this.exception(request, response, e);
            }
        }
        return 2;
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        this.invoke((Request)request, (Response)response);
    }

    private void log(String message) {
        Logger logger2 = null;
        String containerName = null;
        if (this.container != null) {
            logger2 = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger2 != null) {
            logger2.log("StandardWrapperValve[" + containerName + "]: " + message);
        } else if (log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, STANDARD_WRAPPER_VALVE, new Object[]{containerName, message});
        }
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        String containerName = null;
        if (this.container != null) {
            logger2 = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger2 != null) {
            logger2.log("StandardWrapperValve[" + containerName + "]: " + message, t, 2);
        } else {
            String msg = MessageFormat.format(rb.getString(STANDARD_WRAPPER_VALVE), containerName, message);
            log.log(Level.WARNING, msg, t);
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        ServletRequest sreq = request.getRequest();
        sreq.setAttribute("javax.servlet.error.exception", exception);
        ServletResponse sresponse = response.getResponse();
        ((HttpServletResponse)sresponse).setStatus(500);
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        return null;
    }
}

