/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.naming.resources.ProxyDirContext;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.valve.GlassFishValve;

public abstract class ContainerBase
implements Container,
Lifecycle,
Pipeline {
    protected static final java.util.logging.Logger log = StandardServer.log;
    protected static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="ContainerBase.setLoader: stop: ", level="SEVERE", cause="Could not stop previous loader", action="Verify previous loader")
    public static final String CONTAINER_BASE_SET_LOADER_STOP = "AS-WEB-CORE-00099";
    @LogMessageInfo(message="ContainerBase.setLoader: start:", level="SEVERE", cause="Could not start new loader", action="Verify the configuration of container")
    public static final String CONTAINER_BASE_SET_LOADER_START = "AS-WEB-CORE-00100";
    @LogMessageInfo(message="ContainerBase.setLogger: stop: ", level="SEVERE", cause="Could not stop previous logger", action="Verify previous logger")
    public static final String CONTAINER_BASE_SET_LOGGER_STOP = "AS-WEB-CORE-00101";
    @LogMessageInfo(message="ContainerBase.setLogger: start: ", level="SEVERE", cause="Could not start new logger", action="Verify the configuration of container")
    public static final String CONTAINER_BASE_SET_LOGGER_START = "AS-WEB-CORE-00102";
    @LogMessageInfo(message="ContainerBase.setManager: stop: ", level="SEVERE", cause="Could not stop previous manager", action="Verify previous manager")
    public static final String CONTAINER_BASE_SET_MANAGER_STOP = "AS-WEB-CORE-00103";
    @LogMessageInfo(message="ContainerBase.setManager: start: ", level="SEVERE", cause="Could not start new manager", action="Verify the configuration of container")
    public static final String CONTAINER_BASE_SET_MANAGER_START = "AS-WEB-CORE-00104";
    @LogMessageInfo(message="ContainerBase.setRealm: stop: ", level="SEVERE", cause="Could not stop previous realm", action="Verify previous realm")
    public static final String CONTAINER_BASE_SET_REALM_STOP = "AS-WEB-CORE-00105";
    @LogMessageInfo(message="ContainerBase.setRealm: start: ", level="SEVERE", cause="Could not start new realm", action="Verify the configuration of container")
    public static final String CONTAINER_BASE_SET_REALM_START = "AS-WEB-CORE-00106";
    @LogMessageInfo(message="addChild: Child name {0} is not unique", level="WARNING")
    public static final String DUPLICATE_CHILD_NAME_EXCEPTION = "AS-WEB-CORE-00107";
    @LogMessageInfo(message="ContainerBase.addChild: start: ", level="SEVERE", cause="Could not start new child container", action="Verify the configuration of parent container")
    public static final String CONTAINER_BASE_ADD_CHILD_START = "AS-WEB-CORE-00108";
    @LogMessageInfo(message="ContainerBase.removeChild: stop: ", level="SEVERE", cause="Could not stop existing child container", action="Verify existing child container")
    public static final String CONTAINER_BASE_REMOVE_CHILD_STOP = "AS-WEB-CORE-00109";
    @LogMessageInfo(message="Container {0} has already been started", level="INFO")
    public static final String CONTAINER_STARTED = "AS-WEB-CORE-00110";
    @LogMessageInfo(message="Container {0} has not been started", level="SEVERE", cause="Current container has not been started", action="Verify the current container")
    public static final String CONTAINER_NOT_STARTED_EXCEPTION = "AS-WEB-CORE-00111";
    @LogMessageInfo(message="Error stopping container {0}", level="SEVERE", cause="Could not stop child container", action="Verify the existence of current child container")
    public static final String ERROR_STOPPING_CONTAINER = "AS-WEB-CORE-00112";
    @LogMessageInfo(message="Error unregistering ", level="SEVERE", cause="Could not unregister current container", action="Verify if the container has been registered")
    public static final String ERROR_UNREGISTERING = "AS-WEB-CORE-00113";
    @LogMessageInfo(message="Exception invoking periodic operation: ", level="SEVERE", cause="Could not set the context ClassLoader", action="Verify the security permission")
    public static final String EXCEPTION_INVOKES_PERIODIC_OP = "AS-WEB-CORE-00114";
    protected Map<String, Container> children = new LinkedHashMap<String, Container>();
    protected int debug = 0;
    protected int backgroundProcessorDelay = -1;
    protected boolean checkIfRequestIsSecure = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected ArrayList<ContainerListener> listeners = new ArrayList();
    private ContainerListener[] listenersArray = new ContainerListener[0];
    protected Loader loader = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();
    protected Logger logger = null;
    protected Manager manager = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    protected boolean hasCustomPipeline = false;
    protected Realm realm = null;
    protected DirContext resources = null;
    protected volatile boolean started = false;
    protected boolean initialized = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private volatile boolean threadDone = false;
    protected boolean notifyContainerListeners = true;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName controller;

    boolean isNotifyContainerListeners() {
        return this.notifyContainerListeners;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    @Override
    public int getBackgroundProcessorDelay() {
        return this.backgroundProcessorDelay;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    @Override
    public String getInfo() {
        return this.getClass().getName();
    }

    @Override
    public Loader getLoader() {
        try {
            this.readLock.lock();
            if (this.loader != null) {
                Loader loader = this.loader;
                return loader;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoader(Loader loader) {
        Loader oldLoader;
        try {
            this.writeLock.lock();
            oldLoader = this.loader;
            if (oldLoader == loader) {
                return;
            }
            this.loader = loader;
            if (this.started && oldLoader != null && oldLoader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldLoader)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_LOADER_STOP, e);
                }
            }
            if (loader != null) {
                loader.setContainer(this);
            }
            if (this.started && loader != null && loader instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)loader)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_LOADER_START, e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    @Override
    public Logger getLogger() {
        try {
            this.readLock.lock();
            if (this.logger != null) {
                Logger logger2 = this.logger;
                return logger2;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogger(Logger logger2) {
        Logger oldLogger;
        try {
            this.writeLock.lock();
            oldLogger = this.logger;
            if (oldLogger == logger2) {
                return;
            }
            this.logger = logger2;
            if (this.started && oldLogger != null && oldLogger instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldLogger)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_LOGGER_STOP, e);
                }
            }
            if (logger2 != null) {
                logger2.setContainer(this);
            }
            if (this.started && logger2 != null && logger2 instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)logger2)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_LOGGER_START, e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    @Override
    public Manager getManager() {
        try {
            this.readLock.lock();
            if (this.manager != null) {
                Manager manager = this.manager;
                return manager;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManager(Manager manager) {
        Manager oldManager;
        try {
            this.writeLock.lock();
            oldManager = this.manager;
            if (oldManager == manager) {
                return;
            }
            this.manager = manager;
            if (this.started && oldManager != null && oldManager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldManager)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_MANAGER_STOP, e);
                }
            }
            if (manager != null) {
                manager.setContainer(this);
            }
            if (this.started && manager != null && manager instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)manager)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_MANAGER_START, e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Object getMappingObject() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    @Override
    public Container getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean hasCustomPipeline() {
        return this.hasCustomPipeline;
    }

    @Override
    public boolean isCheckIfRequestIsSecure() {
        return this.checkIfRequestIsSecure;
    }

    @Override
    public void setCheckIfRequestIsSecure(boolean checkIfRequestIsSecure) {
        this.checkIfRequestIsSecure = checkIfRequestIsSecure;
    }

    @Override
    public Realm getRealm() {
        try {
            this.readLock.lock();
            if (this.realm != null) {
                Realm realm = this.realm;
                return realm;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRealm(Realm realm) {
        Realm oldRealm;
        try {
            this.writeLock.lock();
            oldRealm = this.realm;
            if (oldRealm == realm) {
                return;
            }
            this.realm = realm;
            if (this.started && oldRealm != null && oldRealm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldRealm)).stop();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_REALM_STOP, e);
                }
            }
            if (realm != null) {
                realm.setContainer(this);
            }
            if (this.started && realm != null && realm instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)realm)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_SET_REALM_START, e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    @Override
    public DirContext getResources() {
        try {
            this.readLock.lock();
            if (this.resources != null) {
                DirContext dirContext = this.resources;
                return dirContext;
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResources(DirContext resources) throws Exception {
        DirContext oldResources;
        try {
            this.writeLock.lock();
            oldResources = this.resources;
            if (oldResources == resources) {
                return;
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (this.getParent() != null) {
                env.put("host", this.getParent().getName());
            }
            env.put("context", this.getName());
            this.resources = new ProxyDirContext(env, resources);
        }
        finally {
            this.writeLock.unlock();
        }
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    @Override
    public void addChild(Container child) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container child) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Add child " + child + " " + this);
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            if (this.children.get(child.getName()) != null) {
                String msg = MessageFormat.format(rb.getString(DUPLICATE_CHILD_NAME_EXCEPTION), child.getName());
                throw new IllegalArgumentException(msg);
            }
            child.setParent(this);
            if (this.started && child instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)child)).start();
                }
                catch (LifecycleException e) {
                    log.log(Level.SEVERE, CONTAINER_BASE_ADD_CHILD_START, e);
                    throw new IllegalStateException(rb.getString(CONTAINER_BASE_ADD_CHILD_START) + e);
                }
            }
            this.children.put(child.getName(), child);
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("addChild", child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            this.listenersArray = this.listeners.toArray(new ContainerListener[this.listeners.size()]);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            return this.children.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container[] findChildren() {
        Map<String, Container> map = this.children;
        synchronized (map) {
            return this.children.values().toArray(new Container[this.children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerListener[] findContainerListeners() {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listenersArray;
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.invoke(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(Container child) {
        if (child == null) {
            return;
        }
        Map<String, Container> map = this.children;
        synchronized (map) {
            if (this.children.get(child.getName()) == null) {
                return;
            }
            this.children.remove(child.getName());
        }
        if (this.started && child instanceof Lifecycle) {
            try {
                if (child instanceof ContainerBase) {
                    if (((ContainerBase)child).started) {
                        ((Lifecycle)((Object)child)).stop();
                    }
                } else {
                    ((Lifecycle)((Object)child)).stop();
                }
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, CONTAINER_BASE_REMOVE_CHILD_STOP, e);
            }
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeChild", child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainerListener(ContainerListener listener) {
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            this.listenersArray = this.listeners.toArray(new ContainerListener[this.listeners.size()]);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void removeLifecycleListeners() {
        this.lifecycle.removeLifecycleListeners();
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, CONTAINER_STARTED, this.logName());
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        this.startChildren();
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.threadStart();
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        int i;
        if (!this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, CONTAINER_NOT_STARTED_EXCEPTION, this.logName());
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.threadStop();
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)children[i])).stop();
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(ERROR_STOPPING_CONTAINER), children[i]);
                log.log(Level.SEVERE, msg, t);
            }
        }
        children = this.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.removeChild(children[i]);
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public void init() throws Exception {
        this.initialized = true;
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        return null;
    }

    public void destroy() throws Exception {
        Container[] children;
        if (this.started) {
            this.stop();
        }
        this.initialized = false;
        if (this.oname != null) {
            try {
                if (this.controller == this.oname && log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "unregistering " + this.oname);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, ERROR_UNREGISTERING, t);
            }
        }
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        for (Container aChildren : children = this.findChildren()) {
            this.removeChild(aChildren);
        }
        this.removeLifecycleListeners();
        this.setRealm(null);
    }

    @Override
    public synchronized void addValve(GlassFishValve valve) {
        this.pipeline.addValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addValve", valve);
        }
    }

    @Override
    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addValve", valve);
        }
    }

    public ObjectName[] getValveObjectNames() {
        return ((StandardPipeline)this.pipeline).getValveObjectNames();
    }

    @Override
    public GlassFishValve getBasic() {
        return this.pipeline.getBasic();
    }

    @Override
    public GlassFishValve[] getValves() {
        return this.pipeline.getValves();
    }

    @Override
    public boolean hasNonBasicValves() {
        return this.pipeline.hasNonBasicValves();
    }

    @Override
    public synchronized void removeValve(GlassFishValve valve) {
        this.pipeline.removeValve(valve);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeValve", valve);
        }
    }

    @Override
    public void setBasic(GlassFishValve valve) {
        this.pipeline.setBasic(valve);
    }

    @Override
    public void backgroundProcess() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireContainerEvent(String type2, Object data) {
        ContainerListener[] list = null;
        ArrayList<ContainerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.isEmpty()) {
                return;
            }
            list = this.listenersArray;
        }
        ContainerEvent event = new ContainerEvent(this, type2, data);
        for (int i = 0; i < list.length; ++i) {
            list[i].containerEvent(event);
        }
    }

    protected void startChildren() {
        Container[] children = this.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Lifecycle)) continue;
            try {
                ((Lifecycle)((Object)children[i])).start();
                continue;
            }
            catch (Throwable t) {
                String msg = MessageFormat.format(rb.getString(CONTAINER_NOT_STARTED_EXCEPTION), children[i]);
                log.log(Level.SEVERE, msg, t);
                if (children[i] instanceof Context) {
                    ((Context)children[i]).setAvailable(false);
                    continue;
                }
                if (!(children[i] instanceof Wrapper)) continue;
                ((Wrapper)children[i]).setAvailable(Long.MAX_VALUE);
            }
        }
    }

    protected void log(String message) {
        log.log(Level.INFO, message);
    }

    protected void log(String message, Throwable throwable) {
        Logger logger2 = this.getLogger();
        if (logger2 != null) {
            logger2.log(this.logName() + ": " + message, throwable);
        } else {
            log.log(Level.SEVERE, message, throwable);
        }
    }

    protected String logName() {
        String className = this.getClass().getName();
        int period = className.lastIndexOf(".");
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className + "[" + this.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getJmxName() {
        ContainerBase containerBase = this;
        synchronized (containerBase) {
            return this.oname;
        }
    }

    public String getObjectName() {
        if (this.oname != null) {
            return this.oname.toString();
        }
        return null;
    }

    public String getDomain() {
        if (this.domain == null) {
            Container parent;
            for (parent = this; parent != null && !(parent instanceof StandardEngine); parent = parent.getParent()) {
            }
            if (parent != null) {
                this.domain = ((StandardEngine)parent).getDomain();
            }
        }
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getChildren() {
        Map<String, Container> map = this.children;
        synchronized (map) {
            ObjectName[] result = new ObjectName[this.children.size()];
            Iterator<Container> it = this.children.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                Container next = it.next();
                if (!(next instanceof ContainerBase)) continue;
                result[i++] = ((ContainerBase)next).getJmxName();
            }
            return result;
        }
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create ObjectName " + domain + " " + parent);
        }
        return null;
    }

    public String getContainerSuffix() {
        ContainerBase container = this;
        Container context = null;
        Container host = null;
        ContainerBase servlet = null;
        StringBuilder suffix = new StringBuilder();
        if (container instanceof StandardHost) {
            host = container;
        } else if (container instanceof StandardContext) {
            host = container.getParent();
            context = container;
        } else if (container instanceof StandardWrapper) {
            context = container.getParent();
            host = context.getParent();
            servlet = container;
        }
        if (context != null) {
            String path = ((StandardContext)context).getEncodedPath();
            suffix.append(",path=").append(path.equals("") ? "/" : path);
        }
        if (host != null) {
            suffix.append(",host=").append(host.getName());
        }
        if (servlet != null) {
            String containerName = container.getName();
            suffix.append(",servlet=");
            suffix.append("".equals(containerName) ? "/" : containerName);
        }
        return suffix.toString();
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (this.backgroundProcessorDelay <= 0) {
            return;
        }
        this.threadDone = false;
        String threadName = "ContainerBackgroundProcessor[" + this.toString() + "]";
        this.thread = new Thread((Runnable)new ContainerBackgroundProcessor(), threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected class ContainerBackgroundProcessor
    implements Runnable {
        protected ContainerBackgroundProcessor() {
        }

        @Override
        public void run() {
            while (!ContainerBase.this.threadDone) {
                try {
                    Thread.sleep((long)ContainerBase.this.backgroundProcessorDelay * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ContainerBase.this.threadDone) continue;
                Container parent = (Container)ContainerBase.this.getMappingObject();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (parent.getLoader() != null) {
                    cl = parent.getLoader().getClassLoader();
                }
                this.processChildren(parent, cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processChildren(Container container, ClassLoader cl) {
            try {
                if (container.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(container.getLoader().getClassLoader());
                }
                container.backgroundProcess();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, ContainerBase.EXCEPTION_INVOKES_PERIODIC_OP, t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            Container[] children = container.findChildren();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getBackgroundProcessorDelay() > 0) continue;
                this.processChildren(children[i], cl);
            }
        }
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction<Void> {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        @Override
        public Void run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

