/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.apache.catalina.Globals;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.RequestFacadeHelper;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.security.SecurityUtil;
import org.glassfish.logging.annotation.LogMessageInfo;

public class RequestFacade
implements HttpServletRequest {
    private static final ResourceBundle rb = StandardServer.log.getResourceBundle();
    @LogMessageInfo(message=" Must not use request object outside the scope of a servlet's service or a filter's doFilter method", level="WARNING")
    public static final String CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION = "AS-WEB-CORE-00074";
    private static final SecurityPermission GET_UNWRAPPED_COYOTE_REQUEST_PERMISSION = new SecurityPermission("getUnwrappedCoyoteRequest");
    protected Request request = null;
    private boolean maskDefaultContextMapping = false;
    private RequestFacadeHelper reqFacHelper = null;

    public RequestFacade(Request request) {
        this(request, false);
    }

    public RequestFacade(Request request, boolean maskDefaultContextMapping) {
        this.request = request;
        this.maskDefaultContextMapping = maskDefaultContextMapping;
        this.reqFacHelper = new RequestFacadeHelper(request);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void clear() {
        this.request = null;
        if (this.reqFacHelper != null) {
            this.reqFacHelper.clear();
        }
        this.reqFacHelper = null;
    }

    RequestFacadeHelper getRequestFacadeHelper() {
        return this.reqFacHelper;
    }

    @Override
    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.request.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        this.request.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getInputStream();
    }

    @Override
    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.request.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        String[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    @Override
    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getProtocol();
    }

    @Override
    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getServerName();
    }

    @Override
    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getReader();
    }

    @Override
    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object o) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        this.request.setAttribute(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        this.request.removeAttribute(name);
    }

    @Override
    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.request.getLocales();
    }

    @Override
    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.request.getRequestDispatcher(path);
    }

    @Override
    public String getRealPath(String path) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRealPath(path);
    }

    @Override
    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getAuthType();
    }

    @Override
    public Cookie[] getCookies() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        Cookie[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    @Override
    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return this.request.getHeaders(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.request.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getIntHeader(name);
    }

    @Override
    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getMethod();
    }

    @Override
    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getPathTranslated();
    }

    @Override
    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    @Override
    public String getContextPath() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getContextPath(this.maskDefaultContextMapping);
    }

    public String getContextPath(boolean maskDefaultContextMapping) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getContextPath(maskDefaultContextMapping);
    }

    @Override
    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRequestURI(this.maskDefaultContextMapping);
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRequestURL(this.maskDefaultContextMapping);
    }

    @Override
    public String getServletPath() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getServletPath();
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new GetSessionPrivilegedAction(create));
        }
        return this.request.getSession(create);
    }

    @Override
    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.getSession(true);
    }

    @Override
    public String changeSessionId() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new ChangeSessionIdPrivilegedAction());
        }
        return this.request.changeSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isRequestedSessionIdFromURL();
    }

    @Override
    public String getLocalAddr() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getLocalAddr();
    }

    @Override
    public String getLocalName() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getLocalName();
    }

    @Override
    public int getLocalPort() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getLocalPort();
    }

    @Override
    public int getRemotePort() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getRemotePort();
    }

    @Override
    public DispatcherType getDispatcherType() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getDispatcherType();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.startAsync();
    }

    @Override
    public AsyncContext startAsync(ServletRequest sreq, ServletResponse sresp) throws IllegalStateException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.startAsync(sreq, sresp);
    }

    @Override
    public boolean isAsyncStarted() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.isAsyncSupported();
    }

    @Override
    public AsyncContext getAsyncContext() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getAsyncContext();
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.getPart(name);
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.authenticate(response);
    }

    @Override
    public void login(String username, String password) throws ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        this.request.login(username, password);
    }

    @Override
    public void logout() throws ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        this.request.logout();
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString(CANNOT_USE_REQUEST_OBJECT_OUTSIDE_SCOPE_EXCEPTION));
        }
        return this.request.upgrade(handlerClass);
    }

    public Request getUnwrappedCoyoteRequest() throws AccessControlException {
        if (Globals.IS_SECURITY_ENABLED) {
            AccessController.checkPermission(GET_UNWRAPPED_COYOTE_REQUEST_PERMISSION);
        }
        return this.request;
    }

    private final class ChangeSessionIdPrivilegedAction
    implements PrivilegedAction<String> {
        private ChangeSessionIdPrivilegedAction() {
        }

        @Override
        public String run() {
            return RequestFacade.this.request.changeSessionId();
        }
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction<HttpSession> {
        private boolean create;

        public GetSessionPrivilegedAction(boolean create) {
            this.create = create;
        }

        @Override
        public HttpSession run() {
            return RequestFacade.this.request.getSession(this.create);
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction<Enumeration<Locale>> {
        private GetLocalesPrivilegedAction() {
        }

        @Override
        public Enumeration<Locale> run() {
            return RequestFacade.this.request.getLocales();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction<Locale> {
        private GetLocalePrivilegedAction() {
        }

        @Override
        public Locale run() {
            return RequestFacade.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetHeaderNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getHeaderNames();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getHeaders(this.name);
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction<String> {
        private GetCharacterEncodingPrivilegedAction() {
        }

        @Override
        public String run() {
            return RequestFacade.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction<Cookie[]> {
        private GetCookiesPrivilegedAction() {
        }

        @Override
        public Cookie[] run() {
            return RequestFacade.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction<String[]> {
        public String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String[] run() {
            return RequestFacade.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetParameterNamesPrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction<String> {
        public String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        @Override
        public String run() {
            return RequestFacade.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction<RequestDispatcher> {
        private String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        @Override
        public RequestDispatcher run() {
            return RequestFacade.this.request.getRequestDispatcher(this.path);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction<Map<String, String[]>> {
        private GetParameterMapPrivilegedAction() {
        }

        @Override
        public Map<String, String[]> run() {
            return RequestFacade.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction<Enumeration<String>> {
        private GetAttributePrivilegedAction() {
        }

        @Override
        public Enumeration<String> run() {
            return RequestFacade.this.request.getAttributeNames();
        }
    }
}

