/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.servlet.http.WebConnection;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.AsyncContextImpl;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.SessionTracker;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringParser;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.server.util.RequestUtils;
import org.glassfish.grizzly.http.util.B2CConverter;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.MessageBytes;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.valve.GlassFishValve;

public class Request
implements HttpRequest,
HttpServletRequest {
    private static final java.util.logging.Logger log = StandardServer.log;
    private static final ResourceBundle rb = log.getResourceBundle();
    @LogMessageInfo(message="getReader() has already been called for this request", level="WARNING")
    public static final String GETREADER_BEEN_CALLED_EXCEPTION = "AS-WEB-CORE-00052";
    @LogMessageInfo(message="getInputStream() has already been called for this request", level="WARNING")
    public static final String GETINPUTSTREAM_BEEN_CALLED_EXCEPTION = "AS-WEB-CORE-00053";
    @LogMessageInfo(message="Unable to determine client remote address from proxy (returns null)", level="WARNING")
    public static final String UNABLE_DETERMINE_CLIENT_ADDRESS = "AS-WEB-CORE-00054";
    @LogMessageInfo(message="Unable to resolve IP address {0} into host name", level="WARNING")
    public static final String UNABLE_RESOLVE_IP_EXCEPTION = "AS-WEB-CORE-00055";
    @LogMessageInfo(message="Exception thrown by attributes event listener", level="WARNING")
    public static final String ATTRIBUTE_EVENT_LISTENER_EXCEPTION = "AS-WEB-CORE-00056";
    @LogMessageInfo(message="Cannot call setAttribute with a null name", level="WARNING")
    public static final String NULL_ATTRIBUTE_NAME_EXCEPTION = "AS-WEB-CORE-00057";
    @LogMessageInfo(message="Unable to determine canonical name of file [{0}] specified for use with sendfile", level="WARNING")
    public static final String UNABLE_DETERMINE_CANONICAL_NAME = "AS-WEB-CORE-00058";
    @LogMessageInfo(message="Unable to set request character encoding to {0} from context {1}, because request parameters have already been read, or ServletRequest.getReader() has already been called", level="WARNING")
    public static final String UNABLE_SET_REQUEST_CHARS = "AS-WEB-CORE-00059";
    @LogMessageInfo(message="Attempt to re-login while the user identity already exists", level="SEVERE", cause="Could not re-login", action="Verify if user has already login")
    public static final String ATTEMPT_RELOGIN_EXCEPTION = "AS-WEB-CORE-00060";
    @LogMessageInfo(message="changeSessionId has been called without a session", level="WARNING")
    public static final String CHANGE_SESSION_ID_BEEN_CALLED_EXCEPTION = "AS-WEB-CORE-00061";
    @LogMessageInfo(message="Cannot create a session after the response has been committed", level="WARNING")
    public static final String CANNOT_CREATE_SESSION_EXCEPTION = "AS-WEB-CORE-00062";
    @LogMessageInfo(message="Invalid URI encoding; using HTTP default", level="SEVERE", cause="Could not set URI converter", action="Verify URI encoding, using HTTP default")
    public static final String INVALID_URI_ENCODING = "AS-WEB-CORE-00063";
    @LogMessageInfo(message="Invalid URI character encoding; trying ascii", level="SEVERE", cause="Could not encode URI character", action="Verify URI encoding, trying ascii")
    public static final String INVALID_URI_CHAR_ENCODING = "AS-WEB-CORE-00064";
    @LogMessageInfo(message="Request is within the scope of a filter or servlet that does not support asynchronous operations", level="WARNING")
    public static final String REQUEST_WITHIN_SCOPE_OF_FILTER_OR_SERVLET_EXCEPTION = "AS-WEB-CORE-00065";
    @LogMessageInfo(message="ServletRequest.startAsync called again without any asynchronous dispatch, or called outside the scope of any such dispatch, or called again within the scope of the same dispatch", level="WARNING")
    public static final String START_ASYNC_CALLED_AGAIN_EXCEPTION = "AS-WEB-CORE-00066";
    @LogMessageInfo(message="Response already closed", level="WARNING")
    public static final String ASYNC_ALREADY_COMPLETE_EXCEPTION = "AS-WEB-CORE-00067";
    @LogMessageInfo(message="ServletRequest.startAsync called outside the scope of an async dispatch", level="WARNING")
    public static final String START_ASYNC_CALLED_OUTSIDE_SCOPE_EXCEPTION = "AS-WEB-CORE-00068";
    @LogMessageInfo(message="The request has not been put into asynchronous mode, must call ServletRequest.startAsync first", level="WARNING")
    public static final String REQUEST_NOT_PUT_INTO_ASYNC_MODE_EXCEPTION = "AS-WEB-CORE-00069";
    @LogMessageInfo(message="Request already released from asynchronous mode", level="WARNING")
    public static final String REQUEST_ALREADY_RELEASED_EXCEPTION = "AS-WEB-CORE-00070";
    @LogMessageInfo(message="Unable to perform error dispatch", level="SEVERE", cause="Could not perform post-request processing as required by this Valve", action="Verify if I/O exception or servlet exception occur")
    public static final String UNABLE_PERFORM_ERROR_DISPATCH = "AS-WEB-CORE-00071";
    @LogMessageInfo(message="Request.{0} is called without multipart configuration. Either add a @MultipartConfig to the servlet, or a multipart-config element to web.xml", level="WARNING")
    public static final String REQUEST_CALLED_WITHOUT_MULTIPART_CONFIG_EXCEPTION = "AS-WEB-CORE-00072";
    @LogMessageInfo(message="This should not happen-breaking background lock: sess = {0}", level="WARNING")
    public static final String BREAKING_BACKGROUND_LOCK_EXCEPTION = "AS-WEB-CORE-00073";
    @LogMessageInfo(message="This is request has already been authenticated", level="WARNING")
    public static final String ALREADY_AUTHENTICATED = "AS-WEB-CORE-00536";
    @LogMessageInfo(message="No authenticator", level="WARNING")
    public static final String NO_AUTHENTICATOR = "AS-WEB-CORE-00537";
    @LogMessageInfo(message="Invalid call to login while pluggable authentication method is configured", level="WARNING")
    public static final String LOGIN_WITH_AUTH_CONFIG = "AS-WEB-CORE-00538";
    @LogMessageInfo(message="Internal logout error", level="WARNING")
    public static final String INTERNAL_LOGOUT_ERROR = "AS-WEB-CORE-00539";
    protected static final String info = "org.apache.catalina.connector.Request/1.0";
    private static boolean enforceScope = false;
    private static final String SESS_PASSWORD_NOTE = "org.apache.catalina.session.PASSWORD";
    private static final String SESS_USERNAME_NOTE = "org.apache.catalina.session.USERNAME";
    private static ThreadLocal staticDateFormats = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat[] f = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
            return f;
        }
    };
    protected SimpleDateFormat[] formats;
    private static ThreadLocal reentrancyStatus = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };
    protected ArrayList<Cookie> cookies = new ArrayList();
    protected static final Locale defaultLocale = Locale.getDefault();
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected ArrayList<Locale> locales = new ArrayList();
    private Map<String, Object> notes = new HashMap<String, Object>();
    protected String authType = null;
    protected Object dispatcherTypeAttr = null;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean parametersProcessed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected Subject subject = null;
    protected static final int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap<String, String[]> parameterMap = new ParameterMap();
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected String requestedSessionVersion = null;
    private boolean isRequestedSessionIdFromSecureCookie;
    protected String requestedSessionCookiePath;
    protected CharChunk uriParamsCC = new CharChunk();
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localName = null;
    protected String localAddr = null;
    protected boolean checkRestrictedResources = true;
    private boolean unsuccessfulSessionFind = false;
    protected boolean checkUnsuccessfulSessionFind = true;
    private int dispatchDepth = 0;
    private static int maxDispatchDepth = 20;
    private String jrouteId;
    private SessionTracker sessionTracker = new SessionTracker();
    private boolean isDefaultContext = false;
    private String requestURI = null;
    protected org.glassfish.grizzly.http.server.Request coyoteRequest;
    protected RequestFacade facade = null;
    protected RequestFacade defaultContextMaskingFacade = null;
    protected org.apache.catalina.Response response = null;
    protected Connector connector;
    protected MappingData mappingData = new MappingData();
    protected Wrapper wrapper = null;
    protected FilterChain filterChain = null;
    private boolean isAsyncSupported = true;
    private AtomicBoolean asyncStarted = new AtomicBoolean();
    private AsyncContextImpl asyncContext;
    private boolean isAsyncComplete;
    private Thread asyncStartedThread;
    private volatile boolean delayAsyncDispatchAndComplete = true;
    private Multipart multipart;
    protected Context context = null;
    protected ServletContext servletContext = null;
    protected GlassFishValve hostValve;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private boolean initRequestFacadeHelper = false;
    public static final boolean discardDisconnectEvent = Boolean.getBoolean("org.glassfish.grizzly.discardDisconnect");
    private boolean upgrade = false;
    private boolean afterService = false;
    private boolean resume = false;
    private HttpUpgradeHandler httpUpgradeHandler;
    private WebConnection webConnection;
    protected B2CConverter URIConverter = null;

    public Request() {
        this.formats = (SimpleDateFormat[])staticDateFormats.get();
        this.formats[0].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[1].setTimeZone(TimeZone.getTimeZone("GMT"));
        this.formats[2].setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setCoyoteRequest(org.glassfish.grizzly.http.server.Request grizzlyRequest) {
        this.coyoteRequest = grizzlyRequest;
        this.inputBuffer.setRequest(grizzlyRequest);
        this.inputBuffer.setRequest(this);
    }

    public org.glassfish.grizzly.http.server.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public void recycle() {
        if (this.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.servletContext = null;
        this.contextPath = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.wrapper = null;
        this.dispatcherTypeAttr = null;
        this.requestDispatcherPath = null;
        this.authType = null;
        this.requestURI = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.parametersProcessed = false;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.multipart = null;
        this.jrouteId = null;
        this.upgrade = false;
        this.afterService = false;
        this.resume = false;
        this.attributes.clear();
        this.notes.clear();
        this.cookies.clear();
        this.unsuccessfulSessionFind = false;
        if (this.session != null) {
            this.session.endAccess();
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionCookiePath = null;
        this.requestedSessionURL = false;
        this.uriParamsCC.recycle();
        this.sessionTracker.reset();
        this.dispatchDepth = 0;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        this.mappingData.recycle();
        this.initRequestFacadeHelper = false;
        if (enforceScope) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.defaultContextMaskingFacade != null) {
                this.defaultContextMaskingFacade.clear();
                this.defaultContextMaskingFacade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        if (this.asyncContext != null) {
            this.asyncContext.clear();
            this.asyncContext = null;
        }
        this.isAsyncSupported = true;
        this.asyncStarted.set(false);
        this.isAsyncComplete = false;
        this.delayAsyncDispatchAndComplete = true;
        this.asyncStartedThread = null;
    }

    public void setUnsuccessfulSessionFind(boolean unsuccessfulSessionFind) {
        this.unsuccessfulSessionFind = unsuccessfulSessionFind;
    }

    public boolean getUnsuccessfulSessionFind() {
        return this.unsuccessfulSessionFind;
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public HttpUpgradeHandler getHttpUpgradeHandler() {
        return this.httpUpgradeHandler;
    }

    @Override
    public String getAuthorization() {
        return this.coyoteRequest.getHeader("authorization");
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
        if (context != null) {
            this.servletContext = context.getServletContext();
            Pipeline p = context.getParent().getPipeline();
            if (p != null) {
                this.hostValve = p.getBasic();
            }
        }
        this.initSessionTracker();
    }

    public void setDefaultContext(boolean isDefaultContext) {
        this.isDefaultContext = isDefaultContext;
    }

    @Override
    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    @Override
    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    @Override
    public Host getHost() {
        return (Host)this.mappingData.host;
    }

    @Override
    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public void setMappingData(MappingData mappingData) {
        this.mappingData = mappingData;
    }

    public void updatePaths(MappingData md) {
        this.pathInfo = md.pathInfo.toString();
        this.servletPath = md.wrapperPath.toString();
        this.contextPath = md.contextPath.toString();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.getRequest(false);
    }

    @Override
    public HttpServletRequest getRequest(boolean maskDefaultContextMapping) {
        if (!maskDefaultContextMapping || !this.isDefaultContext) {
            if (this.facade == null) {
                this.facade = new RequestFacade(this);
            }
            if (!this.initRequestFacadeHelper) {
                this.attributes.put("org.glassfish.web.RequestFacadeHelper", this.facade.getRequestFacadeHelper());
                this.initRequestFacadeHelper = true;
            }
            return this.facade;
        }
        if (this.defaultContextMaskingFacade == null) {
            this.defaultContextMaskingFacade = new RequestFacade(this, true);
        }
        if (!this.initRequestFacadeHelper) {
            this.attributes.put("org.glassfish.web.RequestFacadeHelper", this.defaultContextMaskingFacade.getRequestFacadeHelper());
            this.initRequestFacadeHelper = true;
        }
        return this.defaultContextMaskingFacade;
    }

    @Override
    public org.apache.catalina.Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(org.apache.catalina.Response response) {
        this.response = response;
        if (response instanceof Response) {
            this.sessionTracker.setResponse((Response)response);
        }
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
    }

    @Override
    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public void finishRequest() throws IOException {
    }

    @Override
    public Object getNote(String name) {
        return this.notes.get(name);
    }

    @Override
    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    @Override
    public void removeNote(String name) {
        this.notes.remove(name);
    }

    @Override
    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    @Override
    public void setContentLength(int length) {
        this.coyoteRequest.getRequest().setContentLength(length);
    }

    @Override
    public void setContentType(String type2) {
    }

    @Override
    public void setProtocol(String protocol) {
    }

    @Override
    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void setServerName(String name) {
        this.coyoteRequest.setServerName(name);
    }

    @Override
    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    @Override
    public void setCheckRestrictedResources(boolean check) {
        this.checkRestrictedResources = check;
    }

    @Override
    public boolean getCheckRestrictedResources() {
        return this.checkRestrictedResources;
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherTypeAttr == null ? DispatcherType.REQUEST : this.dispatcherTypeAttr;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        if (name.equals("org.apache.catalina.CONSTRAINT_URI")) {
            return this.getRequestPathMB() != null ? this.getRequestPathMB().toString() : null;
        }
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            RequestUtils.populateCertificateAttribute(this.coyoteRequest);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        } else if (Request.isSSLAttribute(name)) {
            RequestUtils.populateSSLAttributes(this.coyoteRequest);
            attr = this.attributes.get(name);
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name) || "javax.servlet.request.ssl_session_id".equals(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.isSecure()) {
            this.populateSSLAttributes();
        }
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    @Override
    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    @Override
    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return this.coyoteRequest.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(rb.getString(GETREADER_BEEN_CALLED_EXCEPTION));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    @Override
    public Locale getLocale() {
        return this.coyoteRequest.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return new Enumerator<Locale>(this.coyoteRequest.getLocales());
    }

    private void processParameters() {
        String contentType;
        if (this.parametersProcessed) {
            return;
        }
        this.getCharacterEncoding();
        if (this.isMultipartConfigured() && this.getMethod().equalsIgnoreCase("POST") && (contentType = this.getContentType()) != null && contentType.startsWith("multipart/form-data")) {
            this.getMultipart().init();
        }
        this.parametersProcessed = true;
    }

    @Override
    public String getParameter(String name) {
        this.processParameters();
        return this.coyoteRequest.getParameter(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration<String> e = this.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        this.processParameters();
        return new Enumerator<String>(this.coyoteRequest.getParameterNames());
    }

    @Override
    public String[] getParameterValues(String name) {
        this.processParameters();
        return this.coyoteRequest.getParameterValues(name);
    }

    @Override
    public String getProtocol() {
        return this.coyoteRequest.getProtocol().getProtocolString();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(rb.getString(GETINPUTSTREAM_BEEN_CALLED_EXCEPTION));
        }
        this.usingReader = true;
        try {
            this.inputBuffer.checkConverter();
        }
        catch (UnsupportedCharsetException uce) {
            UnsupportedEncodingException uee = new UnsupportedEncodingException(uce.getMessage());
            uee.initCause(uce);
            throw uee;
        }
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    @Override
    public String getRealPath(String path) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            return this.servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                this.remoteAddr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (this.remoteAddr == null && log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, UNABLE_DETERMINE_CLIENT_ADDRESS);
                }
                return this.remoteAddr;
            }
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.remoteAddr = this.coyoteRequest.getRemoteAddr();
            }
        }
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else if (this.connector.getAuthPassthroughEnabled() && this.connector.getProxyHandler() != null) {
                String addr = this.connector.getProxyHandler().getRemoteAddress(this.getRequest());
                if (addr != null) {
                    try {
                        this.remoteHost = InetAddress.getByName(addr).getHostName();
                    }
                    catch (UnknownHostException e) {
                        String msg = MessageFormat.format(rb.getString(UNABLE_RESOLVE_IP_EXCEPTION), addr);
                        log.log(Level.WARNING, msg, e);
                    }
                } else if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, UNABLE_DETERMINE_CLIENT_ADDRESS);
                }
            } else if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.remoteHost = this.coyoteRequest.getRemoteHost();
            }
        }
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.remotePort = this.socket != null ? this.socket.getPort() : this.coyoteRequest.getRemotePort();
        }
        return this.remotePort;
    }

    @Override
    public String getLocalName() {
        if (this.localName == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localName = inet.getHostName();
            } else {
                this.localName = this.coyoteRequest.getLocalName();
            }
        }
        return this.localName;
    }

    @Override
    public String getLocalAddr() {
        if (this.localAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getLocalAddress();
                this.localAddr = inet.getHostAddress();
            } else {
                this.localAddr = this.coyoteRequest.getLocalAddr();
            }
        }
        return this.localAddr;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort == -1) {
            this.localPort = this.socket != null ? this.socket.getLocalPort() : this.coyoteRequest.getLocalPort();
        }
        return this.localPort;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.servletContext == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.servletContext.getRequestDispatcher(path);
        }
        String servPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servPath == null) {
            servPath = this.getServletPath();
        }
        String pInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pInfo == null ? servPath : servPath + pInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.servletContext.getRequestDispatcher(relative);
    }

    @Override
    public String getScheme() {
        ProxyHandler proxyHandler;
        if (this.getConnector() != null && this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize(this.getRequest()) > 0) {
            return "https";
        }
        return this.coyoteRequest.getScheme();
    }

    @Override
    public String getServerName() {
        return this.coyoteRequest.getServerName();
    }

    @Override
    public int getServerPort() {
        if (this.isSecure()) {
            String host = this.getHeader("host");
            if (host != null && host.indexOf(58) == -1) {
                return 443;
            }
            return this.coyoteRequest.getServerPort();
        }
        return this.coyoteRequest.getServerPort();
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = this.attributes.containsKey(name);
        if (!found) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                listener.attributeRemoved(event);
            }
            catch (Throwable t) {
                this.log(rb.getString(ATTRIBUTE_EVENT_LISTENER_EXCEPTION), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        Object oldValue;
        if (name == null) {
            throw new IllegalArgumentException(rb.getString(NULL_ATTRIBUTE_NAME_EXCEPTION));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherTypeAttr = value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        boolean replaced = false;
        if (Globals.IS_SECURITY_ENABLED && name.equals("org.apache.tomcat.sendfile.filename")) {
            String canonicalPath;
            try {
                canonicalPath = new File(value.toString()).getCanonicalPath();
            }
            catch (IOException e) {
                String msg = MessageFormat.format(rb.getString(UNABLE_DETERMINE_CANONICAL_NAME), value);
                throw new SecurityException(msg, e);
            }
            System.getSecurityManager().checkRead(canonicalPath);
            value = canonicalPath;
        }
        if ((oldValue = this.attributes.put(name, value)) != null) {
            replaced = true;
        }
        if (name.startsWith("grizzly.")) {
            this.coyoteRequest.setAttribute(name, value);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.servletContext, this.getRequest(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)eventListener;
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
            }
            catch (Throwable t) {
                this.log(rb.getString(ATTRIBUTE_EVENT_LISTENER_EXCEPTION), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.usingReader) {
            String contextName = this.getContext() != null ? this.getContext().getName() : "UNKNOWN";
            log.log(Level.WARNING, UNABLE_SET_REQUEST_CHARS, new Object[]{enc, contextName});
            return;
        }
        byte[] buffer = new byte[]{97};
        final byte[] finalBuffer = buffer;
        final String finalEnc = enc;
        if (Globals.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws UnsupportedEncodingException {
                        return new String(finalBuffer, RequestUtil.lookupCharset(finalEnc));
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (UnsupportedEncodingException)pae.getCause();
            }
        } else {
            new String(buffer, RequestUtil.lookupCharset(enc));
        }
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public static void setMaxDispatchDepth(int depth) {
        maxDispatchDepth = depth;
    }

    public static int getMaxDispatchDepth() {
        return maxDispatchDepth;
    }

    public int incrementDispatchDepth() {
        return ++this.dispatchDepth;
    }

    public int decrementDispatchDepth() {
        return --this.dispatchDepth;
    }

    public boolean isMaxDispatchDepthReached() {
        return this.dispatchDepth > maxDispatchDepth;
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.context == null) {
            throw new ServletException("Internal error: Context null");
        }
        final AuthenticatorBase authBase = (AuthenticatorBase)this.context.getAuthenticator();
        if (authBase == null) {
            throw new ServletException("Internal error: Authenticator null");
        }
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            try {
                return authBase.authenticate(this, (HttpResponse)this.getResponse(), this.context.getLoginConfig());
            }
            catch (Exception ex) {
                throw new ServletException("Exception thrown while attempting to authenticate", ex);
            }
        }
        alreadyCalled[0] = 1;
        try {
            Request req;
            Realm realm;
            block13: {
                realm = this.context.getRealm();
                req = this;
                if (realm == null) {
                    throw new ServletException("Internal error: realm null");
                }
                try {
                    if (!Globals.IS_SECURITY_ENABLED) break block13;
                    Boolean ret = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                return realm.invokeAuthenticateDelegate(req, (HttpResponse)Request.this.getResponse(), Request.this.context, authBase, true);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException("Exception thrown while attempting to authenticate", ex);
                            }
                        }
                    });
                    boolean bl = ret;
                    return bl;
                }
                catch (Exception ex) {
                    throw new ServletException("Exception thrown while attempting to authenticate", ex);
                }
            }
            boolean ret = realm.invokeAuthenticateDelegate(req, (HttpResponse)this.getResponse(), this.context, authBase, true);
            return ret;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    @Override
    public void login(String username, String password) throws ServletException {
        this.login(username, password != null ? password.toCharArray() : null);
    }

    public void login(String username, char[] password) throws ServletException {
        Realm realm = this.context.getRealm();
        if (realm != null && realm.isSecurityExtensionEnabled(this.getServletContext())) {
            throw new ServletException(rb.getString(LOGIN_WITH_AUTH_CONFIG));
        }
        if (this.getAuthType() != null || this.getRemoteUser() != null || this.getUserPrincipal() != null) {
            throw new ServletException(rb.getString(ALREADY_AUTHENTICATED));
        }
        if (this.context.getAuthenticator() == null) {
            throw new ServletException(rb.getString(NO_AUTHENTICATOR));
        }
        this.context.getAuthenticator().login(username, password, this);
    }

    @Override
    public void logout() throws ServletException {
        Realm realm;
        Realm realm2 = realm = this.context == null ? null : this.context.getRealm();
        if (realm == null) {
            if (this.getUserPrincipal() != null || this.getAuthType() != null) {
                throw new ServletException(rb.getString(INTERNAL_LOGOUT_ERROR));
            }
            return;
        }
        realm.logout(this);
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        this.cookies.add(cookie);
    }

    @Override
    public void addHeader(String name, String value) {
        this.coyoteRequest.getRequest().getHeaders().addValue(name).setString(value);
    }

    @Override
    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    @Override
    public void addParameter(String name, String[] values) {
        this.coyoteRequest.addParameter(name, values);
    }

    @Override
    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies.clear();
    }

    @Override
    public void clearHeaders() {
        this.coyoteRequest.getRequest().getHeaders().recycle();
    }

    @Override
    public void clearLocales() {
        this.locales.clear();
    }

    @Override
    public void clearParameters() {
        this.coyoteRequest.getParameters().recycle();
        this.coyoteRequest.getParameters().setQueryStringEncoding(Charsets.lookupCharset(this.getConnector().getURIEncoding()));
    }

    @Override
    public void replayPayload(byte[] payloadByteArray) {
        if (payloadByteArray == null) {
            return;
        }
        this.coyoteRequest.replayPayload(Buffers.wrap(this.coyoteRequest.getContext().getMemoryManager(), payloadByteArray));
    }

    @Override
    public void setAuthType(String type2) {
        this.authType = type2;
    }

    @Override
    public void setMethod(String method) {
        this.coyoteRequest.setMethod(method);
    }

    @Override
    public void setQueryString(String query) {
        this.coyoteRequest.setQueryString(query);
    }

    @Override
    public void setPathInfo(String pathInfo) {
        this.mappingData.pathInfo.setString(pathInfo);
        this.pathInfo = pathInfo;
    }

    @Override
    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    @Override
    public void setRequestedSessionCookiePath(String cookiePath) {
        this.requestedSessionCookiePath = cookiePath;
    }

    @Override
    public void setRequestedSessionId(String id) {
        int index;
        this.requestedSessionId = id;
        if (id != null && this.connector.getJvmRoute() != null && (index = id.indexOf(".")) > 0) {
            this.requestedSessionId = id.substring(0, index);
        }
    }

    @Override
    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    @Override
    public void setRequestURI(String uri) {
        this.coyoteRequest.setRequestURI(uri);
    }

    @Override
    public String getDecodedRequestURI() {
        return this.getDecodedRequestURI(false);
    }

    public String getDecodedRequestURI(boolean maskDefaultContextMapping) {
        try {
            if (maskDefaultContextMapping || !this.isDefaultContext) {
                return this.coyoteRequest.getDecodedRequestURI();
            }
            return this.getContextPath() + this.coyoteRequest.getDecodedRequestURI();
        }
        catch (CharConversionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void setServletPath(String servletPath) {
        this.mappingData.wrapperPath.setString(servletPath);
        this.servletPath = servletPath;
    }

    @Override
    public void setUserPrincipal(Principal principal) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            HttpSession session = this.getSession(false);
            if (this.subject != null && !this.subject.getPrincipals().contains(principal)) {
                this.subject.getPrincipals().add(principal);
            } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add(principal);
            }
            if (session != null) {
                session.setAttribute("javax.security.auth.subject", this.subject);
            }
        }
        this.userPrincipal = principal;
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public String getContextPath() {
        return this.getContextPath(false);
    }

    public String getContextPath(boolean maskDefaultContextMapping) {
        if (this.isDefaultContext && maskDefaultContextMapping) {
            return "";
        }
        return this.contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        if (this.cookies.size() == 0) {
            return null;
        }
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies.clear();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.cookies.add(cookies[i]);
            }
        }
    }

    @Override
    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    @Override
    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return new Enumerator<String>(this.coyoteRequest.getHeaders(name).iterator());
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return new Enumerator<String>(this.coyoteRequest.getHeaderNames().iterator());
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    @Override
    public String getMethod() {
        return this.coyoteRequest.getMethod().getMethodString();
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this.servletContext == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.servletContext.getRealPath(this.getPathInfo());
    }

    @Override
    public String getQueryString() {
        String queryString = this.coyoteRequest.getQueryString();
        if (queryString == null || "".equals(queryString)) {
            return null;
        }
        return queryString;
    }

    @Override
    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    @Override
    public DataChunk getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    @Override
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Override
    public String getRequestURI() {
        return this.getRequestURI(false);
    }

    public String getRequestURI(boolean maskDefaultContextMapping) {
        if (maskDefaultContextMapping) {
            return this.coyoteRequest.getRequestURI();
        }
        if (this.requestURI == null) {
            this.requestURI = this.isDefaultContext ? this.getContextPath() + this.coyoteRequest.getRequestURI() : this.coyoteRequest.getRequestURI();
        }
        return this.requestURI;
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.getRequestURL(false);
    }

    public StringBuffer getRequestURL(boolean maskDefaultContextMapping) {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI(maskDefaultContextMapping));
        return url;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession() {
        Session session = this.doGetSession(true);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    @Override
    public HttpSession getSession(boolean create) {
        Session session = this.doGetSession(create);
        if (session != null) {
            return session.getSession();
        }
        return null;
    }

    public void setSession(Session newSess) {
        this.session = newSess;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public void setRequestedSessionIdFromSecureCookie(boolean secure) {
        this.isRequestedSessionIdFromSecureCookie = secure;
    }

    public boolean isRequestedSessionIdFromSecureCookie() {
        return this.isRequestedSessionIdFromSecureCookie;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        if (this.session != null && this.requestedSessionId.equals(this.session.getIdInternal())) {
            return this.session.isValid();
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session localSession = null;
        try {
            localSession = manager.isSessionVersioningSupported() ? manager.findSession(this.requestedSessionId, this.requestedSessionVersion) : manager.findSession(this.requestedSessionId, this);
        }
        catch (IOException e) {
            localSession = null;
        }
        return localSession != null && localSession.isValid();
    }

    @Override
    public boolean isUserInRole(String role) {
        String realRole;
        Principal userPrincipal = this.getUserPrincipal();
        if (userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this, (HttpResponse)this.response, userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this, (HttpResponse)this.response, userPrincipal, role);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    @Override
    public Session getSessionInternal(boolean create) {
        return this.doGetSession(create);
    }

    @Override
    public String changeSessionId() {
        Manager manager = this.context.getManager();
        if (manager == null) {
            throw new IllegalStateException(rb.getString(CHANGE_SESSION_ID_BEEN_CALLED_EXCEPTION));
        }
        Session session = this.getSessionInternal(false);
        if (session == null) {
            throw new IllegalStateException(rb.getString(CHANGE_SESSION_ID_BEEN_CALLED_EXCEPTION));
        }
        manager.changeSessionId(session);
        String newSessionId = session.getId();
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = newSessionId;
        }
        this.addSessionCookie();
        return newSessionId;
    }

    @Override
    public String generateSessionId() {
        return null;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        this.upgrade = true;
        T handler = null;
        try {
            handler = ((StandardContext)this.getContext()).createHttpUpgradeHandlerInstance(handlerClass);
        }
        catch (IOException | ServletException ise) {
            throw ise;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        this.httpUpgradeHandler = handler;
        this.coyoteRequest.getResponse().suspend();
        return handler;
    }

    public WebConnection getWebConnection() {
        return this.webConnection;
    }

    public void setWebConnection(WebConnection wc) {
        this.webConnection = wc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doGetSession(boolean create) {
        String ssoId;
        SingleSignOn sso;
        StandardHost reqHost;
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            if (!this.checkUnsuccessfulSessionFind || !this.unsuccessfulSessionFind) {
                try {
                    if (manager.isSessionVersioningSupported()) {
                        this.session = manager.findSession(this.requestedSessionId, this.requestedSessionVersion);
                        if (this.session instanceof StandardSession) {
                            this.incrementSessionVersion((StandardSession)this.session, this.context);
                        }
                    } else {
                        this.session = manager.findSession(this.requestedSessionId, this);
                    }
                    if (this.session == null) {
                        this.unsuccessfulSessionFind = true;
                    }
                }
                catch (IOException e) {
                    this.session = null;
                }
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(rb.getString(CANNOT_CREATE_SESSION_EXCEPTION));
        }
        if (this.requestedSessionId != null && this.context.getReuseSessionID()) {
            this.session = manager.createSession(this.requestedSessionId);
            if (manager instanceof PersistentManagerBase) {
                ((PersistentManagerBase)manager).removeFromInvalidatedSessions(this.requestedSessionId);
            }
        } else if (this.sessionTracker.getActiveSessions() > 0) {
            SessionTracker e = this.sessionTracker;
            synchronized (e) {
                if (this.sessionTracker.getActiveSessions() > 0) {
                    String id = this.sessionTracker.getSessionId();
                    this.session = manager.createSession(id);
                    if (manager instanceof PersistentManagerBase) {
                        ((PersistentManagerBase)manager).removeFromInvalidatedSessions(id);
                    }
                }
            }
        } else {
            String id = this.generateSessionId();
            this.session = id != null ? manager.createSession(id) : manager.createSession();
        }
        if ((reqHost = (StandardHost)this.getHost()) != null && (sso = reqHost.getSingleSignOn()) != null && (ssoId = (String)this.getNote("org.apache.catalina.request.SSOID")) != null) {
            long ssoVersion = 0L;
            Long ssoVersionObj = (Long)this.getNote("org.apache.catalina.request.SSOVersion");
            if (ssoVersionObj != null) {
                ssoVersion = ssoVersionObj;
            }
            sso.associate(ssoId, ssoVersion, this.session);
            this.removeNote("org.apache.catalina.request.SSOID");
        }
        this.sessionTracker.track(this.session);
        if (this.session != null && this.getContext() != null) {
            if (manager.isSessionVersioningSupported()) {
                this.incrementSessionVersion((StandardSession)this.session, this.context);
            }
            this.addSessionCookie();
        }
        if (this.session != null) {
            this.session.access();
            return this.session;
        }
        return null;
    }

    protected void configureSessionCookie(Cookie cookie) {
        cookie.setHttpOnly(true);
        cookie.setMaxAge(-1);
        String contextPath = null;
        if (this.isDefaultContext) {
            cookie.setPath("/");
        } else {
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
        }
        if (this.isSecure()) {
            cookie.setSecure(true);
        }
        if (this.context != null) {
            SessionCookieConfig sessionCookieConfig = this.context.getSessionCookieConfig();
            if (sessionCookieConfig.getDomain() != null) {
                cookie.setDomain(sessionCookieConfig.getDomain());
            }
            if (sessionCookieConfig.getPath() != null) {
                cookie.setPath(sessionCookieConfig.getPath());
            }
            if (sessionCookieConfig.getComment() != null) {
                cookie.setVersion(1);
                cookie.setComment(sessionCookieConfig.getComment());
            }
            if (!cookie.getSecure()) {
                cookie.setSecure(sessionCookieConfig.isSecure());
            }
            cookie.setHttpOnly(sessionCookieConfig.isHttpOnly());
            cookie.setMaxAge(sessionCookieConfig.getMaxAge());
        }
        if (this.requestedSessionCookiePath != null) {
            cookie.setPath(this.requestedSessionCookiePath);
        }
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        this.cookies.clear();
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            try {
                Cookie cookie = this.makeCookie(scookie);
                cookie.setPath(scookie.getPath());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain());
                }
                this.cookies.add(cookie);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected Cookie makeCookie(org.glassfish.grizzly.http.Cookie scookie) {
        return this.makeCookie(scookie, false);
    }

    protected Cookie makeCookie(org.glassfish.grizzly.http.Cookie scookie, boolean decode) {
        String name = scookie.getName();
        String value = scookie.getValue();
        if (decode) {
            try {
                name = URLDecoder.decode(name, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name = URLDecoder.decode(name);
                value = URLDecoder.decode(value);
            }
        }
        return new Cookie(name, value);
    }

    protected byte[] getPostBody() throws IOException {
        int len = this.getContentLength();
        byte[] formData = null;
        if (len < 8192) {
            if (this.postData == null) {
                this.postData = new byte[8192];
            }
            formData = this.postData;
        } else {
            formData = new byte[len];
        }
        int actualLen = this.readPostBody(formData, len);
        if (actualLen == len) {
            return formData;
        }
        return null;
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        Buffer b = this.coyoteRequest.getPostBody(len).duplicate();
        int length = b.limit() - b.position();
        b.get(body, b.position(), length);
        return length;
    }

    protected static final boolean isAlpha(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    protected void obtainSessionId() {
        this.setRequestedSessionURL(true);
        this.setJrouteId(this.coyoteRequest.getJrouteId());
        this.setRequestedSessionId(this.coyoteRequest.getRequestedSessionId());
    }

    protected void parseSessionId(String sessionParameterName, CharChunk uriBB) {
        String sessionParam = ";" + sessionParameterName + "=";
        String sessionId = this.parseParameterFromRequestURI(uriBB, sessionParam);
        if (sessionId != null) {
            int jrouteIndex = sessionId.lastIndexOf(58);
            if (jrouteIndex > 0) {
                this.setRequestedSessionId(sessionId.substring(0, jrouteIndex));
                if (jrouteIndex < sessionId.length() - 1) {
                    this.setJrouteId(sessionId.substring(jrouteIndex + 1));
                }
            } else {
                this.setRequestedSessionId(sessionId);
            }
            this.setRequestedSessionURL(true);
            if (this.coyoteRequest.getRequestURI() != null) {
                this.removeParameterFromRequestURI(sessionParam);
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
    }

    protected void parseSessionVersion(CharChunk uriCC) {
        String sessionVersionString = this.parseParameterFromRequestURI(uriCC, ";jsessionidversion=");
        if (sessionVersionString != null) {
            this.parseSessionVersionString(sessionVersionString);
            this.removeParameterFromRequestURI(";jsessionidversion=");
        }
    }

    protected void parseJReplica(CharChunk uriCC) {
        String jreplica = this.parseParameterFromRequestURI(uriCC, ";jreplica=");
        if (jreplica != null) {
            Session session = this.getSessionInternal(false);
            if (session != null) {
                session.setNote("com.sun.enterprise.http.jreplicaLocation", jreplica);
            }
            this.removeParameterFromRequestURI(";jreplica=");
        }
    }

    private void addSessionCookie() {
        String jvmRoute;
        if (this.context != null && this.context.getCookies() && this.response != null && (jvmRoute = ((StandardContext)this.getContext()).getJvmRoute()) == null) {
            Cookie newCookie = new Cookie(this.getContext().getSessionCookieName(), this.session.getId());
            this.configureSessionCookie(newCookie);
            ((HttpResponse)this.response).addSessionCookieInternal(newCookie);
        }
    }

    private String parseParameterFromRequestURI(CharChunk uriCC, String parameter) {
        String parameterValue = null;
        int semicolon = uriCC.indexOf(parameter, 0, parameter.length(), 0);
        if (semicolon >= 0) {
            int start = uriCC.getStart();
            int end = uriCC.getEnd();
            int parameterStart = start + semicolon + parameter.length();
            int semicolon2 = uriCC.indexOf(';', semicolon + parameter.length());
            parameterValue = semicolon2 >= 0 ? new String(uriCC.getBuffer(), parameterStart, semicolon2 - semicolon - parameter.length()) : new String(uriCC.getBuffer(), parameterStart, end - parameterStart);
        }
        return parameterValue;
    }

    private void removeParameterFromRequestURI(String parameter) {
        DataChunk uriBC = this.coyoteRequest.getRequest().getRequestURIRef().getRequestURIBC();
        int semicolon = uriBC.indexOf(parameter, 0);
        if (semicolon > 0) {
            int end;
            int semicolon2 = uriBC.indexOf(';', semicolon + parameter.length());
            if (semicolon2 >= 0) {
                end = semicolon2;
                uriBC.notifyDirectUpdate();
            } else {
                end = uriBC.getLength();
            }
            uriBC.delete(semicolon, end);
        }
    }

    void parseSessionVersionString(String sessionVersionString) {
        if (sessionVersionString == null || !this.isSessionVersioningSupported()) {
            return;
        }
        HashMap<String, String> sessionVersions = RequestUtil.parseSessionVersionString(sessionVersionString);
        if (sessionVersions != null) {
            this.attributes.put("com.sun.enterprise.http.sessionVersions", sessionVersions);
            if (this.context != null) {
                String path = this.context.getPath();
                if ("".equals(path)) {
                    path = "/";
                }
                this.requestedSessionVersion = sessionVersions.get(path);
            }
        }
    }

    void parseJrouteCookie() {
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals("JROUTE")) continue;
            this.setJrouteId(scookie.getValue());
            break;
        }
    }

    void setJrouteId(String jrouteId) {
        this.jrouteId = jrouteId;
    }

    @Override
    public String getJrouteId() {
        return this.jrouteId;
    }

    protected void parseSessionCookiesId() {
        Context context = (Context)this.getMappingData().context;
        if (context != null && !context.getCookies()) {
            return;
        }
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return;
        }
        String sessionCookieName = "JSESSIONID";
        if (context != null) {
            sessionCookieName = context.getSessionCookieName();
        }
        for (int i = 0; i < count; ++i) {
            String sessionVersionString;
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals(sessionCookieName)) continue;
            if (!this.isRequestedSessionIdFromCookie()) {
                this.setRequestedSessionId(scookie.getValue());
                sessionVersionString = this.getSessionVersionFromCookie();
                this.parseSessionVersionString(sessionVersionString);
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionIdFromSecureCookie(scookie.isSecure());
                this.setRequestedSessionURL(false);
                continue;
            }
            if (this.isRequestedSessionIdValid()) continue;
            this.setRequestedSessionId(scookie.getValue());
            sessionVersionString = this.getSessionVersionFromCookie();
            this.parseSessionVersionString(sessionVersionString);
        }
    }

    private String getSessionVersionFromCookie() {
        if (!this.isSessionVersioningSupported()) {
            return null;
        }
        org.glassfish.grizzly.http.Cookie[] serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.length;
        if (count <= 0) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            org.glassfish.grizzly.http.Cookie scookie = serverCookies[i];
            if (!scookie.getName().equals("JSESSIONIDVERSION")) continue;
            return scookie.getValue();
        }
        return null;
    }

    CharChunk getURIParams() {
        return this.uriParamsCC;
    }

    protected void convertURI(MessageBytes uri) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        int length = bc.getLength();
        cc.allocate(length, -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null && !enc.isEmpty() && !"ISO-8859-1".equalsIgnoreCase(enc)) {
            B2CConverter conv = this.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    this.setURIConverter(conv);
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, INVALID_URI_ENCODING);
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc, cc.getBuffer().length - cc.getEnd());
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, INVALID_URI_CHAR_ENCODING);
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < length; ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, length);
    }

    @Override
    public DispatcherType getDispatcherType() {
        DispatcherType dispatcher = (DispatcherType)((Object)this.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
        if (dispatcher == null) {
            dispatcher = DispatcherType.REQUEST;
        }
        return dispatcher;
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        return this.startAsync(this.getRequest(), this.getResponse().getResponse(), true);
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.startAsync(servletRequest, servletResponse, false);
    }

    private AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse, boolean isStartAsyncWithZeroArg) throws IllegalStateException {
        if (servletRequest == null || servletResponse == null) {
            throw new IllegalArgumentException("Null request or response");
        }
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException(rb.getString(REQUEST_WITHIN_SCOPE_OF_FILTER_OR_SERVLET_EXCEPTION));
        }
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        if (asyncContextLocal != null) {
            if (this.isAsyncStarted()) {
                throw new IllegalStateException(rb.getString(START_ASYNC_CALLED_AGAIN_EXCEPTION));
            }
            if (this.isAsyncComplete) {
                throw new IllegalStateException(rb.getString(ASYNC_ALREADY_COMPLETE_EXCEPTION));
            }
            if (!asyncContextLocal.isStartAsyncInScope()) {
                throw new IllegalStateException(rb.getString(START_ASYNC_CALLED_OUTSIDE_SCOPE_EXCEPTION));
            }
            asyncContextLocal.reinitialize(servletRequest, servletResponse, isStartAsyncWithZeroArg);
        } else {
            AsyncContextImpl asyncContextFinal;
            this.asyncContext = asyncContextFinal = new AsyncContextImpl(this, servletRequest, (Response)this.getResponse(), servletResponse, isStartAsyncWithZeroArg);
            EmptyCompletionHandler<org.glassfish.grizzly.http.server.Response> requestCompletionHandler = new EmptyCompletionHandler<org.glassfish.grizzly.http.server.Response>(){

                @Override
                public void completed(org.glassfish.grizzly.http.server.Response response) {
                    asyncContextFinal.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.COMPLETE, null);
                }
            };
            TimeoutHandler timeoutHandler = new TimeoutHandler(){

                @Override
                public boolean onTimeout(org.glassfish.grizzly.http.server.Response response) {
                    return Request.this.processTimeout();
                }
            };
            this.coyoteRequest.getResponse().suspend(-1L, TimeUnit.MILLISECONDS, (CompletionHandler<org.glassfish.grizzly.http.server.Response>)requestCompletionHandler, timeoutHandler);
            this.asyncStartedThread = Thread.currentThread();
        }
        this.asyncStarted.set(true);
        return this.asyncContext;
    }

    @Override
    public boolean isAsyncStarted() {
        return this.asyncStarted.get();
    }

    void setAsyncStarted(boolean asyncStarted) {
        this.asyncStarted.set(asyncStarted);
    }

    @Override
    public void disableAsyncSupport() {
        this.isAsyncSupported = false;
    }

    void setAsyncTimeout(long timeout) {
        this.coyoteRequest.getResponse().getSuspendContext().setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    @Override
    public AsyncContext getAsyncContext() {
        if (!this.isAsyncStarted()) {
            throw new IllegalStateException(rb.getString(REQUEST_NOT_PUT_INTO_ASYNC_MODE_EXCEPTION));
        }
        return this.asyncContext;
    }

    boolean isDelayAsyncDispatchAndComplete() {
        return this.delayAsyncDispatchAndComplete;
    }

    void setDelayAsyncDispatchAndComplete(boolean delayAsync) {
        this.delayAsyncDispatchAndComplete = delayAsync;
    }

    void asyncComplete() {
        if (this.isAsyncComplete) {
            throw new IllegalStateException(rb.getString(REQUEST_ALREADY_RELEASED_EXCEPTION));
        }
        this.isAsyncComplete = true;
        if (!this.delayAsyncDispatchAndComplete) {
            this.processAsyncComplete();
        }
    }

    void processAsyncComplete() {
        this.asyncStarted.set(false);
        if (this.asyncStartedThread != Thread.currentThread() || !this.asyncContext.isOkToConfigure()) {
            this.coyoteRequest.getResponse().resume();
        } else {
            Response.SuspendedContextImpl suspendContext = (Response.SuspendedContextImpl)this.coyoteRequest.getResponse().getSuspendContext();
            suspendContext.markResumed();
            suspendContext.getSuspendStatus().reset();
        }
    }

    boolean isAsyncComplete() {
        return this.isAsyncComplete;
    }

    void asyncTimeout() {
        if (this.asyncContext != null) {
            this.asyncContext.notifyAsyncListeners(AsyncContextImpl.AsyncEventType.TIMEOUT, null);
        }
        this.inputBuffer.disableReadHandler();
        if (this.response instanceof Response) {
            ((Response)this.response).disableWriteHandler();
        }
        this.errorDispatchAndComplete(null);
    }

    void onAfterService() {
        if (this.asyncContext != null) {
            this.asyncContext.setOkToConfigure(false);
            if (this.asyncStarted.get()) {
                this.coyoteRequest.getResponse().getSuspendContext().setTimeout(this.asyncContext.getTimeout(), TimeUnit.MILLISECONDS);
            }
            this.delayAsyncDispatchAndComplete = false;
            this.processAsyncOperations();
        }
        this.afterService = true;
        if (this.resume) {
            this.coyoteRequest.getResponse().resume();
        }
    }

    void resumeAfterService() {
        if (this.afterService) {
            this.coyoteRequest.getResponse().resume();
        } else {
            this.resume = true;
        }
    }

    void processAsyncOperations() {
        if (this.asyncContext.isDispatchInScope()) {
            this.asyncContext.invokeDelayDispatch();
        } else if (this.isAsyncComplete) {
            this.processAsyncComplete();
        }
    }

    private boolean processTimeout() {
        boolean result = true;
        AsyncContextImpl asyncContextLocal = this.asyncContext;
        try {
            this.asyncTimeout();
            result = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
        }
        catch (Throwable throwable) {
            result = asyncContextLocal != null && !asyncContextLocal.getAndResetDispatchInScope();
            throw throwable;
        }
        return result;
    }

    void errorDispatchAndComplete(Throwable t) {
        if (this.asyncContext != null && !this.asyncContext.isDispatchInScope() && !this.isAsyncComplete) {
            ((HttpServletResponse)((Object)this.response)).setStatus(500);
            this.response.setError();
            if (t != null) {
                this.setAttribute("javax.servlet.error.exception", t);
            }
            try {
                if (this.hostValve != null) {
                    this.hostValve.postInvoke(this, this.response);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, UNABLE_PERFORM_ERROR_DISPATCH, e);
            }
            finally {
                if (!this.isAsyncComplete) {
                    this.asyncComplete();
                }
            }
        }
    }

    private Multipart getMultipart() {
        if (this.multipart == null) {
            this.multipart = new Multipart(this, this.wrapper.getMultipartLocation(), this.wrapper.getMultipartMaxFileSize(), this.wrapper.getMultipartMaxRequestSize(), this.wrapper.getMultipartFileSizeThreshold());
        }
        return this.multipart;
    }

    private boolean isMultipartConfigured() {
        if (this.wrapper instanceof StandardWrapper) {
            return ((StandardWrapper)this.wrapper).isMultipartConfigured();
        }
        return false;
    }

    private void checkMultipartConfiguration(String name) {
        if (!this.isMultipartConfigured()) {
            String msg = MessageFormat.format(rb.getString(REQUEST_CALLED_WITHOUT_MULTIPART_CONFIG_EXCEPTION), name);
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        this.checkMultipartConfiguration("getParts");
        return this.getMultipart().getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        this.checkMultipartConfiguration("getPart");
        return this.getMultipart().getPart(name);
    }

    private void log(String message, Throwable t) {
        Logger logger2 = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger2 = this.connector.getContainer().getLogger();
        }
        String localName = "Request";
        if (logger2 != null) {
            logger2.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }

    private void populateSSLAttributes() {
        RequestUtils.populateSSLAttributes(this.coyoteRequest);
        Object attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (attr != null) {
            this.attributes.put("javax.servlet.request.X509Certificate", attr);
        }
        if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
            this.attributes.put("javax.servlet.request.cipher_suite", attr);
        }
        if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
            this.attributes.put("javax.servlet.request.key_size", attr);
        }
        if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session_id")) != null) {
            this.attributes.put("javax.servlet.request.ssl_session_id", attr);
        }
    }

    private void initSessionTracker() {
        this.notes.put("com.sun.enterprise.http.sessionTracker", this.sessionTracker);
    }

    @Override
    public Session lockSession() {
        Session sess = this.getSessionInternal(false);
        if (sess != null) {
            long pollTime = 200L;
            int maxNumberOfRetries = 7;
            int tryNumber = 0;
            boolean keepTrying = true;
            boolean lockResult = false;
            while (keepTrying) {
                lockResult = sess.lockForeground();
                if (lockResult) {
                    keepTrying = false;
                    break;
                }
                if (++tryNumber < maxNumberOfRetries) {
                    this.threadSleep(pollTime *= 2L);
                    continue;
                }
                log.log(Level.WARNING, BREAKING_BACKGROUND_LOCK_EXCEPTION, sess);
                if (!(sess instanceof StandardSession)) continue;
                ((StandardSession)sess).unlockBackground();
            }
        }
        return sess;
    }

    private void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void unlockSession() {
        Session sess = this.getSessionInternal(false);
        if (sess != null) {
            sess.unlockForeground();
        }
    }

    private void incrementSessionVersion(StandardSession ss, Context context) {
        String path;
        if (ss == null || context == null) {
            return;
        }
        String versionString = Long.toString(ss.incrementVersion());
        Map<String, String> sessionVersions = this.getSessionVersionsRequestAttribute();
        if (sessionVersions == null) {
            sessionVersions = new HashMap<String, String>();
            this.setAttribute("com.sun.enterprise.http.sessionVersions", sessionVersions);
        }
        if ("".equals(path = context.getPath())) {
            path = "/";
        }
        sessionVersions.put(path, versionString);
    }

    Map<String, String> getSessionVersionsRequestAttribute() {
        return (Map)this.getAttribute("com.sun.enterprise.http.sessionVersions");
    }

    private boolean isSessionVersioningSupported() {
        return this.context != null && this.context.getManager() != null && this.context.getManager().isSessionVersioningSupported();
    }
}

