/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.fmt;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

public class LocaleSupport {
    private static final String UNDEFINED_KEY = "???";
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    private static final String REQUEST_CHAR_SET = "javax.servlet.jsp.jstl.fmt.request.charset";
    private static final Locale EMPTY_LOCALE = new Locale("", "");

    public static String getLocalizedMessage(PageContext pageContext, String key) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, null, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, String basename) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, null, basename);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args) {
        return LocaleSupport.getLocalizedMessage(pageContext, key, args, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String key, Object[] args, String basename) {
        ResourceBundle bundle2;
        LocalizationContext locCtxt = null;
        String message = UNDEFINED_KEY + key + UNDEFINED_KEY;
        locCtxt = basename != null ? LocaleSupport.getLocalizationContext(pageContext, basename) : LocaleSupport.getLocalizationContext(pageContext);
        if (locCtxt != null && (bundle2 = locCtxt.getResourceBundle()) != null) {
            try {
                message = bundle2.getString(key);
                if (args != null) {
                    MessageFormat formatter = new MessageFormat("");
                    if (locCtxt.getLocale() != null) {
                        formatter.setLocale(locCtxt.getLocale());
                    }
                    formatter.applyPattern(message);
                    message = formatter.format(args);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        return message;
    }

    private static LocalizationContext getLocalizationContext(PageContext pc) {
        LocalizationContext locCtxt = null;
        Object obj = Config.find(pc, "javax.servlet.jsp.jstl.fmt.localizationContext");
        if (obj == null) {
            return null;
        }
        locCtxt = obj instanceof LocalizationContext ? (LocalizationContext)obj : LocaleSupport.getLocalizationContext(pc, (String)obj);
        return locCtxt;
    }

    private static LocalizationContext getLocalizationContext(PageContext pc, String basename) {
        LocalizationContext locCtxt = null;
        ResourceBundle bundle2 = null;
        if (basename == null || basename.equals("")) {
            return new LocalizationContext();
        }
        Locale pref = LocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.locale");
        if (pref != null) {
            bundle2 = LocaleSupport.findMatch(basename, pref);
            if (bundle2 != null) {
                locCtxt = new LocalizationContext(bundle2, pref);
            }
        } else {
            locCtxt = LocaleSupport.findMatch(pc, basename);
        }
        if (locCtxt == null && (pref = LocaleSupport.getLocale(pc, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (bundle2 = LocaleSupport.findMatch(basename, pref)) != null) {
            locCtxt = new LocalizationContext(bundle2, pref);
        }
        if (locCtxt == null) {
            try {
                bundle2 = ResourceBundle.getBundle(basename, EMPTY_LOCALE, Thread.currentThread().getContextClassLoader());
                if (bundle2 != null) {
                    locCtxt = new LocalizationContext(bundle2, null);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (locCtxt != null) {
            if (locCtxt.getLocale() != null) {
                LocaleSupport.setResponseLocale(pc, locCtxt.getLocale());
            }
        } else {
            locCtxt = new LocalizationContext();
        }
        return locCtxt;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String basename) {
        LocalizationContext locCtxt = null;
        Enumeration enum_ = LocaleSupport.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enum_.hasMoreElements()) {
            Locale pref = (Locale)enum_.nextElement();
            ResourceBundle match = LocaleSupport.findMatch(basename, pref);
            if (match == null) continue;
            locCtxt = new LocalizationContext(match, pref);
            break;
        }
        return locCtxt;
    }

    private static ResourceBundle findMatch(String basename, Locale pref) {
        ResourceBundle match = null;
        try {
            ResourceBundle bundle2 = ResourceBundle.getBundle(basename, pref, Thread.currentThread().getContextClassLoader());
            Locale avail = bundle2.getLocale();
            if (pref.equals(avail)) {
                match = bundle2;
            } else if (pref.getLanguage().equals(avail.getLanguage()) && ("".equals(avail.getCountry()) || pref.getCountry().equals(avail.getCountry()))) {
                match = bundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return match;
    }

    private static Locale getLocale(PageContext pageContext, String name) {
        Locale loc = null;
        Object obj = Config.find(pageContext, name);
        if (obj != null) {
            loc = obj instanceof Locale ? (Locale)obj : LocaleSupport.parseLocale((String)obj);
        }
        return loc;
    }

    private static void setResponseLocale(PageContext pc, Locale locale) {
        ServletResponse response = pc.getResponse();
        response.setLocale(locale);
        if (pc.getSession() != null) {
            try {
                pc.setAttribute(REQUEST_CHAR_SET, response.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static Locale parseLocale(String locale) {
        return LocaleSupport.parseLocale(locale, null);
    }

    private static Locale parseLocale(String locale, String variant) {
        Locale ret = null;
        String language = locale;
        String country = null;
        int index = -1;
        index = locale.indexOf(45);
        if (index > -1 || (index = locale.indexOf(95)) > -1) {
            language = locale.substring(0, index);
            country = locale.substring(index + 1);
        }
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException("Missing language component in 'value' attribute in setLocale");
        }
        if (country == null) {
            ret = variant != null ? new Locale(language, "", variant) : new Locale(language, "");
        } else if (country.length() > 0) {
            ret = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
        } else {
            throw new IllegalArgumentException("Empty country component in 'value' attribute in setLocale");
        }
        return ret;
    }

    private static Enumeration getRequestLocales(HttpServletRequest request) {
        Enumeration<String> values = request.getHeaders("accept-language");
        if (values.hasMoreElements()) {
            return request.getLocales();
        }
        return values;
    }
}

