/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import fish.payara.micro.PayaraMicro;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="hazelcast-core")
@RunLevel(value=10)
public class HazelcastCore
implements EventListener {
    public static final String INSTANCE_ATTRIBUTE = "GLASSFISH-INSTANCE";
    private static HazelcastCore theCore;
    private HazelcastInstance theInstance;
    private CachingProvider hazelcastCachingProvider;
    @Inject
    Events events;
    @Inject
    ServerContext context;
    @Inject
    @Named(value="default-instance-name")
    HazelcastRuntimeConfiguration configuration;
    private boolean enabled;

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.enabled = this.configuration.getEnabled();
        this.events.register(this);
        if (this.configuration.getEnabled().booleanValue()) {
            this.bootstrapHazelcast();
        }
    }

    public HazelcastInstance getInstance() {
        return this.theInstance;
    }

    public CachingProvider getCachingProvider() {
        return this.hazelcastCachingProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static HazelcastCore getCore() {
        return theCore;
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownHazelcast();
        } else if (event.is(EventTypes.SERVER_READY) && this.enabled) {
            this.bindToJNDI();
        }
    }

    private Config buildConfiguration() {
        Config config = new Config();
        String hazelcastFilePath = "";
        try {
            URL serverConfigURL = new URL(this.context.getServerConfigURL());
            File serverConfigFile = new File(serverConfigURL.getPath());
            hazelcastFilePath = serverConfigFile.getParentFile().getAbsolutePath() + File.separator + this.configuration.getHazelcastConfigurationFile();
            File file = new File(hazelcastFilePath);
            if (file.exists()) {
                config = ConfigLoader.load(hazelcastFilePath);
                if (config == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not find configuration file " + hazelcastFilePath + " using default configuration");
                    config = new Config();
                }
            } else {
                String multicastGroup = this.configuration.getMulticastGroup();
                int multicastPort = Integer.parseInt(this.configuration.getMulticastPort());
                int startPort = Integer.parseInt(this.configuration.getStartPort());
                PayaraMicro micro = PayaraMicro.getInstance((boolean)false);
                if (micro != null) {
                    if (micro.getClusterMulticastGroup() != null) {
                        multicastGroup = micro.getClusterMulticastGroup();
                    }
                    if (micro.getClusterPort() != Integer.MIN_VALUE) {
                        multicastPort = micro.getClusterPort();
                    }
                    if (micro.getClusterStartPort() != Integer.MIN_VALUE) {
                        startPort = micro.getClusterStartPort();
                    }
                }
                config.setProperty("hazelcast.jmx", "true");
                MulticastConfig mcConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
                mcConfig.setEnabled(true);
                mcConfig.setMulticastGroup(multicastGroup);
                mcConfig.setMulticastPort(multicastPort);
                config.getNetworkConfig().setPortAutoIncrement(true);
                config.getNetworkConfig().setPort(startPort);
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Unable to parse server config URL", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not load configuration file " + hazelcastFilePath + " using default configuration", ex);
        }
        String instanceName = this.context.getDefaultDomainName() + "." + this.context.getInstanceName();
        config.setInstanceName(instanceName);
        return config;
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled || enabled.booleanValue()) {
            if (this.enabled && !enabled.booleanValue()) {
                this.enabled = false;
                this.shutdownHazelcast();
            } else if (!this.enabled && enabled.booleanValue()) {
                this.enabled = true;
                this.bootstrapHazelcast();
                this.bindToJNDI();
            } else if (this.enabled && enabled.booleanValue()) {
                this.shutdownHazelcast();
                this.bootstrapHazelcast();
                this.bindToJNDI();
            }
        }
    }

    private void shutdownHazelcast() {
        if (this.theInstance != null) {
            this.unbindFromJNDI();
            this.hazelcastCachingProvider.getCacheManager().close();
            this.hazelcastCachingProvider.close();
            this.theInstance.shutdown();
            this.theInstance = null;
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Shutdown Hazelcast");
        }
    }

    private void bootstrapHazelcast() {
        Config config = this.buildConfiguration();
        this.theInstance = Hazelcast.newHazelcastInstance(config);
        this.theInstance.getCluster().getLocalMember().setStringAttribute(INSTANCE_ATTRIBUTE, this.context.getInstanceName());
        this.hazelcastCachingProvider = HazelcastServerCachingProvider.createCachingProvider(this.theInstance);
    }

    private void bindToJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.configuration.getJNDIName(), (Object)this.theInstance);
            ctx.bind(this.configuration.getCachingProviderJNDIName(), (Object)this.hazelcastCachingProvider);
            ctx.bind(this.configuration.getCacheManagerJNDIName(), (Object)this.hazelcastCachingProvider.getCacheManager());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Bound to JNDI at " + this.configuration.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Bound to JNDI at " + this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Default Cache Manager Bound to JNDI at " + this.configuration.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void unbindFromJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.configuration.getJNDIName());
            ctx.unbind(this.configuration.getCacheManagerJNDIName());
            ctx.unbind(this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Unbound from JNDI at " + this.configuration.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Unbound from JNDI at " + this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Cache Manager Unbound from JNDI at " + this.configuration.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

