/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.cdi.jsr107;

import fish.payara.cdi.jsr107.AbstractJSR107Interceptor;
import fish.payara.cdi.jsr107.impl.PayaraCacheKeyInvocationContext;
import fish.payara.cdi.jsr107.impl.PayaraValueHolder;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@CacheResult
@Interceptor
@Priority(value=4000)
public class CacheResultInterceptor
extends AbstractJSR107Interceptor {
    @AroundInvoke
    public Object cacheResult(InvocationContext ctx) throws Throwable {
        CacheResult annotation = ctx.getMethod().getAnnotation(CacheResult.class);
        PayaraCacheKeyInvocationContext<CacheResult> pctx = new PayaraCacheKeyInvocationContext<CacheResult>(ctx, annotation);
        CacheResolverFactory resolverF = pctx.getFactory();
        CacheResolver cacheResolver = resolverF.getCacheResolver(pctx);
        Cache<GeneratedCacheKey, PayaraValueHolder> cache = cacheResolver.resolveCache(pctx);
        boolean cacheExceptions = annotation.exceptionCacheName() != null && annotation.exceptionCacheName().length() > 0;
        CacheKeyGenerator generator = pctx.getGenerator();
        GeneratedCacheKey key = generator.generateCacheKey(pctx);
        if (!annotation.skipGet()) {
            Cache exceptionCache;
            PayaraValueHolder exHolder;
            PayaraValueHolder holder = (PayaraValueHolder)cache.get(key);
            if (holder != null) {
                return holder.getValue();
            }
            if (cacheExceptions && (exHolder = (PayaraValueHolder)(exceptionCache = resolverF.getExceptionCacheResolver(pctx).resolveCache(pctx)).get(key)) != null) {
                throw (Throwable)exHolder.getValue();
            }
        }
        Object result = null;
        try {
            result = ctx.proceed();
            cache.put(key, new PayaraValueHolder(result));
        }
        catch (Throwable e) {
            boolean cacheException = false;
            if (cacheExceptions) {
                Cache<GeneratedCacheKey, PayaraValueHolder> exceptionCache = resolverF.getExceptionCacheResolver(pctx).resolveCache(pctx);
                if (this.shouldICache(annotation.cachedExceptions(), annotation.nonCachedExceptions(), e, true)) {
                    exceptionCache.put(key, new PayaraValueHolder(e));
                }
            }
            throw e;
        }
        return result;
    }
}

