/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.TimeoutInfo;
import com.sun.jts.CosTransactions.TimeoutThread;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.jtsxa.XID;
import com.sun.logging.LogDomains;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CosTransactions.Status;

class TimeoutManager {
    static final int CANCEL_TIMEOUT = 0;
    static final int NO_TIMEOUT = 0;
    static final int ACTIVE_TIMEOUT = 1;
    static final int IN_DOUBT_TIMEOUT = 2;
    private static boolean initialised = false;
    private static Hashtable pendingTimeouts = new Hashtable();
    private static Hashtable indoubtTimeouts = new Hashtable();
    private static TimeoutThread timeoutThread = null;
    private static boolean timeoutActive = false;
    private static boolean quiescing = false;
    private static boolean isSetTimeout = false;
    static Logger _logger = LogDomains.getLogger(TimeoutManager.class, "javax.enterprise.system.core.transaction");

    TimeoutManager() {
    }

    static synchronized void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (!timeoutActive && timeoutThread == null) {
            timeoutActive = true;
        }
    }

    static synchronized void initSetTimeout() {
        if (isSetTimeout) {
            return;
        }
        isSetTimeout = true;
        timeoutThread = new TimeoutThread();
        timeoutThread.start();
    }

    static boolean setTimeout(Long localTID, int timeoutType, int seconds) {
        boolean result = true;
        if (timeoutActive) {
            TimeoutInfo timeoutInfo = null;
            switch (timeoutType) {
                case 1: {
                    if (!isSetTimeout) {
                        TimeoutManager.initSetTimeout();
                    }
                    timeoutInfo = new TimeoutInfo();
                    timeoutInfo.expireTime = new Date().getTime() + (long)seconds * 1000L;
                    timeoutInfo.localTID = localTID;
                    timeoutInfo.timeoutType = timeoutType;
                    pendingTimeouts.put(localTID, timeoutInfo);
                    break;
                }
                case 2: {
                    if (!isSetTimeout) {
                        TimeoutManager.initSetTimeout();
                    }
                    timeoutInfo = new TimeoutInfo();
                    timeoutInfo.expireTime = new Date().getTime() + (long)seconds * 1000L;
                    timeoutInfo.localTID = localTID;
                    timeoutInfo.timeoutType = timeoutType;
                    indoubtTimeouts.put(localTID, timeoutInfo);
                    break;
                }
                default: {
                    if (!isSetTimeout) break;
                    boolean bl = result = pendingTimeouts.remove(localTID) != null;
                    if (!result) {
                        boolean bl2 = result = indoubtTimeouts.remove(localTID) != null;
                    }
                    if (quiescing && pendingTimeouts.isEmpty() && indoubtTimeouts.isEmpty()) {
                        timeoutThread.stop();
                        timeoutActive = false;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void timeoutCoordinator(Long localTID, int timeoutType) {
        CoordinatorImpl coord = RecoveryManager.getLocalCoordinator(localTID);
        if (coord == null) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "RecoveryManager.getLocalCoordinator() returned null,which means txn is done. Setting timeout type to CANCEL_TIMEOUT");
            }
            TimeoutManager.setTimeout(localTID, 0, 0);
        } else {
            CoordinatorImpl coordinatorImpl = coord;
            synchronized (coordinatorImpl) {
                boolean[] isRoot = new boolean[1];
                switch (timeoutType) {
                    case 1: {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "TimeoutManager.timeoutCoordinator():case ACTIVE_TIMEOUTRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Marking for Rollback thetransaction...: GTID is : " + ((TopCoordinator)coord).superInfo.globalTID.toString());
                        }
                        try {
                            coord.rollback_only();
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 2: {
                        Status state;
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.logp(Level.FINER, "TimeoutManager", "timeoutCoordinator()", "TimeoutManager.timeoutCoordinator():case IN_DOUBT_TIMEOUTRecoveryManager.getLocalCoordinator() returned non-null,which means txn is still around. Invoking recover(boolean)on TopCoordinator...: GTID is: " + ((TopCoordinator)coord).superInfo.globalTID.toString());
                        }
                        if ((state = ((TopCoordinator)coord).recover(isRoot)) == Status.StatusUnknown) {
                            _logger.log(Level.WARNING, "jts.transaction_resync_from_orginator_failed");
                            break;
                        }
                        if (state == Status.StatusCommitted) {
                            try {
                                ((TopCoordinator)coord).commit();
                                if (!isRoot[0]) break;
                                ((TopCoordinator)coord).afterCompletion(state);
                            }
                            catch (Throwable throwable) {}
                            break;
                        }
                        try {
                            ((TopCoordinator)coord).rollback(true);
                            if (!isRoot[0]) break;
                            ((TopCoordinator)coord).afterCompletion(Status.StatusRolledBack);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Enumeration checkTimeouts() {
        if (!isSetTimeout) {
            return null;
        }
        Enumeration result = null;
        if (timeoutActive && (pendingTimeouts.size() != 0 || indoubtTimeouts.size() != 0)) {
            TimeoutInfo timeoutInfo;
            Vector<TimeoutInfo> timedOut = null;
            Enumeration timeouts = null;
            Hashtable hashtable = pendingTimeouts;
            synchronized (hashtable) {
                timeouts = pendingTimeouts.elements();
                while (timeouts.hasMoreElements()) {
                    timeoutInfo = (TimeoutInfo)timeouts.nextElement();
                    if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                    if (timedOut == null) {
                        timedOut = new Vector<TimeoutInfo>();
                    }
                    timedOut.addElement(timeoutInfo);
                }
            }
            hashtable = indoubtTimeouts;
            synchronized (hashtable) {
                timeouts = indoubtTimeouts.elements();
                while (timeouts.hasMoreElements()) {
                    timeoutInfo = (TimeoutInfo)timeouts.nextElement();
                    if (new Date().getTime() <= timeoutInfo.expireTime) continue;
                    if (timedOut == null) {
                        timedOut = new Vector();
                    }
                    timedOut.addElement(timeoutInfo);
                }
            }
            if (timedOut != null) {
                result = timedOut.elements();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XID[] getInDoubtXids() {
        Hashtable hashtable = indoubtTimeouts;
        synchronized (hashtable) {
            Vector<XID> inDoubtList = new Vector<XID>();
            Enumeration timeouts = indoubtTimeouts.elements();
            while (timeouts.hasMoreElements()) {
                TimeoutInfo timeoutInfo = (TimeoutInfo)timeouts.nextElement();
                CoordinatorImpl coord = RecoveryManager.getLocalCoordinator(timeoutInfo.localTID);
                if (coord == null) continue;
                XID xid = new XID();
                xid.copy(coord.getGlobalTID());
                inDoubtList.addElement(xid);
            }
            return inDoubtList.toArray(new XID[0]);
        }
    }

    static long timeLeft(Long localTID) {
        TimeoutInfo timeoutInfo = (TimeoutInfo)pendingTimeouts.get(localTID);
        if (timeoutInfo == null) {
            timeoutInfo = (TimeoutInfo)indoubtTimeouts.get(localTID);
        }
        long result = -1L;
        if (timeoutInfo != null && (result = timeoutInfo.expireTime - new Date().getTime()) < 0L) {
            result = 0L;
        }
        return result;
    }

    static void shutdown(boolean immediate) {
        if (immediate || pendingTimeouts == null || pendingTimeouts.isEmpty()) {
            if (timeoutThread != null) {
                timeoutThread.stop();
            }
            if (pendingTimeouts != null) {
                pendingTimeouts.clear();
            }
            pendingTimeouts = null;
            timeoutThread = null;
            timeoutActive = false;
        } else {
            quiescing = true;
        }
    }
}

