/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.util.SQLTrace;
import com.sun.gjc.util.SQLTraceTimerTask;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLTraceCache {
    private final List<SQLTrace> list;
    private int numTopQueriesToReport = 10;
    private long timeToKeepQueries = 60000L;
    private SQLTraceTimerTask sqlTraceTimerTask;
    private String poolName;
    private String appName;
    private String moduleName;
    private static final Logger _logger = LogDomains.getLogger(SQLTraceCache.class, "javax.enterprise.resource.resourceadapter");
    private static final String LINE_BREAK = "%%%EOL%%%";

    public SQLTraceCache(String poolName, String appName, String moduleName, int maxSize, long timeToKeepQueries) {
        this.poolName = poolName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.numTopQueriesToReport = maxSize;
        this.list = new ArrayList<SQLTrace>();
        this.timeToKeepQueries = timeToKeepQueries * 60L * 1000L;
    }

    public List<SQLTrace> getSqlTraceList() {
        return this.list;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void scheduleTimerTask(Timer timer) {
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
            this.sqlTraceTimerTask = null;
        }
        this.sqlTraceTimerTask = this.initializeTimerTask();
        if (timer != null) {
            timer.scheduleAtFixedRate((TimerTask)this.sqlTraceTimerTask, this.timeToKeepQueries, this.timeToKeepQueries);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Scheduled Sql Trace Caching timer task");
        }
    }

    public synchronized void cancelTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cancelling Sql Trace Caching timer task");
        }
        if (this.sqlTraceTimerTask != null) {
            this.sqlTraceTimerTask.cancel();
        }
        this.sqlTraceTimerTask = null;
    }

    private SQLTraceTimerTask initializeTimerTask() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Initializing Sql Trace Caching timer task");
        }
        return new SQLTraceTimerTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdateCache(SQLTrace cacheObj) {
        List<SQLTrace> list = this.list;
        synchronized (list) {
            if (cacheObj != null) {
                int index = this.list.indexOf(cacheObj);
                if (index != -1) {
                    SQLTrace cache = this.list.get(index);
                    cache.setNumExecutions(cache.getNumExecutions() + 1);
                    cache.setLastUsageTime(System.currentTimeMillis());
                } else {
                    cacheObj.setNumExecutions(1);
                    cacheObj.setLastUsageTime(System.currentTimeMillis());
                    this.list.add(cacheObj);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeEntries() {
        List<SQLTrace> list = this.list;
        synchronized (list) {
            Collections.sort(this.list, Collections.reverseOrder());
            Iterator<SQLTrace> i = this.list.iterator();
            while (i.hasNext()) {
                SQLTrace cacheObj = i.next();
                if (this.list.size() <= this.numTopQueriesToReport) break;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("removing sql=" + cacheObj.getQueryName());
                }
                i.remove();
            }
            Collections.sort(this.list);
        }
    }

    public String getTopQueries() {
        this.purgeEntries();
        StringBuffer sb = new StringBuffer();
        for (SQLTrace cache : this.list) {
            sb.append(LINE_BREAK);
            sb.append(cache.getQueryName());
        }
        return sb.toString();
    }
}

