/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public class MethodExecutor
implements Serializable {
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, "javax.enterprise.resource.resourceadapter");
    private boolean debug = false;
    private static final String newline = System.getProperty("line.separator");
    private static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public void runJavaBeanMethod(String value, Method method, Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length == 1) {
                Object[] values = new Object[]{this.convertType(parameters[0], value)};
                method.invoke(obj, values);
            }
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
            _logger.log(Level.SEVERE, "", iae);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
            _logger.log(Level.SEVERE, "", ie);
            String msg = sm.getString("me.illegal_args", method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
            _logger.log(Level.SEVERE, "", ite);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
    }

    public void runMethod(Method method, Object obj, Vector values) throws ResourceException {
        try {
            Class<?>[] parameters = method.getParameterTypes();
            if (values.size() != parameters.length) {
                return;
            }
            Object[] actualValues = new Object[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String val = (String)values.get(i);
                actualValues[i] = val.trim().equals("NULL") ? null : this.convertType(parameters[i], val);
            }
            method.invoke(obj, actualValues);
        }
        catch (IllegalAccessException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
            _logger.log(Level.SEVERE, "", iae);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
            _logger.log(Level.SEVERE, "", ie);
            String msg = sm.getString("me.illegal_args", method.getName());
            throw new ResourceException(msg);
        }
        catch (InvocationTargetException ite) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
            _logger.log(Level.SEVERE, "", ite);
            String msg = sm.getString("me.access_denied", method.getName());
            throw new ResourceException(msg);
        }
    }

    private Object convertType(Class type2, String parameter) throws ResourceException {
        try {
            Properties p;
            String typeName = type2.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return new Integer(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return new Short(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return new Byte(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return new Long(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return new Float(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return new Double(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(parameter);
            }
            if (typeName.equals("java.util.Properties") && (p = this.stringToProperties(parameter)) != null) {
                return p;
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_nfe", parameter);
            String msg = sm.getString("me.invalid_param", parameter);
            throw new ResourceException(msg);
        }
    }

    public Object invokeMethod(Object object, String methodName, Class<?>[] valueTypes, Object ... values) throws ResourceException {
        Object returnValue = null;
        Method actualMethod = null;
        try {
            actualMethod = object.getClass().getMethod(methodName, valueTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ResourceException(ex);
        }
        catch (SecurityException ex) {
            throw new ResourceException(ex);
        }
        if (actualMethod != null) {
            try {
                returnValue = actualMethod.invoke(object, values);
            }
            catch (IllegalAccessException ex) {
                throw new ResourceException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new ResourceException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new ResourceException(ex);
            }
        }
        return returnValue;
    }

    private Properties stringToProperties(String parameter) {
        if (parameter == null) {
            return null;
        }
        String s = parameter.trim();
        if (!s.startsWith("(") || !s.endsWith(")")) {
            return null;
        }
        s = s.substring(1, s.length() - 1);
        s = s.replaceAll("(?<!\\\\),", newline);
        s = s.replaceAll("\\\\,", ",");
        Properties p = new Properties();
        Properties prop = new Properties();
        try {
            p.load(new StringBufferInputStream(s));
        }
        catch (IOException ex) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Parsing string to properties: {0}", ex.getMessage());
            }
            return null;
        }
        Enumeration<?> propKeys = p.propertyNames();
        while (propKeys.hasMoreElements()) {
            String tmpKey = (String)propKeys.nextElement();
            String tmpValue = p.getProperty(tmpKey);
            if ((tmpValue = tmpValue.trim()).length() > 1 && tmpValue.startsWith("\"") && tmpValue.endsWith("\"")) {
                tmpValue = tmpValue.substring(1, tmpValue.length() - 1);
            }
            prop.put(tmpKey, tmpValue);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Parsing string to properties: {0}size:{1}", new Object[]{prop, prop.size()});
        }
        return prop;
    }
}

