/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.WebModule;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Container;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.StandardPipeline;

public class WebPipeline
extends StandardPipeline {
    private WebModule webModule;

    public WebPipeline(Container container) {
        super(container);
        if (container instanceof WebModule) {
            this.webModule = (WebModule)container;
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        if (this.webModule != null && this.webModule.getAdHocServletName(hreq.getServletPath()) != null) {
            this.webModule.getAdHocPipeline().invoke(request, response);
        } else if (this.webModule != null) {
            Realm realm = this.webModule.getRealm();
            if (realm != null && realm.isSecurityExtensionEnabled(hreq.getServletContext())) {
                super.doChainInvoke(request, response);
            } else {
                super.invoke(request, response);
            }
        }
    }
}

