/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.commands.SetLogLevel;
import com.sun.enterprise.server.logging.commands.TargetInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@Service(name="set-log-attributes")
@PerLookup
@I18n(value="set.log.attributes")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-log-attributes", description="set-log-attributes")})
public class SetLogAttributes
implements AdminCommand {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ROTATION_LIMIT_IN_BYTES = "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes";
    private static final String ROTATION_TIMELIMIT_IN_MINUTES = "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes";
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    String[] validAttributes = new String[]{"handlers", "handlerServices", "java.util.logging.ConsoleHandler.formatter", "com.sun.enterprise.server.logging.GFFileHandler.file", "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes", "com.sun.enterprise.server.logging.GFFileHandler.flushFrequency", "java.util.logging.FileHandler.formatter", "com.sun.enterprise.server.logging.GFFileHandler.formatter", "java.util.logging.FileHandler.limit", "com.sun.enterprise.server.logging.GFFileHandler.logtoConsole", "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes", "com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging", "com.sun.enterprise.server.logging.GFFileHandler.alarms", "java.util.logging.FileHandler.count", "com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours", "log4j.logger.org.hibernate.validator.util.Version", "com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles", "java.util.logging.FileHandler.pattern", "com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange", "com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat", "com.sun.enterprise.server.logging.GFFileHandler.excludeFields", "com.sun.enterprise.server.logging.GFFileHandler.multiLineMode"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuffer sbfSuccessMsg = new StringBuffer(LINE_SEP);
        boolean success = false;
        boolean invalidAttribute = false;
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String att_name = (String)key;
                String att_value = (String)this.properties.get(att_name);
                boolean vlAttribute = false;
                for (String attrName : this.validAttributes) {
                    if (!attrName.equals(att_name)) continue;
                    try {
                        this.validateAttributeValue(att_name, att_value);
                    }
                    catch (Exception e) {
                        break;
                    }
                    m.put(att_name, att_value);
                    vlAttribute = true;
                    sbfSuccessMsg.append(localStrings.getLocalString("set.log.attribute.properties", "{0} logging attribute set with value {1}.", att_name, att_value)).append(LINE_SEP);
                }
                if (vlAttribute) continue;
                report.setMessage(localStrings.getLocalString("set.log.attribute.invalid", "Invalid logging attribute name {0} or value {1}.", att_name, att_value));
                invalidAttribute = true;
                break;
            }
            if (invalidAttribute) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            TargetInfo targetInfo = new TargetInfo(this.domain, this.target);
            String targetConfigName = targetInfo.getConfigName();
            boolean isDas = targetInfo.isDas();
            if (targetConfigName != null && !targetConfigName.isEmpty()) {
                this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                success = true;
            } else if (isDas) {
                this.loggingConfig.updateLoggingProperties(m);
                success = true;
            }
            if (!success) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", this.target);
                report.setMessage(msg);
                return;
            }
            String effectiveTarget = isDas ? "server" : targetConfigName;
            sbfSuccessMsg.append(localStrings.getLocalString("set.log.attribute.success", "These logging attributes are set for {0}.", effectiveTarget)).append(LINE_SEP);
            report.setMessage(sbfSuccessMsg.toString());
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage(localStrings.getLocalString("set.log.attribute.failed", "Could not set logging attributes for {0}.", this.target));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void validateAttributeValue(String attr_name, String attr_value) {
        int rotationTimeLimit;
        int rotationSizeLimit;
        if (attr_name.equals(ROTATION_LIMIT_IN_BYTES) ? (rotationSizeLimit = Integer.parseInt(attr_value)) < 500000 : attr_name.equals(ROTATION_TIMELIMIT_IN_MINUTES) && (rotationTimeLimit = Integer.parseInt(attr_value)) < 0) {
            throw new IllegalArgumentException();
        }
    }
}

