/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.deployment.util;

import com.sun.enterprise.connectors.connector.module.RarType;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.annotation.introspection.ResourceAdapterAnnotationScanner;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFor;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.io.ConfigurationDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.ConnectorDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.runtime.ConnectorRuntimeDDFile;
import com.sun.enterprise.deployment.util.ConnectorAnnotationDetector;
import com.sun.enterprise.deployment.util.ConnectorVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
@ArchivistFor(value="rar")
public class ConnectorArchivist
extends Archivist<ConnectorDescriptor> {
    @Inject
    private ConnectorVisitor connectorValidator;
    @Inject
    private RarType rarType;

    @Override
    public ArchiveType getModuleType() {
        return this.rarType;
    }

    @Override
    public DeploymentDescriptorFile getStandardDDFile() {
        if (this.standardDD == null) {
            this.standardDD = new ConnectorDeploymentDescriptorFile();
        }
        return this.standardDD;
    }

    @Override
    public List<ConfigurationDeploymentDescriptorFile> getConfigurationDDFiles() {
        if (this.confDDFiles == null) {
            this.confDDFiles = new ArrayList();
            this.confDDFiles.add(new ConnectorRuntimeDDFile());
        }
        return this.confDDFiles;
    }

    @Override
    public ConnectorDescriptor getDefaultBundleDescriptor() {
        return new ConnectorDescriptor();
    }

    @Override
    protected boolean postHandles(ReadableArchive abstractArchive) throws IOException {
        if (abstractArchive instanceof InputJarArchive) {
            return false;
        }
        ConnectorAnnotationDetector detector = new ConnectorAnnotationDetector(new ResourceAdapterAnnotationScanner());
        return detector.hasAnnotationInArchive(abstractArchive);
    }

    @Override
    protected String getArchiveExtension() {
        return ".rar";
    }

    @Override
    protected void postOpen(ConnectorDescriptor descriptor, ReadableArchive archive) throws IOException {
        super.postOpen(descriptor, archive);
        descriptor.visit(this.connectorValidator);
    }

    @Override
    public void validate(ClassLoader aClassLoader) {
        ClassLoader cl = aClassLoader;
        if (cl == null) {
            cl = this.classLoader;
        }
        if (cl == null) {
            return;
        }
        ((ConnectorDescriptor)this.descriptor).setClassLoader(cl);
        ((ConnectorDescriptor)this.descriptor).visit(this.connectorValidator);
    }
}

