/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.pe;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PEFileLayout {
    private static final StringManager _strMgr = StringManager.getManager(PEFileLayout.class);
    public static final String DEFAULT_INSTANCE_NAME = "server";
    protected final RepositoryConfig _config;
    public static final String ADDON_DIR = "addons";
    public static final String CONFIG_DIR = "config";
    public static final String CONFIG_BACKUP_DIR = "backup";
    public static final String DOC_ROOT_DIR = "docroot";
    public static final String JAVA_WEB_START_DIR = "java-web-start";
    public static final String LIB_DIR = "lib";
    public static final String CLASSES_DIR = "classes";
    public static final String APPLIBS_DIR = "applibs";
    public static final String EXTLIB_DIR = "ext";
    public static final String TIMERDB_DIR = "databases";
    public static final String LOGS_DIR = "logs";
    public static final String APPS_ROOT_DIR = "applications";
    public static final String J2EE_APPS_DIR = "j2ee-apps";
    public static final String J2EE_MODULES_DIR = "j2ee-modules";
    public static final String LIFECYCLE_MODULES_DIR = "lifecycle-modules";
    public static final String MBEAN_FOLDER_NAME = "mbeans";
    public static final String GENERATED_DIR = "generated";
    public static final String POLICY_DIR = "policy";
    public static final String POLICY_FILE_EXT = "granted.policy";
    public static final String JSP_DIR = "jsp";
    public static final String EJB_DIR = "ejb";
    public static final String XML_DIR = "xml";
    public static final String DOMAIN_XML_FILE = "domain.xml";
    public static final String IMQ = "imq";
    public static final String JBI_DIR = "jbi";
    public static final String JBI_LIB_DIR = "lib";
    public static final String JBI_LIB_INSTALL_DIR = "install";
    public static final String JBI_TEMPLATE_DIR = "templates";
    public static final String JBI_TEMPLATE_FILE = "jbi-registry.xml.template";
    public static final String JBI_INSTANCE_DIR = "jbi";
    public static final String JBI_COMPONENTS_DIR = "components";
    public static final String JAVAEE_SE_DIR = "sun-javaee-engine";
    public static final String HTTP_BC_DIR = "sun-http-binding";
    public static final String JBI_COMPONENT_WS = "install_root" + File.separator + "workspace";
    public static final String JBI_SHAREDLIB_DIR = "shared-libraries";
    public static final String JBI_CONFIG_DIR = "config";
    public static final String JBI_AUTOINSTALL_DIR = "autoinstall";
    public static final String JBI_CONFIG_PRIVATE_DIR = "private";
    public static final String JBI_REGISTRY_FILE = "jbi-registry.xml";
    public static final String HTTP_BC_CONFIG = "config.properties";
    public static final String IMQ_VAR_DIR = "imq";
    public static final String BIN_DIR = "bin";
    public static final String SHARE = "share";
    public static final String INSTALL_DIR = "install";
    public static final String TEMPLATES_DIR = "templates";
    public static final String COMMON_DIR = "common";
    public static final String PROFILE_PROPERTIES = "profile.properties";
    private static final String TEMPLATE_CONFIG_XML = "default-config.xml";
    public static final String APPLICATIONS_DIR = "applications";
    public static final String DATABASES_DIR = "databases";
    public static final String DTDS_DIR = "dtds";
    public static final String DOMAIN_XML_TEMPLATE = "default-domain.xml.template";
    public static final String IMQBROKERD_UNIX = "imqbrokerd";
    public static final String IMQBROKERD_WIN = "imqbrokerd.exe";
    public static final String IMQBROKERD = PEFileLayout.isWindows() ? "imqbrokerd.exe" : "imqbrokerd";
    public static final String START_SERV_UNIX = "startserv";
    public static final String START_SERV_WIN = "startserv.bat";
    public static final String START_SERV_OS = PEFileLayout.isWindows() ? "startserv.bat" : "startserv";
    public static final String START_SERV_TEMPLATE_UNIX = "startserv.tomcat.template";
    public static final String START_SERV_TEMPLATE_WIN = "startserv.tomcat.bat.template";
    public static final String START_SERV_TEMPLATE_OS = PEFileLayout.isWindows() ? "startserv.tomcat.bat.template" : "startserv.tomcat.template";
    public static final String STOP_SERV_UNIX = "stopserv";
    public static final String STOP_SERV_WIN = "stopserv.bat";
    public static final String STOP_SERV_OS = PEFileLayout.isWindows() ? "stopserv.bat" : "stopserv";
    public static final String KILL_SERV_UNIX = "killserv";
    public static final String KILL_SERV_WIN = "killserv.bat";
    public static final String KILL_SERV_OS = PEFileLayout.isWindows() ? "killserv.bat" : "killserv";
    public static final String STOP_SERV_TEMPLATE_UNIX = "stopserv.tomcat.template";
    public static final String STOP_SERV_TEMPLATE_WIN = "stopserv.tomcat.bat.template";
    public static final String STOP_SERV_TEMPLATE_OS = PEFileLayout.isWindows() ? "stopserv.tomcat.bat.template" : "stopserv.tomcat.template";
    public static final String POLICY_FILE = "server.policy";
    public static final String STUB_FILE = "admch";
    public static final String SEED_FILE = "admsn";
    public static final String ACC_XML_TEMPLATE = "glassfish-acc.xml";
    public static final String ACC_XML = "glassfish-acc.xml";
    public static final String SESSION_STORE = "session-store";
    public static final String AUTO_DEPLOY = "autodeploy";
    public static final String AUTO_DEPLOY_STATUS = ".autodeploystatus";
    private static final String AUTO_DEPLOY_OSGI_BUNDLES_DIR = "bundles";
    public static final String KEY_FILE_TEMPLATE = "keyfile";
    public static final String KEY_FILE = "keyfile";
    public static final String ADMIN_KEY_FILE = "admin-keyfile";
    public static final String INDEX_FILE = "index.html";
    public static final String DOC_ROOT = "docroot";
    private static final String LOCALES = "locales";
    private static final String ENGLISH_INDEX_FILE = "index_en.html";
    public static final String DEFAULT_WEB_XML = "default-web.xml";
    public static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    public static final String LOGIN_CONF = "login.conf";
    public static final String WSSSERVERCONFIGOLD = "wss-server-config-1.0.xml";
    public static final String WSSSERVERCONFIG = "wss-server-config-2.0.xml";
    public static final String KEYSTORE = "keystore.jks";
    public static final String TRUSTSTORE_TEMPLATE = "cacerts.jks";
    public static final String TRUSTSTORE = "cacerts.jks";
    public static final String MASTERPASSWORD_FILE = "master-password";
    public static final String PASSWORD_ALIAS_KEYSTORE = "domain-passwords";
    public static final String TIMERDB_WAL_TEMPLATE = "ejbtimer$1.wal";
    public static final String TIMERDB_WAL = "ejbtimer$1.wal";
    public static final String TIMERDB_DBN_TEMPLATE = "ejbtimer.dbn";
    public static final String TIMERDB_DBN = "ejbtimer.dbn";
    public static final String DERBY_SQL_FILE = "ejbtimer_derby.sql";
    public static final String EJB_TIMER_TABLE_NAME = "EJB__TIMER__TBL";
    public static final String DERBY_DATABASE_DIRECTORY = "ejbtimer";
    public static final String JBI_COMPONENTS = "components";
    public static final String HTTP_BC_ARCHIVE = "httpbc.jar";
    public static final String JBI_COMPONENTS_INSTALL_ROOT = "install_root";
    public static final String JAVAEE_SE_ARCHIVE = "appserv-jbise.jar";
    public static final String JBI_SHARED_LIBRARIES = "shared-libraries";
    public static final String WSDLSL_DIR = "sun-wsdl-library";
    public static final String WSDLSL_ARCHIVE = "wsdlsl.jar";

    public PEFileLayout(RepositoryConfig config) {
        this._config = config;
    }

    protected RepositoryConfig getConfig() {
        return this._config;
    }

    public void createRepositoryRoot() throws RepositoryException {
        this.createDirectory(this.getRepositoryRootDir());
    }

    public void createJBIDirectories() throws RepositoryException {
        this.createDirectory(this.getJbiInstanceDir());
    }

    public void createJBIDomainDirectories() throws RepositoryException {
        this.createJBIDirectories();
        this.createDirectory(this.getJbiAuotoInstallDir());
        this.createDirectory(this.getJbiConfigDir());
        this.createDirectory(this.getJbiConfigPrivateDir());
        this.createJbiSystemComponentsLayout();
    }

    protected void createDirectory(File dir) throws RepositoryException {
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    throw new RepositoryException(_strMgr.getString("directoryCreationError", dir));
                }
            }
            catch (Exception e) {
                throw new RepositoryException(_strMgr.getString("directoryCreationError", dir), e);
            }
        }
    }

    public File getAddonRoot() {
        return new File(this.getRepositoryDir(), ADDON_DIR);
    }

    public File getConfigRoot() {
        return new File(this.getRepositoryDir(), "config");
    }

    public File getRepositoryBackupRoot() {
        return new File(this.getConfigRoot(), CONFIG_BACKUP_DIR);
    }

    public File getDocRoot() {
        return new File(this.getRepositoryDir(), "docroot");
    }

    public File getJavaWebStartRoot() {
        return new File(this.getRepositoryDir(), JAVA_WEB_START_DIR);
    }

    public File getLibDir() {
        return new File(this.getRepositoryDir(), "lib");
    }

    public File getBinDir() {
        return new File(this.getRepositoryDir(), BIN_DIR);
    }

    public File getClassesDir() {
        return new File(this.getLibDir(), CLASSES_DIR);
    }

    public File getAppLibsDir() {
        return new File(this.getLibDir(), APPLIBS_DIR);
    }

    public File getExtLibDir() {
        return new File(this.getLibDir(), EXTLIB_DIR);
    }

    public File getTimerDatabaseDir() {
        return new File(this.getLibDir(), "databases");
    }

    public File getLogsDir() {
        return new File(this.getRepositoryDir(), LOGS_DIR);
    }

    public File getApplicationsRootDir() {
        return new File(this.getRepositoryDir(), "applications");
    }

    public File getJ2EEAppsDir() {
        return new File(this.getApplicationsRootDir(), J2EE_APPS_DIR);
    }

    public File getJ2EEModulesDir() {
        return new File(this.getApplicationsRootDir(), J2EE_MODULES_DIR);
    }

    public File getLifecycleModulesDir() {
        return new File(this.getApplicationsRootDir(), LIFECYCLE_MODULES_DIR);
    }

    public File getMbeansDir() {
        return new File(this.getApplicationsRootDir(), MBEAN_FOLDER_NAME);
    }

    public File getGeneratedDir() {
        return new File(this.getRepositoryDir(), GENERATED_DIR);
    }

    public File getPolicyDir() {
        return new File(this.getGeneratedDir(), POLICY_DIR);
    }

    public File getJspRootDir() {
        return new File(this.getGeneratedDir(), JSP_DIR);
    }

    public File getEjbRootDir() {
        return new File(this.getGeneratedDir(), EJB_DIR);
    }

    public File getXmlRootDir() {
        return new File(this.getGeneratedDir(), XML_DIR);
    }

    public File getRepositoryDir() {
        return new File(this.getRepositoryRootDir(), this.getConfig().getRepositoryName());
    }

    public File getDomainConfigFile() {
        return new File(this.getConfigRoot(), DOMAIN_XML_FILE);
    }

    public File getDomainConfigBackupFile() {
        return new File(this.getRepositoryBackupRoot(), DOMAIN_XML_FILE);
    }

    public File getImqDir() {
        return new File(this.getInstallRootDir(), "imq");
    }

    public File getJbiDir() {
        return new File(this.getInstallRootDir(), "jbi");
    }

    public File getJbiLibDir() {
        return new File(this.getJbiDir(), "lib");
    }

    public File getJbiLibInstallDir() {
        return new File(this.getJbiLibDir(), "install");
    }

    public File getJbiTemplateDir() {
        return new File(this.getJbiLibInstallDir(), "templates");
    }

    public File getJbiTemplateFile() {
        return new File(this.getJbiTemplateDir(), JBI_TEMPLATE_FILE);
    }

    public File getJbiInstanceDir() {
        return new File(this.getRepositoryDir(), "jbi");
    }

    public File getJbiComponentsDir() {
        return new File(this.getJbiInstanceDir(), "components");
    }

    public File getJavaEESEDir() {
        return new File(this.getJbiComponentsDir(), JAVAEE_SE_DIR);
    }

    public File getHttpBcDir() {
        return new File(this.getJbiComponentsDir(), HTTP_BC_DIR);
    }

    public File getJavaEESEWorkSpace() {
        return new File(this.getJavaEESEDir(), JBI_COMPONENT_WS);
    }

    public File getHttpBcWorkSpace() {
        return new File(this.getHttpBcDir(), JBI_COMPONENT_WS);
    }

    public File getJbiSharedLibDir() {
        return new File(this.getJbiInstanceDir(), "shared-libraries");
    }

    public File getJbiConfigDir() {
        return new File(this.getJbiInstanceDir(), "config");
    }

    public File getJbiAuotoInstallDir() {
        return new File(this.getJbiInstanceDir(), JBI_AUTOINSTALL_DIR);
    }

    public File getJbiConfigPrivateDir() {
        return new File(this.getJbiConfigDir(), JBI_CONFIG_PRIVATE_DIR);
    }

    public File getJbiRegistryFile() {
        return new File(this.getJbiConfigDir(), JBI_REGISTRY_FILE);
    }

    public File getHttpBcConfigTemplate() {
        return new File(this.getJbiTemplateDir(), HTTP_BC_CONFIG);
    }

    public File getHttpBcConfigFile() {
        return new File(this.getHttpBcWorkSpace(), HTTP_BC_CONFIG);
    }

    public File getImqVarHome() {
        return new File(this.getRepositoryDir(), "imq");
    }

    public File getImqBinDir() {
        return new File(this.getImqDir(), BIN_DIR);
    }

    public File getImqLibDir() {
        return new File(this.getImqDir(), "lib");
    }

    public File getInstallRootDir() {
        return this.getCanonicalFile(new File(this.getConfig().getInstallRoot()));
    }

    public File getRepositoryRootDir() {
        return this.getCanonicalFile(new File(this.getConfig().getRepositoryRoot()));
    }

    public File getShareDir() {
        return new File(this.getInstallRootDir(), SHARE);
    }

    public File getWebServicesLibDir() {
        return new File(this.getShareDir(), "lib");
    }

    public File getTemplatesDir() {
        File lib = new File(this.getInstallRootDir(), "lib");
        File templates = new File(lib, "templates");
        return templates;
    }

    public File getProfileFolder(String profileName) {
        assert (profileName != null) : "Name of the profile can't be null";
        File pf = new File(this.getTemplatesDir(), profileName);
        return pf;
    }

    public File getProfilePropertiesFile(String profileName) {
        return new File(this.getProfileFolder(profileName), PROFILE_PROPERTIES);
    }

    public File getPreExistingDomainXmlTemplateForProfile(String profileName) {
        return new File(this.getProfileFolder(profileName), DOMAIN_XML_FILE);
    }

    public File getTemplateConfigXml() {
        return new File(this.getTemplatesDir(), TEMPLATE_CONFIG_XML);
    }

    public File getInstallApplicationsDir() {
        File lib = new File(this.getInstallRootDir(), "lib");
        File install = new File(lib, "install");
        return new File(install, "applications");
    }

    public File getInstallDatabasesDir() {
        File lib = new File(this.getInstallRootDir(), "lib");
        File install = new File(lib, "install");
        return new File(install, "databases");
    }

    public File getDtdsDir() {
        File lib = new File(this.getInstallRootDir(), "lib");
        return new File(lib, DTDS_DIR);
    }

    public File getDomainXmlTemplate() {
        return new File(this.getTemplatesDir(), DOMAIN_XML_TEMPLATE);
    }

    public File getDomainXmlTemplate(String templateName) {
        if (new File(templateName).isAbsolute()) {
            return new File(templateName);
        }
        return new File(this.getTemplatesDir(), templateName);
    }

    public File getImqBrokerExecutable() {
        return new File(this.getImqBinDir(), IMQBROKERD);
    }

    public File getStartServ() {
        return new File(this.getBinDir(), START_SERV_OS);
    }

    public File getStartServTemplate() {
        return new File(this.getTemplatesDir(), START_SERV_TEMPLATE_OS);
    }

    public File getStopServ() {
        return new File(this.getBinDir(), STOP_SERV_OS);
    }

    public File getKillServ() {
        return new File(this.getBinDir(), KILL_SERV_OS);
    }

    public File getKillServTemplate() {
        return new File(this.getTemplatesDir(), KILL_SERV_OS);
    }

    public File getStopServTemplate() {
        return new File(this.getTemplatesDir(), STOP_SERV_TEMPLATE_OS);
    }

    public File getPolicyFileTemplate() {
        return new File(this.getTemplatesDir(), POLICY_FILE);
    }

    public File getPolicyFile() {
        return new File(this.getConfigRoot(), POLICY_FILE);
    }

    public File getStubFile() {
        return new File(this.getConfigRoot(), STUB_FILE);
    }

    public File getSeedFile() {
        return new File(this.getConfigRoot(), SEED_FILE);
    }

    public File getInstallConfigRoot() {
        return new File(this.getInstallRootDir(), "config");
    }

    public Map<File, File> getAppClientContainerTemplateAndXml() {
        HashMap<File, File> result = new HashMap<File, File>();
        result.put(new File(this.getTemplatesDir(), "glassfish-acc.xml"), new File(this.getConfigRoot(), "glassfish-acc.xml"));
        return result;
    }

    public File getSessionStore() {
        return new File(this.getRepositoryDir(), SESSION_STORE);
    }

    public File getAutoDeployDir() {
        return new File(this.getRepositoryDir(), AUTO_DEPLOY);
    }

    public File getAutoDeployStatusDir() {
        return new File(this.getAutoDeployDir(), AUTO_DEPLOY_STATUS);
    }

    public File getKeyFileTemplate() {
        return new File(this.getTemplatesDir(), "keyfile");
    }

    public File getKeyFile() {
        return new File(this.getConfigRoot(), "keyfile");
    }

    public File getAdminKeyFile() {
        return new File(this.getConfigRoot(), ADMIN_KEY_FILE);
    }

    public File getBackupKeyFile() {
        return new File(this.getRepositoryBackupRoot(), "keyfile");
    }

    public File getIndexFileTemplate() {
        File docRoot = new File(this.getTemplatesDir(), "docroot");
        return new File(docRoot, INDEX_FILE);
    }

    public File getNonEnglishIndexFileTemplate(Locale locale) {
        File locales = new File(this.getTemplatesDir(), LOCALES);
        File givenLocale = new File(locales, locale.toString());
        return new File(givenLocale, INDEX_FILE);
    }

    public File getIndexFile() {
        return new File(this.getDocRoot(), INDEX_FILE);
    }

    public File getEnglishIndexFile() {
        return new File(this.getDocRoot(), ENGLISH_INDEX_FILE);
    }

    public File getDefaultWebXmlTemplate() {
        return new File(this.getTemplatesDir(), DEFAULT_WEB_XML);
    }

    public File getDefaultWebXml() {
        return new File(this.getConfigRoot(), DEFAULT_WEB_XML);
    }

    public File getLoggingPropertiesTemplate() {
        return new File(this.getTemplatesDir(), LOGGING_PROPERTIES_FILE);
    }

    public File getLoggingProperties() {
        return new File(this.getConfigRoot(), LOGGING_PROPERTIES_FILE);
    }

    public File getLoginConfTemplate() {
        return new File(this.getTemplatesDir(), LOGIN_CONF);
    }

    public File getLoginConf() {
        return new File(this.getConfigRoot(), LOGIN_CONF);
    }

    public File getWssServerConfigOldTemplate() {
        return new File(this.getTemplatesDir(), WSSSERVERCONFIGOLD);
    }

    public File getWssServerConfigOld() {
        return new File(this.getConfigRoot(), WSSSERVERCONFIGOLD);
    }

    public File getWssServerConfigTemplate() {
        return new File(this.getTemplatesDir(), WSSSERVERCONFIG);
    }

    public File getWssServerConfig() {
        return new File(this.getConfigRoot(), WSSSERVERCONFIG);
    }

    public File getKeyStore() {
        return new File(this.getConfigRoot(), KEYSTORE);
    }

    public File getTrustStoreTemplate() {
        return new File(this.getTemplatesDir(), "cacerts.jks");
    }

    public File getKeyStoreTemplate() {
        return new File(this.getTemplatesDir(), KEYSTORE);
    }

    public File getTrustStore() {
        return new File(this.getConfigRoot(), "cacerts.jks");
    }

    public File getMasterPasswordFile() {
        return new File(this.getRepositoryDir(), MASTERPASSWORD_FILE);
    }

    public File getPasswordAliasKeystore() {
        return new File(this.getConfigRoot(), PASSWORD_ALIAS_KEYSTORE);
    }

    public File getTimerWalTemplate() {
        return new File(this.getInstallDatabasesDir(), "ejbtimer$1.wal");
    }

    public File getTimerWal() {
        return new File(this.getTimerDatabaseDir(), "ejbtimer$1.wal");
    }

    public File getTimerDbnTemplate() {
        return new File(this.getInstallDatabasesDir(), "ejbtimer.dbn");
    }

    public File getTimerDbn() {
        return new File(this.getTimerDatabaseDir(), "ejbtimer.dbn");
    }

    public File getDerbyEjbTimerSqlFile() {
        return new File(this.getInstallDatabasesDir(), DERBY_SQL_FILE);
    }

    public File getDerbyEjbTimerDatabaseDirectory() {
        return new File(this.getTimerDatabaseDir(), DERBY_DATABASE_DIRECTORY);
    }

    protected static boolean isWindows() {
        return OS.isWindows();
    }

    File getCanonicalFile(File f) {
        return FileUtils.safeGetCanonicalFile(f);
    }

    public void createJbiSystemComponentsLayout() throws RepositoryException {
        try {
            this.createDirectory(this.getHttpBcDir());
            this.createDirectory(this.getHttpBcInstallRoot());
            this.createDirectory(this.getJavaEESEDir());
            this.createDirectory(this.getJavaEESEInstallRoot());
            this.createDirectory(this.getWSDLSLDir());
            this.createDirectory(this.getWSDLSLInstallRoot());
            this.createDirectory(this.getHttpBcWorkSpace());
            this.createDirectory(this.getJavaEESEWorkSpace());
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
    }

    public void createWSDLSLInstallRoot() throws Exception {
        this.createDirectory(this.getWSDLSLDir());
        this.createDirectory(this.getWSDLSLInstallRoot());
    }

    public File getJbiComponents() {
        return new File(this.getJbiDir(), "components");
    }

    public File getHttpBcArchiveSource() {
        File bcDir = new File(this.getJbiComponents(), HTTP_BC_DIR);
        return new File(bcDir, HTTP_BC_ARCHIVE);
    }

    public File getHttpBcArchiveDestination() {
        return new File(this.getHttpBcDir(), HTTP_BC_ARCHIVE);
    }

    public File getHttpBcInstallRoot() {
        return new File(this.getHttpBcDir(), JBI_COMPONENTS_INSTALL_ROOT);
    }

    public File getJavaEESEArchiveSource() {
        File seDir = new File(this.getJbiComponents(), JAVAEE_SE_DIR);
        return new File(seDir, JAVAEE_SE_ARCHIVE);
    }

    public File getJavaEESEArchiveDestination() {
        return new File(this.getJavaEESEDir(), JAVAEE_SE_ARCHIVE);
    }

    public File getJavaEESEInstallRoot() {
        return new File(this.getJavaEESEDir(), JBI_COMPONENTS_INSTALL_ROOT);
    }

    public File getJbiSharedLibraries() {
        return new File(this.getJbiDir(), "shared-libraries");
    }

    public File getWSDLSLDir() {
        return new File(this.getJbiSharedLibDir(), WSDLSL_DIR);
    }

    public File getWSDLSLArchiveSource() {
        File slDir = new File(this.getJbiSharedLibraries(), WSDLSL_DIR);
        return new File(slDir, WSDLSL_ARCHIVE);
    }

    public File getWSDLSLArchiveDestination() {
        return new File(this.getWSDLSLDir(), WSDLSL_ARCHIVE);
    }

    public File getWSDLSLInstallRoot() {
        return new File(this.getWSDLSLDir(), JBI_COMPONENTS_INSTALL_ROOT);
    }
}

