/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domain")
@PerLookup
public class StartDomainCommand
extends LocalDomainCommand
implements StartServerCommand {
    private GFLauncherInfo info;
    private GFLauncher launcher;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dry_run;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private boolean drop_interrupted_commands;
    @Inject
    ServerEnvironment senv;
    private static final LocalStringsImpl strings = new LocalStringsImpl(StartDomainCommand.class);
    private StartServerHelper helper;
    private String newpwName = Environment.getPrefix() + "NEWPASSWORD";

    @Override
    public List<String> getLauncherArgs() {
        return this.launcher.getCommandLine();
    }

    @Override
    public RuntimeType getType() {
        return RuntimeType.DAS;
    }

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.setDomainName(this.domainName0);
        super.validate();
    }

    @Override
    protected int executeCommand() throws CommandException {
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv, this.debug);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            if (!this.upgrade && this.launcher.needsManualUpgrade()) {
                logger.info(strings.get("manualUpgradeNeeded"));
                return 1;
            }
            this.doAutoUpgrade(mpv);
            if (this.dry_run) {
                logger.fine(Strings.get("dry_run_msg"));
                List<String> cmd = this.launcher.getCommandLine();
                StringBuilder sb = new StringBuilder();
                for (String s : cmd) {
                    sb.append(s);
                    sb.append('\n');
                }
                logger.info(sb.toString());
                return 0;
            }
            this.doAdminPasswordCheck();
            this.launcher.launch();
            if (this.verbose || this.upgrade || this.watchdog) {
                while (true) {
                    int returnValue = this.launcher.getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(strings.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(strings.get("restartChangeDebug", "on"));
                            this.info.setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(strings.get("restartChangeDebug", "off"));
                            this.info.setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (this.env.debug()) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
            }
            this.helper.waitForServer();
            this.helper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    @Override
    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.launcher = GFLauncherFactory.getInstance(this.getType());
        this.info = this.launcher.getInfo();
        this.info.setDomainName(this.getDomainName());
        this.info.setDomainParentDir(this.getDomainsDir().getPath());
        this.info.setVerbose(this.verbose || this.upgrade);
        this.info.setDebug(this.debug);
        this.info.setUpgrade(this.upgrade);
        this.info.setWatchdog(this.watchdog);
        this.info.setDropInterruptedCommands(this.drop_interrupted_commands);
        this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.launcher.setup();
    }

    private String[] respawnArgs() {
        ArrayList<String> args = new ArrayList<String>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--watchdog=" + String.valueOf(this.watchdog));
        args.add("--debug=" + String.valueOf(this.debug));
        args.add("--domaindir");
        args.add(this.getDomainsDir().toString());
        if (StartDomainCommand.ok(this.getDomainName())) {
            args.add(this.getDomainName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Respawn args: {0}", ((Object)args).toString());
        }
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug(String s) {
        try (PrintStream ps = null;){
            ps = new PrintStream(new FileOutputStream("startdomain.txt", true));
            ps.println(new Date().toString() + ":  " + s);
        }
    }

    private void doAutoUpgrade(String mpv) throws GFLauncherException, MiniXmlParserException, CommandException {
        if (this.upgrade || !this.launcher.needsAutoUpgrade()) {
            return;
        }
        logger.info(strings.get("upgradeNeeded"));
        this.info.setUpgrade(true);
        this.launcher.setup();
        this.launcher.launch();
        Process p = this.launcher.getProcess();
        int exitCode = -1;
        try {
            exitCode = p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (exitCode != 0) {
            ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
            String output = psd.getOutErrString();
            if (StartDomainCommand.ok(output)) {
                throw new CommandException(strings.get("upgradeFailedOutput", this.info.getDomainName(), exitCode, output));
            }
            throw new CommandException(strings.get("upgradeFailed", this.info.getDomainName(), exitCode));
        }
        logger.info(strings.get("upgradeSuccessful"));
        this.createLauncher();
    }

    private void doAdminPasswordCheck() throws CommandException {
        String arfile = this.launcher.getAdminRealmKeyFile();
        if (arfile != null) {
            try {
                FileRealmHelper ar = new FileRealmHelper(arfile);
                if (!ar.hasAuthenticatableUser()) {
                    Set<String> names = ar.getUserNames();
                    if (names == null || names.isEmpty()) {
                        throw new CommandException("no admin users");
                    }
                    String auser = names.iterator().next();
                    CommandModelData.ParamModelData npwo = new CommandModelData.ParamModelData(this.newpwName, String.class, false, null);
                    npwo.prompt = strings.get("new.adminpw", auser);
                    npwo.promptAgain = strings.get("new.adminpw.again", auser);
                    npwo.param._password = true;
                    logger.info(strings.get("new.adminpw.prompt"));
                    String npw = super.getPassword(npwo, null, true);
                    if (npw == null) {
                        throw new CommandException(strings.get("no.console"));
                    }
                    ar.updateUser(auser, auser, npw.toCharArray(), null);
                    ar.persist();
                }
            }
            catch (IOException ioe) {
                throw new CommandException(ioe);
            }
        }
    }
}

