/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.impl.NormalResponse;
import com.hazelcast.spi.impl.RemotePropagatable;
import com.hazelcast.spi.impl.Response;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ResponseHandlerFactory {
    private static final NoResponseHandler NO_RESPONSE_HANDLER = new NoResponseHandler();

    private ResponseHandlerFactory() {
    }

    public static void setRemoteResponseHandler(NodeEngine nodeEngine, RemotePropagatable remotePropagatable) {
        remotePropagatable.setResponseHandler(ResponseHandlerFactory.createRemoteResponseHandler(nodeEngine, remotePropagatable));
    }

    public static ResponseHandler createRemoteResponseHandler(NodeEngine nodeEngine, RemotePropagatable remotePropagatable) {
        if (remotePropagatable.getCallId() == 0L) {
            if (remotePropagatable.returnsResponse()) {
                throw new HazelcastException("Op: " + remotePropagatable.getClass().getName() + " can not return response without call-id!");
            }
            return NO_RESPONSE_HANDLER;
        }
        return new RemoteInvocationResponseHandler(nodeEngine, remotePropagatable);
    }

    public static ResponseHandler createEmptyResponseHandler() {
        return NO_RESPONSE_HANDLER;
    }

    public static ResponseHandler createErrorLoggingResponseHandler(ILogger logger2) {
        return new ErrorLoggingResponseHandler(logger2);
    }

    private static final class RemoteInvocationResponseHandler
    implements ResponseHandler {
        private final NodeEngine nodeEngine;
        private final RemotePropagatable remotePropagatable;
        private final AtomicBoolean sent = new AtomicBoolean(false);

        private RemoteInvocationResponseHandler(NodeEngine nodeEngine, RemotePropagatable remotePropagatable) {
            this.nodeEngine = nodeEngine;
            this.remotePropagatable = remotePropagatable;
        }

        @Override
        public void sendResponse(Object obj) {
            long callId = this.remotePropagatable.getCallId();
            Connection conn = this.remotePropagatable.getConnection();
            if (!this.sent.compareAndSet(false, true) && !(obj instanceof Throwable)) {
                throw new ResponseAlreadySentException("NormalResponse already sent for call: " + callId + " to " + conn.getEndPoint() + ", current-response: " + obj);
            }
            Response response = !(obj instanceof Response) ? new NormalResponse(obj, this.remotePropagatable.getCallId(), 0, this.remotePropagatable.isUrgent()) : (Response)obj;
            OperationService operationService = this.nodeEngine.getOperationService();
            if (!operationService.send(response, this.remotePropagatable.getCallerAddress())) {
                throw new HazelcastException("Cannot send response: " + obj + " to " + conn.getEndPoint());
            }
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    private static final class ErrorLoggingResponseHandler
    implements ResponseHandler {
        private final ILogger logger;

        private ErrorLoggingResponseHandler(ILogger logger2) {
            this.logger = logger2;
        }

        @Override
        public void sendResponse(Object obj) {
            if (obj instanceof Throwable) {
                Throwable t = (Throwable)obj;
                this.logger.severe(t);
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    private static class NoResponseHandler
    implements ResponseHandler {
        private NoResponseHandler() {
        }

        @Override
        public void sendResponse(Object obj) {
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }
}

