/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.RemotePropagatable;
import java.util.logging.Level;

class RemoteOperationExceptionHandler
implements RemotePropagatable<RemoteOperationExceptionHandler> {
    private ResponseHandler responseHandler;
    private Address callerAddress;
    private Connection connection;
    private NodeEngine nodeEngine;
    private long callId;

    RemoteOperationExceptionHandler() {
    }

    RemoteOperationExceptionHandler(long callId) {
        this.callId = callId;
    }

    @Override
    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public RemoteOperationExceptionHandler setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    @Override
    public long getCallId() {
        return this.callId;
    }

    @Override
    public boolean returnsResponse() {
        return this.callId != 0L;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isUrgent() {
        return true;
    }

    @Override
    public Address getCallerAddress() {
        return this.callerAddress;
    }

    @Override
    public void logError(Throwable t) {
        ILogger logger2 = Logger.getLogger(RemoteOperationExceptionHandler.class);
        if (t instanceof RetryableException) {
            Level level;
            Level level2 = level = this.returnsResponse() ? Level.FINEST : Level.WARNING;
            if (logger2.isLoggable(level)) {
                logger2.log(level, t.getClass().getName() + ": " + t.getMessage());
            }
        } else if (t instanceof OutOfMemoryError) {
            try {
                logger2.log(Level.SEVERE, t.getMessage(), t);
            }
            catch (Throwable ignored) {
                logger2.log(Level.SEVERE, ignored.getMessage(), t);
            }
        } else {
            Level level;
            Level level3 = level = this.nodeEngine != null && this.nodeEngine.isActive() ? Level.SEVERE : Level.FINEST;
            if (logger2.isLoggable(level)) {
                logger2.log(level, t.getMessage(), t);
            }
        }
    }

    void setCallerAddress(Address callerAddress) {
        this.callerAddress = callerAddress;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    void setNodeEngine(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }
}

