/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.instance.GroupProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.Operation;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BasicBackPressureService {
    static final float RANGE = 0.25f;
    private static final ThreadLocal<Random> THREAD_LOCAL_RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private final ConcurrentMap<Object, AtomicInteger[]> syncDelaysPerConnection = new ConcurrentHashMap<Object, AtomicInteger[]>();
    private final boolean backPressureEnabled;
    private final int syncWindow;
    private final int partitionCount;

    public BasicBackPressureService(GroupProperties properties, ILogger logger2) {
        this.backPressureEnabled = properties.BACKPRESSURE_ENABLED.getBoolean();
        this.partitionCount = properties.PARTITION_COUNT.getInteger();
        this.syncWindow = this.getSyncWindow(properties);
        if (this.backPressureEnabled) {
            logger2.info("Backpressure is enabled, syncWindow is " + this.syncWindow);
        } else {
            logger2.info("Backpressure is disabled");
        }
    }

    private int getSyncWindow(GroupProperties properties) {
        int syncWindow = properties.BACKPRESSURE_SYNCWINDOW.getInteger();
        if (this.backPressureEnabled && syncWindow < 1) {
            throw new IllegalArgumentException("Can't have '" + properties.BACKPRESSURE_SYNCWINDOW.getName() + "' with a value smaller than 1");
        }
        return syncWindow;
    }

    boolean isBackPressureEnabled() {
        return this.backPressureEnabled;
    }

    AtomicInteger[] getSyncDelays(Connection connection) {
        Object key = connection == null ? this : connection;
        return (AtomicInteger[])this.syncDelaysPerConnection.get(key);
    }

    AtomicInteger getSyncDelay(Connection connection, int partitionId) {
        Object key = connection == null ? this : connection;
        AtomicInteger[] syncDelays = (AtomicInteger[])this.syncDelaysPerConnection.get(key);
        if (syncDelays == null) {
            return null;
        }
        partitionId = partitionId == -1 ? this.partitionCount : partitionId;
        return syncDelays[partitionId];
    }

    public boolean isBackPressureNeeded(Operation op) {
        if (!this.backPressureEnabled) {
            return false;
        }
        if (op.isUrgent()) {
            return false;
        }
        AtomicInteger syncDelay = this.getSyncDelay(op);
        int currentSyncDelay = syncDelay.get();
        if (currentSyncDelay > 0) {
            syncDelay.decrementAndGet();
            return false;
        }
        syncDelay.set(this.calcSyncDelay());
        return true;
    }

    private AtomicInteger getSyncDelay(Operation op) {
        int partitionId;
        Object key = this.getConnectionKey(op);
        AtomicInteger[] syncDelayPerPartition = (AtomicInteger[])this.syncDelaysPerConnection.get(key);
        if (syncDelayPerPartition == null) {
            AtomicInteger[] newSyncDelayPerPartition = new AtomicInteger[this.partitionCount + 1];
            for (int k = 0; k < newSyncDelayPerPartition.length; ++k) {
                newSyncDelayPerPartition[k] = new AtomicInteger(this.syncWindow);
            }
            AtomicInteger[] found = this.syncDelaysPerConnection.putIfAbsent(key, newSyncDelayPerPartition);
            AtomicInteger[] atomicIntegerArray = syncDelayPerPartition = found != null ? found : newSyncDelayPerPartition;
        }
        if ((partitionId = op.getPartitionId()) < 0) {
            return syncDelayPerPartition[this.partitionCount];
        }
        return syncDelayPerPartition[partitionId];
    }

    private Object getConnectionKey(Operation op) {
        Connection connection = op.getConnection();
        return connection == null ? this : connection;
    }

    public void cleanup() {
        if (!this.backPressureEnabled) {
            return;
        }
        for (Map.Entry entry : this.syncDelaysPerConnection.entrySet()) {
            Connection connection;
            Object key = entry.getKey();
            if (!(key instanceof Connection) || (connection = (Connection)key).isAlive()) continue;
            this.syncDelaysPerConnection.remove(key);
        }
    }

    private int calcSyncDelay() {
        Random random = THREAD_LOCAL_RANDOM.get();
        return Math.round(0.75f * (float)this.syncWindow + (float)random.nextInt(Math.round(0.5f * (float)this.syncWindow)));
    }
}

