/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.IOSelectorOutOfMemoryHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class AbstractIOSelector
extends Thread
implements IOSelector {
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 3;
    private static final int SELECT_WAIT_TIME_MILLIS = 5000;
    private static final int SELECT_FAILURE_PAUSE_MILLIS = 1000;
    protected final ILogger logger;
    protected final Queue<Runnable> selectorQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final int waitTime;
    protected final Selector selector;
    protected boolean live = true;
    private final IOSelectorOutOfMemoryHandler oomeHandler;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public AbstractIOSelector(ThreadGroup threadGroup, String tname, ILogger logger2, IOSelectorOutOfMemoryHandler oomeHandler) {
        super(threadGroup, tname);
        this.logger = logger2;
        this.oomeHandler = oomeHandler;
        this.waitTime = 5000;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new HazelcastException("Failed to open a Selector", e);
        }
    }

    @Override
    public final void shutdown() {
        this.selectorQueue.clear();
        try {
            this.addTask(new Runnable(){

                @Override
                public void run() {
                    AbstractIOSelector.this.live = false;
                    AbstractIOSelector.this.shutdownLatch.countDown();
                }
            });
            this.interrupt();
        }
        catch (Throwable t) {
            Logger.getLogger(AbstractIOSelector.class).finest("Exception while waiting for shutdown", t);
        }
    }

    @Override
    public final void awaitShutdown() {
        try {
            this.shutdownLatch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException t) {
            Logger.getLogger(AbstractIOSelector.class).finest("Exception while waiting for shutdown", t);
        }
    }

    @Override
    public final void addTask(Runnable runnable) {
        this.selectorQueue.add(runnable);
    }

    private void processSelectionQueue() {
        while (this.live) {
            Runnable runnable = this.selectorQueue.poll();
            if (runnable == null) {
                return;
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (this.live) {
                int selectedKeyCount;
                this.processSelectionQueue();
                if (!this.live || this.isInterrupted()) {
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest(this.getName() + " is interrupted!");
                    }
                    this.live = false;
                    return;
                }
                try {
                    selectedKeyCount = this.selector.select(this.waitTime);
                }
                catch (Throwable e) {
                    this.handleSelectFailure(e);
                    continue;
                }
                if (selectedKeyCount == 0) continue;
                this.handleSelectionKeys();
            }
        }
        catch (OutOfMemoryError e) {
            this.oomeHandler.handle(e);
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            try {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Closing selector " + this.getName());
                }
                this.selector.close();
            }
            catch (Exception e) {
                Logger.getLogger(AbstractIOSelector.class).finest("Exception while closing selector", e);
            }
        }
    }

    protected abstract void handleSelectionKey(SelectionKey var1);

    private void handleSelectionKeys() {
        Set<SelectionKey> setSelectedKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> it = setSelectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            try {
                this.handleSelectionKey(sk);
            }
            catch (Throwable e) {
                this.handleSelectionKeyFailure(e);
            }
        }
    }

    private void handleSelectionKeyFailure(Throwable e) {
        String msg = "Selector exception at  " + this.getName() + ", cause= " + e.toString();
        this.logger.warning(msg, e);
        if (e instanceof OutOfMemoryError) {
            this.oomeHandler.handle((OutOfMemoryError)e);
        }
    }

    @Override
    public final Selector getSelector() {
        return this.selector;
    }

    @Override
    public final void wakeup() {
        this.selector.wakeup();
    }

    private void handleSelectFailure(Throwable e) {
        this.logger.warning(e.toString(), e);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            Thread.currentThread().interrupt();
        }
    }
}

