/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionSerializer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.PortableContext;
import java.nio.ByteBuffer;

public class DataAdapter
implements SocketWritable,
SocketReadable {
    private static final int ST_TYPE = 1;
    private static final int ST_SIZE = 2;
    private static final int ST_VALUE = 3;
    private static final int ST_HASH = 4;
    private static final int ST_ALL = 5;
    protected Data data;
    protected PortableContext context;
    private short status;
    private ByteBuffer buffer;
    private ClassDefinitionSerializer classDefinitionSerializer;

    public DataAdapter(PortableContext context) {
        this.context = context;
    }

    public DataAdapter(Data data, PortableContext context) {
        this.data = data;
        this.context = context;
    }

    @Override
    public boolean isUrgent() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (!this.isStatusSet(1)) {
            if (destination.remaining() < 5) {
                return false;
            }
            int type2 = this.data.getType();
            destination.putInt(type2);
            boolean hasClassDefinition = this.context.hasClassDefinition(this.data);
            destination.put((byte)(hasClassDefinition ? 1 : 0));
            if (hasClassDefinition) {
                this.classDefinitionSerializer = new ClassDefinitionSerializer(this.data, this.context);
            }
            this.setStatus(1);
        }
        if (this.classDefinitionSerializer != null && !this.classDefinitionSerializer.write(destination)) {
            return false;
        }
        if (!this.isStatusSet(4)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.hasPartitionHash() ? this.data.getPartitionHash() : 0);
            this.setStatus(4);
        }
        if (!this.isStatusSet(2)) {
            if (destination.remaining() < 4) {
                return false;
            }
            int size = this.data.dataSize();
            destination.putInt(size);
            this.setStatus(2);
            if (size <= 0) {
                this.setStatus(3);
            } else {
                this.buffer = ByteBuffer.wrap(this.data.getData());
            }
        }
        if (!this.isStatusSet(3)) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.setStatus(3);
        }
        this.setStatus(5);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        if (this.data == null) {
            this.data = new DefaultData();
        }
        if (!this.isStatusSet(1)) {
            boolean hasClassDefinition;
            if (source.remaining() < 5) {
                return false;
            }
            int type2 = source.getInt();
            ((DefaultData)this.data).setType(type2);
            this.setStatus(1);
            boolean bl = hasClassDefinition = source.get() != 0;
            if (hasClassDefinition) {
                this.classDefinitionSerializer = new ClassDefinitionSerializer(this.data, this.context);
            }
        }
        if (this.classDefinitionSerializer != null && !this.classDefinitionSerializer.read(source)) {
            return false;
        }
        if (!this.isStatusSet(4)) {
            if (source.remaining() < 4) {
                return false;
            }
            ((DefaultData)this.data).setPartitionHash(source.getInt());
            this.setStatus(4);
        }
        if (!this.isStatusSet(2)) {
            if (source.remaining() < 4) {
                return false;
            }
            int size = source.getInt();
            this.buffer = ByteBuffer.allocate(size);
            this.setStatus(2);
        }
        if (!this.isStatusSet(3)) {
            IOUtil.copyToHeapBuffer(source, this.buffer);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.buffer.flip();
            ((DefaultData)this.data).setData(this.buffer.array());
            this.setStatus(3);
        }
        this.setStatus(5);
        return true;
    }

    protected final void setStatus(int bit) {
        this.status = (short)(this.status | 1 << bit);
    }

    protected final boolean isStatusSet(int bit) {
        return (this.status & 1 << bit) != 0;
    }

    public final Data getData() {
        return this.data;
    }

    public final void setData(Data data) {
        this.data = data;
    }

    public boolean done() {
        return this.isStatusSet(5);
    }

    public void reset() {
        this.buffer = null;
        this.data = null;
        this.status = 0;
        this.classDefinitionSerializer = null;
    }

    public static int getDataSize(Data data, PortableContext context) {
        int total = 4;
        ++total;
        if (context.hasClassDefinition(data)) {
            ClassDefinition[] classDefinitions = context.getClassDefinitions(data);
            if (classDefinitions == null || classDefinitions.length == 0) {
                throw new HazelcastSerializationException("ClassDefinition could not be found!");
            }
            total += 4;
            for (ClassDefinition classDef : classDefinitions) {
                total += 4;
                total += 4;
                total += 4;
                total += 4;
                byte[] bytes = ((BinaryClassDefinition)classDef).getBinary();
                total += bytes.length;
            }
        }
        total += 4;
        total += 4;
        return total += data.dataSize();
    }
}

