/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore;

import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.EmptyMapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writethrough.WriteThroughStore;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.NodeEngine;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class MapDataStores {
    private MapDataStores() {
    }

    public static <K, V> MapDataStore<K, V> createWriteBehindStore(MapStoreContext mapStoreContext, int partitionId, WriteBehindProcessor writeBehindProcessor) {
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        SerializationService serializationService = mapServiceContext.getNodeEngine().getSerializationService();
        MapStoreConfig mapStoreConfig = mapStoreContext.getMapStoreConfig();
        int writeDelaySeconds = mapStoreConfig.getWriteDelaySeconds();
        long writeDelayMillis = TimeUnit.SECONDS.toMillis(writeDelaySeconds);
        boolean writeCoalescing = mapStoreConfig.isWriteCoalescing();
        WriteBehindStore mapDataStore = new WriteBehindStore(store, serializationService, writeDelayMillis, partitionId);
        WriteBehindQueue writeBehindQueue = MapDataStores.newWriteBehindQueue(mapServiceContext, writeCoalescing);
        mapDataStore.setWriteBehindQueue(writeBehindQueue);
        mapDataStore.setWriteBehindProcessor(writeBehindProcessor);
        return mapDataStore;
    }

    private static WriteBehindQueue newWriteBehindQueue(MapServiceContext mapServiceContext, boolean writeCoalescing) {
        int capacity = mapServiceContext.getNodeEngine().getGroupProperties().MAP_WRITE_BEHIND_QUEUE_CAPACITY.getInteger();
        AtomicInteger counter = mapServiceContext.getWriteBehindQueueItemCounter();
        return writeCoalescing ? WriteBehindQueues.createDefaultWriteBehindQueue() : WriteBehindQueues.createSafeBoundedArrayWriteBehindQueue(capacity, counter);
    }

    public static <K, V> MapDataStore<K, V> createWriteThroughStore(MapStoreContext mapStoreContext) {
        MapStoreWrapper store = mapStoreContext.getMapStoreWrapper();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        SerializationService serializationService = nodeEngine.getSerializationService();
        return new WriteThroughStore(store, serializationService);
    }

    public static <K, V> MapDataStore<K, V> emptyStore() {
        return EmptyStoreHolder.EMPTY;
    }

    private static class EmptyStoreHolder {
        static final MapDataStore EMPTY = new EmptyMapDataStore();

        private EmptyStoreHolder() {
        }
    }
}

